/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import oracle.bpm.project.model.processes.BpmnType;
import org.jetbrains.annotations.NotNull;

public class ActivityTypeHelper {
    public static int getActivityType(@NotNull String bpmnType) {
        try {
            return ActivityTypeHelper.getActivityType(BpmnType.valueOf((String)bpmnType));
        }
        catch (Exception exception) {
            return ActivityTypeHelper.getActivityType(ActivityTypeHelper.getBpmnType(bpmnType));
        }
    }

    public static int getActivityType(@NotNull BpmnType bpmnType) {
        switch (bpmnType) {
            case ABSTRACT_ACTIVITY: {
                throw new IllegalArgumentException("BpmnType not supported.");
            }
            case BOUNDARY_EVENT: {
                throw new IllegalArgumentException("BpmnType not supported.");
            }
            case BUSINESS_RULE_TASK: {
                return 0x800001;
            }
            case CALL_ACTIVITY: {
                return 0x800002;
            }
            case CATCH_INTERMEDIATE_EVENT: {
                return 0x80000E;
            }
            case COMPLEX_GATEWAY: {
                return 8388626;
            }
            case COUNTER: {
                throw new IllegalArgumentException("BpmnType not supported.");
            }
            case END_EVENT: {
                return 0x800003;
            }
            case EVENT: {
                throw new IllegalArgumentException("BpmnType not supported.");
            }
            case EVENT_BASED_GATEWAY: {
                return 0x800011;
            }
            case EXCLUSIVE_GATEWAY: {
                return 0x800004;
            }
            case INCLUSIVE_GATEWAY: {
                return 0x800005;
            }
            case MANUAL_TASK: {
                return 0x800010;
            }
            case MEASUREMENT: {
                throw new IllegalArgumentException("BpmnType not supported.");
            }
            case NOTE: {
                throw new IllegalArgumentException("BpmnType not supported.");
            }
            case PARALLEL_GATEWAY: {
                return 0x800006;
            }
            case RECEIVE_TASK: {
                return 0x800007;
            }
            case SCRIPT_TASK: {
                return 0x800008;
            }
            case SEND_TASK: {
                return 0x800009;
            }
            case SERVICE_TASK: {
                return 0x80000A;
            }
            case START_EVENT: {
                return 0x80000B;
            }
            case SUBPROCESS: {
                return 0x80000C;
            }
            case THROW_INTERMEDIATE_EVENT: {
                return 0x80000F;
            }
            case USER_TASK: {
                return 0x80000D;
            }
        }
        throw new IllegalArgumentException("Invalid BpmnType");
    }

    public static BpmnType getBpmnType(int activityType) {
        switch (activityType) {
            case 0x800001: {
                return BpmnType.BUSINESS_RULE_TASK;
            }
            case 0x800002: {
                return BpmnType.CALL_ACTIVITY;
            }
            case 0x80000E: {
                return BpmnType.CATCH_INTERMEDIATE_EVENT;
            }
            case 8388626: {
                return BpmnType.COMPLEX_GATEWAY;
            }
            case 0x800003: {
                return BpmnType.END_EVENT;
            }
            case 0x800011: {
                return BpmnType.EVENT_BASED_GATEWAY;
            }
            case 0x800004: {
                return BpmnType.EXCLUSIVE_GATEWAY;
            }
            case 0x800005: {
                return BpmnType.INCLUSIVE_GATEWAY;
            }
            case 0x800010: {
                return BpmnType.MANUAL_TASK;
            }
            case 8388627: 
            case 8388628: 
            case 8388629: {
                return BpmnType.MEASUREMENT;
            }
            case 0x800006: {
                return BpmnType.PARALLEL_GATEWAY;
            }
            case 0x800007: {
                return BpmnType.RECEIVE_TASK;
            }
            case 0x800008: {
                return BpmnType.SCRIPT_TASK;
            }
            case 0x800009: {
                return BpmnType.SEND_TASK;
            }
            case 0x80000A: {
                return BpmnType.SERVICE_TASK;
            }
            case 0x80000B: {
                return BpmnType.START_EVENT;
            }
            case 0x80000C: {
                return BpmnType.SUBPROCESS;
            }
            case 0x80000F: {
                return BpmnType.THROW_INTERMEDIATE_EVENT;
            }
            case 0x80000D: {
                return BpmnType.USER_TASK;
            }
        }
        throw new IllegalArgumentException("Unsupported activity type '" + activityType + "'.");
    }

    private static BpmnType getBpmnType(String bpmnTypeString) {
        if (bpmnTypeString != null) {
            for (BpmnType bpmnType : BpmnType.values()) {
                if (!bpmnType.getString().equalsIgnoreCase(bpmnTypeString)) continue;
                return bpmnType;
            }
        }
        throw new IllegalArgumentException("Invalid BPMN Type '" + bpmnTypeString + "'.");
    }
}

