/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import fuego.papi.Activity;
import fuego.papi.ArgumentSet;
import fuego.papi.Participant;
import fuego.papi.Process;
import fuego.papi.Task;
import fuego.papi.VarDefinition;
import fuego.papi.exception.InvalidTaskNumberException;
import fuego.papi.exception.InvalidVariableIdException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.Str;
import oracle.bpm.papi.ora.helper.RoleIdHelper;
import oracle.bpm.papi.ora.metadata.AdapterUtils;
import oracle.bpm.papi.ora.metadata.ArgumentSetAdapter;
import oracle.bpm.papi.ora.metadata.ProcessAdapter;
import oracle.bpm.papi.ora.metadata.TaskAdapter;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.FlowNodeAdapter;
import oracle.bpm.project.model.processes.FlowNodeHandler;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.processmetadata.TagListType;

public class ActivityAdapter
extends Activity {
    protected AdapterUtils.ActivityId activityId;
    private FlowNode flowNode;
    private boolean isDefaultRevision = false;
    private ProcessAdapter process;
    private TaskAdapter task;
    private TagListType tagList;
    private String applicationLinkDisplayName;
    private static final String MASK = "MASK";

    public ActivityAdapter(ProcessAdapter process, FlowNode flowNode) {
        this.process = process;
        this.flowNode = flowNode;
        this.activityId = AdapterUtils.ActivityId.createActivityId(process.getProcessComponentDN(), flowNode.getProcess().getName(), flowNode.getId());
        this.name_d = this.activityId.getActivityName();
        this.loadType();
        this.loadTask();
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public boolean hasType(int type) {
        if (type == 0x800001 && this.flowNode.isEvent() && ((Event)this.flowNode.asAnyNode(Event.class)).isCatchEvent()) {
            return ((Event)this.flowNode.asAnyNode(Event.class)).getEventTriggerType() == EventTriggerType.TIMER;
        }
        return super.hasType(type);
    }

    public boolean isAbortEnabled() {
        return false;
    }

    public boolean isActive() {
        return this.flowNode.isActive();
    }

    public String getActivityName() {
        return this.getName();
    }

    public boolean isAutoCompleteEnabled() {
        return true;
    }

    public String getDescription(Locale locale) {
        LocaleStringMap descriptions = this.flowNode.getDescriptionMap();
        String description = descriptions == null ? null : descriptions.getString(locale);
        return description != null ? description : this.getName();
    }

    @Deprecated
    public String getDocumentation(Locale locale) {
        return this.flowNode.getDocumentationMap() != null ? (String)this.flowNode.getDocumentationMap().get((Object)locale) : null;
    }

    public String getFolderName() {
        return this.getProcess().getFolderName().concat(File.separator).concat(this.getName());
    }

    public String getId() {
        return this.activityId.getIdString();
    }

    public String getProcessName() {
        return this.activityId.getProcessName();
    }

    public int getIn() {
        throw new UnsupportedOperationException("Method not supported : getIn");
    }

    public boolean isInstancePresentation() {
        return false;
    }

    public String getLabel(Locale locale) {
        String label = this.flowNode.getLabel(locale);
        if (Str.isEmpty((String)label)) {
            label = this.flowNode.getDefaultLabel();
        }
        return label;
    }

    public LocaleStringMap getLabels() {
        return this.flowNode.getLabelMap();
    }

    public boolean isOnline() {
        return this.process.isOnline();
    }

    public Process getProcess() {
        return this.process;
    }

    public String getProcessId() {
        return this.process.getId();
    }

    @Deprecated
    public boolean isResaignEnabled() {
        return this.isReassignEnabled();
    }

    public boolean isReassignEnabled() {
        return false;
    }

    public String getRole() {
        Lane lane = this.flowNode.getLane();
        if (lane == null) {
            return null;
        }
        if (!lane.isAutomatic()) {
            return this.process.getProcessComponentDN().getCompositeDN().getCompositeName() + "." + lane.getRole();
        }
        return null;
    }

    public boolean isSelectEnabled() {
        return false;
    }

    public boolean isLoopActivity() {
        return false;
    }

    public Activity[] getSourceActivitiesForGrab() {
        return new Activity[0];
    }

    public boolean isSuspendEnabled() {
        return false;
    }

    public Task getTask(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return this.task;
    }

    public Task getTask(String taskId) {
        return this.task != null && this.task.getId().equalsIgnoreCase(taskId) ? this.task : null;
    }

    public Task[] getTasks() {
        Task[] taskArray;
        if (this.task != null) {
            Task[] taskArray2 = new Task[1];
            taskArray = taskArray2;
            taskArray2[0] = this.task;
        } else {
            taskArray = new Task[]{};
        }
        return taskArray;
    }

    public boolean isUserSelectsTransitionEnabled() {
        return false;
    }

    public final Object getVar(String variableId, Locale locale) throws InvalidVariableIdException {
        if (variableId.equals("PREDEFINE_PROCESS")) {
            return this.getProcess().getLabel(locale);
        }
        if (variableId.equals("PREDEFINE_DESCRIPTION")) {
            return this.getDescription(locale);
        }
        if (variableId.equals("PREDEFINE_TASK")) {
            if (this.getTasks().length == 0) {
                return "";
            }
            return this.getTask(0).getLabel(locale);
        }
        throw new InvalidVariableIdException(variableId, true, this.getId());
    }

    public LocaleStringMap getDocumentationMap() {
        return this.flowNode.getDocumentationMap();
    }

    public VarDefinition[] getVars() {
        VarDefinition[] definitions = new VarDefinition[]{VarDefinition.getDefaultVarDefinition((String)"PREDEFINE_TASK"), VarDefinition.getDefaultVarDefinition((String)"PREDEFINE_DESCRIPTION"), VarDefinition.getDefaultVarDefinition((String)"PREDEFINE_PROCESS")};
        return definitions;
    }

    public boolean canBeGrabbedBy(Activity grabActivity) {
        return false;
    }

    public boolean canBeSeenByParticipant(Participant participant) {
        if (this.hasType(1) && !this.hasType(33)) {
            return false;
        }
        if (this.getRole() == null || "".equals(this.getRole())) {
            return true;
        }
        for (String role : participant.getRoles()) {
            if (!this.canBeSeenByRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean canBeSeenByRole(String role) {
        if (this.hasType(1) && !this.hasType(33)) {
            return false;
        }
        if (this.getRole() == null || "".equals(this.getRole())) {
            return true;
        }
        role = RoleIdHelper.getRoleNameFromRoleId(role);
        return role.equalsIgnoreCase(this.getRole());
    }

    public boolean canGrab(String sourceActivity) {
        return false;
    }

    public boolean containsDocumentation(Locale locale) {
        return this.getDocumentationMap() != null && this.getDocumentationMap().containsKey(locale);
    }

    public boolean hasInstanceAccess() {
        return false;
    }

    public boolean hasLocalDocumentation() {
        return this.getDocumentationMap() != null && !this.getDocumentationMap().isEmpty();
    }

    public boolean hasOutgoingTransitions() {
        for (SequenceFlow sequenceFlow : this.flowNode.getChildrenByType(SequenceFlow.class)) {
            if (!sequenceFlow.isNormalFlow() && !sequenceFlow.isConditionalFlow()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTransitionsToInteractiveActivities() {
        for (SequenceFlow sequenceFlow : this.flowNode.getChildrenByType(SequenceFlow.class)) {
            if (!sequenceFlow.isNormalFlow() && !sequenceFlow.isConditionalFlow() || sequenceFlow.getTarget().getBpmnType() != BpmnType.USER_TASK) continue;
            return true;
        }
        return false;
    }

    @Exclude
    public void setDocumentation(Locale locale, String html) {
        this.flowNode.getDocumentationMap().put(locale, html);
    }

    @Exclude
    public void setDocumentationMap(LocaleStringMap documentationMap) {
        this.flowNode.getDocumentationMap().putAll(documentationMap);
    }

    public String toString() {
        return "Activity[" + this.getType() + "]: " + this.getId();
    }

    public ArgumentSet[] getArgumentSets() {
        ArrayList<ArgumentSet> argumentSets = new ArrayList<ArgumentSet>();
        ModelUtils.handleFlowNode((FlowNode)this.flowNode, (FlowNodeHandler)new ArgumentSetHandler(argumentSets));
        return argumentSets.toArray(new ArgumentSet[argumentSets.size()]);
    }

    public void setIsDefaultRevision(boolean isDefaultRevision) {
        this.isDefaultRevision = isDefaultRevision;
    }

    public boolean isIsDefaultRevision() {
        return this.isDefaultRevision;
    }

    private void loadTask() {
        oracle.bpm.project.model.processes.Activity activity;
        if (this.flowNode.isActivity() && (activity = (oracle.bpm.project.model.processes.Activity)this.flowNode).isUserTask()) {
            UserTask userTask = activity.toUserTask();
            this.task = new TaskAdapter(this, userTask.getHumanTask());
        }
    }

    private void validateTaskNumber(int taskNumber) {
        if (taskNumber != 0 || this.task == null) {
            throw new InvalidTaskNumberException(taskNumber, this.getId());
        }
    }

    private void loadType() {
        ModelUtils.handleFlowNode((FlowNode)this.flowNode, (FlowNodeHandler)new LoadTypeHandler());
    }

    public void setTagList(TagListType tagList) {
        this.tagList = tagList;
    }

    public TagListType getTagList() {
        return this.tagList;
    }

    public void setApplicationLinkDisplayName(String applicationLinkDisplayName) {
        this.applicationLinkDisplayName = applicationLinkDisplayName;
    }

    public String getApplicationLinkDisplayName() {
        return this.applicationLinkDisplayName;
    }

    private class LoadTypeHandler
    extends FlowNodeAdapter {
        private LoadTypeHandler() {
        }

        public void handleAbstractActivity(oracle.bpm.project.model.processes.Activity node) {
        }

        public void handleBoundaryEvent(BoundaryEvent node) {
        }

        public void handleBusinessRuleTask(BusinessRuleTask node) {
            ActivityAdapter.this.type_d = 0x800001;
        }

        public void handleCallActivity(CallActivity node) {
            ActivityAdapter.this.type_d = 0x800002;
        }

        public void handleCatchIntermediateEvent(CatchEvent node) {
            ActivityAdapter.this.type_d = 0x80000E;
        }

        public void handleEndEvent(EndEvent node) {
            ActivityAdapter.this.type_d = 0x800003;
        }

        public void handleExclusiveGateway(ExclusiveGateway node) {
            ActivityAdapter.this.type_d = 0x800004;
        }

        public void handleInclusiveGateway(InclusiveGateway node) {
            ActivityAdapter.this.type_d = 0x800005;
        }

        public void handleParallelGateway(ParallelGateway node) {
            ActivityAdapter.this.type_d = 0x800006;
        }

        public void handleComplexGateway(ComplexGateway node) {
            ActivityAdapter.this.type_d = 8388626;
        }

        public void handleEventBasedGateway(EventBasedGateway node) {
            ActivityAdapter.this.type_d = 0x800011;
        }

        public void handleReceiveTask(ReceiveTask node) {
            ActivityAdapter.this.type_d = 0x800007;
        }

        public void handleScriptTask(ScriptTask node) {
            ActivityAdapter.this.type_d = 0x800008;
        }

        public void handleSendTask(SendTask node) {
            ActivityAdapter.this.type_d = 0x800009;
        }

        public void handleServiceTask(ServiceTask node) {
            ActivityAdapter.this.type_d = 0x80000A;
        }

        public void handleSubprocess(Subprocess node) {
            ActivityAdapter.this.type_d = 0x80000C;
        }

        public void handleStartEvent(StartEvent node) {
            ActivityAdapter.this.type_d = 0x80000B;
        }

        public void handleIntermediateThrowEvent(ThrowEvent node) {
            ActivityAdapter.this.type_d = 0x80000F;
        }

        public void handleUserTask(UserTask node) {
            ActivityAdapter.this.type_d = 0x80000D;
        }

        public void handleCommon(FlowNode node) {
        }

        public void handleManualTask(ManualTask task) {
            ActivityAdapter.this.type_d = 0x800010;
        }
    }

    private class ArgumentSetHandler
    extends FlowNodeAdapter {
        private final List<ArgumentSet> argumentSets;

        public ArgumentSetHandler(List<ArgumentSet> argumentSets) {
            this.argumentSets = argumentSets;
        }

        public void handleEndEvent(EndEvent endEvent) {
            this.argumentSets.add(new ArgumentSetAdapter(endEvent.getInputDataAssociationSet()));
        }

        public void handleStartEvent(StartEvent startEvent) {
            this.argumentSets.add(new ArgumentSetAdapter(startEvent.getOutputDataAssociationSet()));
        }

        public void handleCatchIntermediateEvent(CatchEvent catchEvent) {
            this.argumentSets.add(new ArgumentSetAdapter(catchEvent.getOutputDataAssociationSet()));
        }

        public void handleIntermediateThrowEvent(ThrowEvent throwEvent) {
            this.argumentSets.add(new ArgumentSetAdapter(throwEvent.getInputDataAssociationSet()));
        }

        public void handleServiceTask(ServiceTask serviceTask) {
            this.argumentSets.add(new ArgumentSetAdapter(serviceTask.getInputDataAssociationSet()));
            this.argumentSets.add(new ArgumentSetAdapter(serviceTask.getOutputDataAssociationSet()));
        }

        public void handleUserTask(UserTask userTask) {
            this.argumentSets.add(new ArgumentSetAdapter(userTask.getInputDataAssociationSet()));
            this.argumentSets.add(new ArgumentSetAdapter(userTask.getOutputDataAssociationSet()));
        }

        public void handleSendTask(SendTask sendTask) {
            this.argumentSets.add(new ArgumentSetAdapter(sendTask.getInputDataAssociationSet()));
        }

        public void handleReceiveTask(ReceiveTask receiveTask) {
            this.argumentSets.add(new ArgumentSetAdapter(receiveTask.getOutputDataAssociationSet()));
        }

        public void handleBusinessRuleTask(BusinessRuleTask businessRuleTask) {
            this.argumentSets.add(new ArgumentSetAdapter(businessRuleTask.getInputDataAssociationSet()));
            this.argumentSets.add(new ArgumentSetAdapter(businessRuleTask.getOutputDataAssociationSet()));
        }
    }
}

