/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.layout;

import fuego.papi.ObjectClassInstance;
import fuego.papi.OperationException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.PrincipleRefTypeFactory;
import oracle.bpm.papi.ora.layout.ObjectClassInstanceAdapter;

public class ObjectClassQuery {
    public static List<ObjectClassInstance> findObjectClassBySession(ProcessServiceSessionAdapter session, String objectClass) throws OperationException {
        try {
            IUserMetadataService service = session.getWorkflowServiceClient().getUserMetadataService();
            List userApplicationDataTypeList = service.listGrantedUserApplicationData((IWorkflowContext)session.getBPMContext(), objectClass, null, false);
            ArrayList<ObjectClassInstance> objectClassInstanceList = new ArrayList<ObjectClassInstance>();
            for (UserApplicationDataType userApplicationDataType : userApplicationDataTypeList) {
                objectClassInstanceList.add(ObjectClassInstanceAdapter.createObjectClassInstance(userApplicationDataType));
            }
            return objectClassInstanceList;
        }
        catch (WorkflowException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public static List<ObjectClassInstance> findObjectClassInstanceByRole(ProcessServiceSessionAdapter session, String objectClass, String[] roles) throws OperationException {
        ArrayList<PrincipleRefType> principleRefs = new ArrayList<PrincipleRefType>();
        for (String role : roles) {
            principleRefs.add(PrincipleRefTypeFactory.createPrincipleRefAppRole(role));
        }
        return ObjectClassQuery.findObjectClassInstanceByPrincipleRef(session, objectClass, principleRefs);
    }

    public static List<ObjectClassInstance> findObjectClassInstanceByParticipant(ProcessServiceSessionAdapter session, String objectClass, String[] participants) throws OperationException {
        ArrayList<PrincipleRefType> principleRefs = new ArrayList<PrincipleRefType>();
        for (String participant : participants) {
            principleRefs.add(PrincipleRefTypeFactory.createPrincipleRefParticipant(participant));
        }
        return ObjectClassQuery.findObjectClassInstanceByPrincipleRef(session, objectClass, principleRefs);
    }

    public static ObjectClassInstance objectClassInstanceFetchByName(ProcessServiceSessionAdapter session, String objectClass, String name) throws OperationException {
        try {
            IUserMetadataService service = session.getBPMServiceClient().getUserMetadataService();
            List userApplicationDataTypeList = service.listUserApplicationData((IWorkflowContext)session.getBPMContext(), objectClass, null);
            for (UserApplicationDataType userApplicationDataType : userApplicationDataTypeList) {
                if (!userApplicationDataType.getName().equals(name)) continue;
                return ObjectClassInstanceAdapter.createObjectClassInstance(userApplicationDataType);
            }
            userApplicationDataTypeList = service.listGrantedUserApplicationData((IWorkflowContext)session.getBPMContext(), objectClass, null, false);
            for (UserApplicationDataType userApplicationDataType : userApplicationDataTypeList) {
                if (!userApplicationDataType.getName().equals(name)) continue;
                return ObjectClassInstanceAdapter.createObjectClassInstance(userApplicationDataType);
            }
            return null;
        }
        catch (WorkflowException e) {
            throw new OperationException((Throwable)e);
        }
    }

    private static List<ObjectClassInstance> findObjectClassInstanceByPrincipleRef(ProcessServiceSessionAdapter session, String objectClass, List<PrincipleRefType> principleRefs) throws OperationException {
        ArrayList<ObjectClassInstance> objectClassInstanceList = new ArrayList<ObjectClassInstance>();
        for (PrincipleRefType principleRef : principleRefs) {
            List<ObjectClassInstance> objectClassInstance = ObjectClassQuery.findObjectClassInstance(session, objectClass, principleRef);
            objectClassInstanceList.addAll(objectClassInstance);
        }
        return objectClassInstanceList;
    }

    private static List<ObjectClassInstance> findObjectClassInstance(ProcessServiceSessionAdapter session, String objectClass, PrincipleRefType principleRefType) throws OperationException {
        try {
            IUserMetadataService service = session.getWorkflowServiceClient().getUserMetadataService();
            List userApplicationDataTypeList = service.listGrantedUserApplicationData((IWorkflowContext)session.getBPMContext(), objectClass, principleRefType, false);
            ArrayList<ObjectClassInstance> objectClassInstanceList = new ArrayList<ObjectClassInstance>();
            for (UserApplicationDataType userApplicationDataType : userApplicationDataTypeList) {
                objectClassInstanceList.add(ObjectClassInstanceAdapter.createObjectClassInstance(userApplicationDataType));
            }
            return objectClassInstanceList;
        }
        catch (WorkflowException e) {
            throw new OperationException((Throwable)e);
        }
    }
}

