/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.layout;

import fuego.papi.ObjectClassInstance;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.workflow.common.model.PrincipleListType;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.model.ObjectFactory;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.papi.ora.helper.PrincipleRefTypeFactory;

public class ObjectClassInstanceAdapter
implements ObjectClassInstance {
    private UserApplicationDataType userApplicationData;

    private ObjectClassInstanceAdapter(UserApplicationDataType userApplicationData) {
        this.userApplicationData = userApplicationData;
    }

    private ObjectClassInstanceAdapter(String name, String objectClass, String[] assignedRoles, String[] assignedParticipants, String instanceXml) throws JAXBException {
        oracle.bpel.services.workflow.common.model.ObjectFactory principleFactory = new oracle.bpel.services.workflow.common.model.ObjectFactory();
        PrincipleListType listType = principleFactory.createPrincipleListType();
        for (String assignedRole : assignedRoles) {
            listType.getParticipant().add(PrincipleRefTypeFactory.createPrincipleRefAppRole(assignedRole));
        }
        for (String assignedParticipant : assignedParticipants) {
            listType.getParticipant().add(PrincipleRefTypeFactory.createPrincipleRefParticipant(assignedParticipant));
        }
        ObjectFactory userApplicationDataFactory = new ObjectFactory();
        this.userApplicationData = userApplicationDataFactory.createUserApplicationDataType();
        this.userApplicationData.setApplicationDataType(objectClass);
        this.userApplicationData.setData(instanceXml);
        this.userApplicationData.setGrantees(listType);
        this.userApplicationData.setIdentityContext(null);
        this.userApplicationData.setName(name);
        this.userApplicationData.setOwner(null);
    }

    public static ObjectClassInstance createObjectClassInstance(UserApplicationDataType userApplicationData) {
        return new ObjectClassInstanceAdapter(userApplicationData);
    }

    public static ObjectClassInstanceAdapter createObjectClassInstance(String name, String objectClass, String[] assignedRoles, String[] assignedParticipants, String instanceXml) throws JAXBException {
        return new ObjectClassInstanceAdapter(name, objectClass, assignedRoles, assignedParticipants, instanceXml);
    }

    public UserApplicationDataType getUserApplicationData() {
        return this.userApplicationData;
    }

    public void setUserApplicationData(UserApplicationDataType userApplicationData) {
        this.userApplicationData = userApplicationData;
    }

    public String getName() {
        return this.userApplicationData.getName();
    }

    public String getObjectClass() {
        return this.userApplicationData.getApplicationDataType();
    }

    public String[] getAssignedParticipants() {
        ArrayList<String> participants = new ArrayList<String>();
        if (this.userApplicationData != null) {
            PrincipleListType principleListType = this.userApplicationData.getGrantees();
            for (int i = 0; i < principleListType.getParticipant().size(); ++i) {
                PrincipleRefType prt = (PrincipleRefType)principleListType.getParticipant().get(i);
                if (!prt.getType().equals("USER")) continue;
                participants.add(prt.getName());
            }
        }
        return participants.toArray(new String[participants.size()]);
    }

    public String[] getAssignedRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (this.userApplicationData != null) {
            PrincipleListType principleListType = this.userApplicationData.getGrantees();
            for (int i = 0; i < principleListType.getParticipant().size(); ++i) {
                PrincipleRefType prt = (PrincipleRefType)principleListType.getParticipant().get(i);
                if (!prt.getType().equals("APPROLE")) continue;
                roles.add(prt.getName());
            }
        }
        return roles.toArray(new String[roles.size()]);
    }

    public String getInstanceXml() {
        return this.userApplicationData.getData();
    }

    public void setAssignedParticipants(String[] assignedParticipants) {
        for (String assignedParticipant : assignedParticipants) {
            PrincipleRefType principle = PrincipleRefTypeFactory.createPrincipleRefParticipant(assignedParticipant);
            this.addPrinciple(principle);
        }
    }

    public void setAssignedRoles(String[] assignedRoles) {
        List participants = this.userApplicationData.getGrantees().getParticipant();
        if (participants != null) {
            participants.clear();
        }
        for (String assignedRole : assignedRoles) {
            PrincipleRefType principle = PrincipleRefTypeFactory.createPrincipleRefAppRole(assignedRole);
            this.addPrinciple(principle);
        }
    }

    public void setInstanceXml(String instanceXml) {
        this.userApplicationData.setData(instanceXml);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectClassInstanceAdapter)) {
            return false;
        }
        ObjectClassInstanceAdapter that = (ObjectClassInstanceAdapter)o;
        return !(this.userApplicationData != null ? !this.compare(that) : that.userApplicationData != null);
    }

    public int hashCode() {
        if (this.userApplicationData == null) {
            return 0;
        }
        int hash = 7;
        hash = 31 * hash + (null == this.getName() ? 0 : this.getName().hashCode());
        hash = 31 * hash + (null == this.getObjectClass() ? 0 : this.getObjectClass().hashCode());
        return hash;
    }

    private void addPrinciple(PrincipleRefType principle) {
        List participants = this.userApplicationData.getGrantees().getParticipant();
        boolean found = false;
        for (int i = 0; i < participants.size(); ++i) {
            PrincipleRefType principleRefType = (PrincipleRefType)participants.get(i);
            if (!principle.getName().equals(principleRefType.getName()) || !this.sameRealm(principle, principleRefType) || !principle.getType().equals(principleRefType.getType())) continue;
            found = true;
            break;
        }
        if (!found) {
            participants.add(principle);
        }
    }

    private boolean sameRealm(PrincipleRefType principle, PrincipleRefType principleRefType) {
        String realm = principle.getRealm() == null ? "jazn.com" : principle.getRealm();
        return realm.equals(principleRefType.getRealm());
    }

    private boolean compare(ObjectClassInstanceAdapter that) {
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getObjectClass().equals(that.getObjectClass());
    }
}

