/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import fuego.papi.ParticipantScope;
import fuego.papi.SearchScope;
import fuego.papi.StatusScope;
import fuego.papi.msg.PapiMsg;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.papi.ora.view.ApplicationsViewAdapter;
import oracle.bpm.papi.ora.view.FilterAdapter;
import oracle.bpm.papi.ora.view.FolderViewAdapter;
import oracle.bpm.papi.ora.view.History;
import oracle.bpm.papi.ora.view.HistoryViewAdapter;
import oracle.bpm.papi.ora.view.InstancesViewAdapter;
import oracle.bpm.papi.ora.view.ViewAdapter;

public class ViewHelper {
    public static final String HISTORY_LAST_DAY = "history_view/last_day";
    public static final String HISTORY_LAST_WEEK = "history_view/last_week";
    public static final String HISTORY_LAST_MONTH = "history_view/last_month";
    public static final String HISTORY_LAST_THREE_MONTHS = "history_view/last_three_months";
    public static final String BPM_HISTORY_VIEW_1DAY = "MY_UPDATED_PROCESSES_1DAY";
    public static final String BPM_HISTORY_VIEW_1WEEK = "MY_UPDATED_PROCESSES_1WEEK";
    public static final String BPM_HISTORY_VIEW_30DAYS = "MY_UPDATED_PROCESSES_30DAYS";
    public static final String BPM_HISTORY_VIEW_90DAYS = "MY_UPDATED_PROCESSES_90DAYS";

    public static InstancesViewAdapter getDefaultInboxView(String[] processes) {
        InstancesViewAdapter view = ViewAdapter.createInstancesView("unified_inbox");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignProcesses(processes);
        view.setLabels(LibMsg.INBOX);
        FilterAdapter filter = FilterAdapter.create();
        filter.setSearchScope(new SearchScope(ParticipantScope.PARTICIPANT_ROLES, StatusScope.OPEN));
        filter.setName(view.getId());
        view.setFilter(filter);
        return view;
    }

    public static ApplicationsViewAdapter getDefaultApplicationsView(String[] processes) {
        ApplicationsViewAdapter view = ViewAdapter.createApplicationsView("applications");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignProcesses(processes);
        view.setLabels(LibMsg.APPLICATIONS);
        return view;
    }

    public static List<ViewAdapter> getDefaultHitoryViews() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Time.now().dateValue());
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Time today = Time.valueOf((Calendar)calendar);
        ArrayList<ViewAdapter> historyViews = new ArrayList<ViewAdapter>();
        FolderViewAdapter folder = ViewAdapter.createFolderView("history_view");
        folder.setCustom(false);
        folder.setLabels(PapiMsg.HISTORY);
        historyViews.add(folder);
        HistoryViewAdapter historyView = ViewAdapter.createHistoryView(HISTORY_LAST_DAY);
        historyView.setFrom(today);
        historyView.setTo(today.sub(Interval.ONE_DAY));
        historyView.setLabels(PapiMsg.LAST_DAY);
        historyView.setCustom(false);
        historyView.setHistoryInterval(History.HistoryInterval.getIntervalAgo(1, 0, calendar));
        historyViews.add(historyView);
        historyView = ViewAdapter.createHistoryView(HISTORY_LAST_WEEK);
        historyView.setFrom(today);
        historyView.setTo(today.sub(Interval.ONE_WEEK));
        historyView.setLabels(PapiMsg.LAST_WEEK);
        historyView.setCustom(false);
        historyView.setHistoryInterval(History.HistoryInterval.getIntervalAgo(1, 1, calendar));
        historyViews.add(historyView);
        historyView = ViewAdapter.createHistoryView(HISTORY_LAST_MONTH);
        historyView.setFrom(today);
        historyView.setTo(today.sub(Interval.ONE_MONTH));
        historyView.setLabels(PapiMsg.LAST_MONTH);
        historyView.setCustom(false);
        historyView.setHistoryInterval(History.HistoryInterval.getIntervalAgo(4, 1, calendar));
        historyViews.add(historyView);
        historyView = ViewAdapter.createHistoryView(HISTORY_LAST_THREE_MONTHS);
        historyView.setFrom(today);
        historyView.setTo(today.sub(Interval.ONE_SECOND.addMonths(3)));
        historyView.setLabels(PapiMsg.THREE_MONTHS_AGO);
        historyView.setCustom(false);
        historyView.setHistoryInterval(History.HistoryInterval.getIntervalAgo(14, 1, calendar));
        historyViews.add(historyView);
        return historyViews;
    }
}

