/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.VarDefinition;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpel.services.workflow.query.model.ClauseType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.Time;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.services.common.resources.BPMServicesResource;
import oracle.bpm.services.instancequery.IColumnConstants;
import org.jetbrains.annotations.NotNull;

public class VarDefinitionHelper {
    private static Map<String, Column> instanceVarMapper = new HashMap<String, Column>();
    private static Map<Column, String> columnMapper = new HashMap<Column, String>();
    public static final String VARIABLE_ID_PROJECT_APPLICATION = "PREDEFINE_PROJECT_APPLICATION";
    public static final String VARIABLE_ID_PROJECT_NAME = "PREDEFINE_PROCEJECT_NAME";
    public static final String VARIABLE_ID_PROJECT_REVISION = "PREDEFINE_PROCEJECT_REVISION";
    public static final String VARIABLE_ID_PROCESS_NAME = "PREDEFINE_PROCESS_NAME";
    public static final String VARIABLE_ID_ACTIVITY_TYPE = "PREDEFINE_ACTIVITY_TYPE";
    public static final VarDefinition VARIABLE_PROJECT_APPLICATION = new VarDefinition("PREDEFINE_PROJECT_APPLICATION", 5, null, 50, VarDefinitionHelper.getLabels("APPLICATION"));
    public static final VarDefinition VARIABLE_PROJECT_NAME = new VarDefinition("PREDEFINE_PROCEJECT_NAME", 5, null, 50, VarDefinitionHelper.getLabels("PROJECT"));
    public static final VarDefinition VARIABLE_PROJECT_REVISION = new VarDefinition("PREDEFINE_PROCEJECT_REVISION", 5, null, 50, VarDefinitionHelper.getLabels("REVISION"));
    public static final VarDefinition VARIABLE_PROCESS_NAME = new VarDefinition("PREDEFINE_PROCESS_NAME", 5, null, 50, VarDefinitionHelper.getLabels("PROCESS"));
    public static final VarDefinition VARIABLE_ACTIVITY_TYPE = new VarDefinition("PREDEFINE_ACTIVITY_TYPE", 2, null, 7, VarDefinitionHelper.getLabels("ACTIVITY_TYPE"));

    public static Column getColumnForVariable(@NotNull String varDefinition) {
        return instanceVarMapper.get(varDefinition);
    }

    public static Column getColumnForVariable(@NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull String variable) throws OperationException {
        Map<String, String> variableMapping;
        Column column = instanceVarMapper.get(variable);
        if (column == null && (variableMapping = session.getVariableMapping(processId)) != null) {
            column = VarDefinitionHelper.getFlexFieldColumn(variableMapping.get(variable));
        }
        return column;
    }

    public static String getVariableIdForColumn(@NotNull Column column) {
        return columnMapper.get(column);
    }

    public static String getVariableIdForColumn(@NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull Column column) throws OperationException {
        Map<String, String> variableMapping;
        String variable = columnMapper.get(column);
        if (variable == null && (variableMapping = session.getVariableMapping(processId)) != null) {
            for (Map.Entry<String, String> entry : variableMapping.entrySet()) {
                if (!column.getName().equalsIgnoreCase(entry.getValue())) continue;
                variable = entry.getKey();
            }
        }
        return variable;
    }

    public static VarDefinition getVariableForColumn(@NotNull Column column) {
        String variableId = columnMapper.get(column);
        if (variableId != null) {
            if (variableId.equals(VARIABLE_ID_ACTIVITY_TYPE)) {
                return VARIABLE_ACTIVITY_TYPE;
            }
            if (variableId.equals(VARIABLE_ID_PROCESS_NAME)) {
                return VARIABLE_PROCESS_NAME;
            }
            if (variableId.equals(VARIABLE_ID_PROJECT_APPLICATION)) {
                return VARIABLE_PROJECT_APPLICATION;
            }
            if (variableId.equals(VARIABLE_ID_PROJECT_NAME)) {
                return VARIABLE_PROJECT_NAME;
            }
            if (variableId.equals(VARIABLE_ID_PROJECT_REVISION)) {
                return VARIABLE_PROJECT_REVISION;
            }
            return VarDefinition.getDefaultVarDefinition((String)variableId);
        }
        return null;
    }

    public static VarDefinition getVariableForColumn(@NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull Column column) throws OperationException {
        String variableId;
        VarDefinition variable = VarDefinitionHelper.getVariableForColumn(column);
        if (variable == null && (variableId = VarDefinitionHelper.getVariableIdForColumn(session, processId, column)) != null) {
            variable = session.variableGet(variableId);
        }
        return variable;
    }

    public static Object getPapiVariableValue(@NotNull ClauseType clause) {
        Column column = Column.getColumn((String)clause.getColumn().getColumnName());
        if (column.getType() == 5) {
            Calendar calendar = clause.getDateValue();
            if (calendar == null) {
                return null;
            }
            return Time.valueOf((Calendar)calendar);
        }
        return VarDefinitionHelper.getPapiVariableValue(column, clause.getValue());
    }

    public static Object getBpelVariableValue(@NotNull Column column, Object value) {
        if (value != null) {
            switch (column.getType()) {
                case 1: {
                    return ((Number)value).intValue();
                }
                case 2: {
                    return value.toString();
                }
                case 3: {
                    return Boolean.valueOf(value.toString());
                }
                case 4: {
                    return Float.valueOf(((Number)value).floatValue());
                }
                case 5: {
                    if (value instanceof Time) {
                        return ((Time)value).dateValue();
                    }
                    if (value instanceof Date) {
                        return (Date)value;
                    }
                    return value;
                }
                case 9: {
                    return ((Number)value).doubleValue();
                }
                case 10: {
                    return ((Number)value).longValue();
                }
            }
            return value;
        }
        return value;
    }

    private static Object getPapiVariableValue(@NotNull Column column, String value) {
        if (value != null) {
            switch (column.getType()) {
                case 1: {
                    return Integer.valueOf(value);
                }
                case 2: {
                    return value;
                }
                case 3: {
                    return Boolean.valueOf(value);
                }
                case 4: {
                    return Float.valueOf(value);
                }
                case 9: {
                    return Double.valueOf(value);
                }
                case 10: {
                    return Long.valueOf(value);
                }
            }
            return value;
        }
        return value;
    }

    private static Column getFlexFieldColumn(String flexField) {
        if (flexField != null) {
            String flexColumn = "PROCESS_" + flexField.toUpperCase() + "_COLUMN";
            for (Field field : IColumnConstants.class.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(flexColumn)) continue;
                try {
                    return (Column)field.get(null);
                }
                catch (IllegalAccessException causeException) {
                    throw new OperationRuntimeException((Throwable)causeException);
                }
            }
        }
        return null;
    }

    private static LocaleStringMap getLabels(String key) {
        LocaleStringMap labels = LocaleStringMap.create();
        for (LocaleSupport locale : Platform.getLocaleService().getSupportedLocales()) {
            Locale javaLocale = locale.asJavaLocale();
            labels.put(javaLocale, BPMServicesResource.getResource((String)key, (Locale)javaLocale));
        }
        return labels;
    }

    static {
        instanceVarMapper.put("PREDEFINE_PRIORITY", IColumnConstants.PROCESS_INSTANCE_PRIORITY_COLUMN);
        instanceVarMapper.put(VarDefinition.HAS_NOTES, IColumnConstants.PROCESS_USER_COMMENTS);
        instanceVarMapper.put("PREDEFINE_DESCRIPTION", IColumnConstants.PROCESS_TITLE_COLUMN);
        instanceVarMapper.put("PREDEFINE_PROCESS", IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN);
        instanceVarMapper.put("PREDEFINE_ACTIVITY", IColumnConstants.PROCESS_ACTIVITYID_COLUMN);
        instanceVarMapper.put("PREDEFINE_STATUS", IColumnConstants.PROCESS_STATE_COLUMN);
        instanceVarMapper.put("PREDEFINE_RECEIVED TIME", IColumnConstants.PROCESS_CREATEDDATE_COLUMN);
        instanceVarMapper.put("PREDEFINE_DEADLINE", IColumnConstants.PROCESS_EXPIRATIONDATE_COLUMN);
        instanceVarMapper.put("PREDEFINE_PROCESS DEADLINE", IColumnConstants.PROCESS_DUEDATE_COLUMN);
        instanceVarMapper.put("PREDEFINE_ACTIVITY DEADLINE", IColumnConstants.PROCESS_EXPIRATIONDATE_COLUMN);
        instanceVarMapper.put("PREDEFINE_PARTICIPANT", IColumnConstants.PROCESS_ASSIGNEES_COLUMN);
        instanceVarMapper.put("PREDEFINE_COPY", IColumnConstants.PROCESS_THREAD_COLUMN);
        instanceVarMapper.put("PREDEFINE_AUTHOR", IColumnConstants.PROCESS_CREATOR_COLUMN);
        instanceVarMapper.put("PREDEFINE_CREATION TIME", IColumnConstants.PROCESS_CREATEDDATE_COLUMN);
        instanceVarMapper.put("PREDEFINE_PARENT COPY", IColumnConstants.PROCESS_PARENTTHREAD_COLUMN);
        instanceVarMapper.put("PREDEFINE_INSTANCE NUMBER", IColumnConstants.PROCESS_INSTANCEID_COLUMN);
        instanceVarMapper.put("PREDEFINE_TASK NUMBER", IColumnConstants.PROCESS_NUMBER_COLUMN);
        instanceVarMapper.put(VarDefinition.AUTHOR_DISPLAYNAME, IColumnConstants.PROCESS_CREATOR_COLUMN);
        instanceVarMapper.put(VarDefinition.MAIN_TASK_PARTICIPANT_ID, IColumnConstants.PROCESS_ASSIGNEES_COLUMN);
        instanceVarMapper.put(VARIABLE_ID_PROJECT_APPLICATION, IColumnConstants.PROCESS_APPLICATIONNAME_COLUMN);
        instanceVarMapper.put(VARIABLE_ID_PROJECT_NAME, IColumnConstants.PROCESS_COMPOSITENAME_COLUMN);
        instanceVarMapper.put(VARIABLE_ID_PROJECT_NAME, IColumnConstants.PROCESS_COMPOSITEVERSION_COLUMN);
        instanceVarMapper.put(VARIABLE_ID_PROCESS_NAME, IColumnConstants.PROCESS_PROCESSNAME_COLUMN);
        instanceVarMapper.put(VARIABLE_ID_ACTIVITY_TYPE, IColumnConstants.PROCESS_ACTIVITYTYPE_COLUMN);
        columnMapper.put(IColumnConstants.PROCESS_INSTANCE_PRIORITY_COLUMN, "PREDEFINE_PRIORITY");
        columnMapper.put(IColumnConstants.PROCESS_USER_COMMENTS, VarDefinition.HAS_NOTES);
        columnMapper.put(IColumnConstants.PROCESS_TITLE_COLUMN, "PREDEFINE_DESCRIPTION");
        columnMapper.put(IColumnConstants.PROCESS_ID_COLUMN, "PREDEFINE_PROCESS");
        columnMapper.put(IColumnConstants.PROCESS_ACTIVITYID_COLUMN, "PREDEFINE_ACTIVITY");
        columnMapper.put(IColumnConstants.PROCESS_STATE_COLUMN, "PREDEFINE_STATUS");
        columnMapper.put(IColumnConstants.PROCESS_CREATEDDATE_COLUMN, "PREDEFINE_RECEIVED TIME");
        columnMapper.put(IColumnConstants.PROCESS_EXPIRATIONDATE_COLUMN, "PREDEFINE_DEADLINE");
        columnMapper.put(IColumnConstants.PROCESS_DUEDATE_COLUMN, "PREDEFINE_PROCESS DEADLINE");
        columnMapper.put(IColumnConstants.PROCESS_EXPIRATIONDATE_COLUMN, "PREDEFINE_ACTIVITY DEADLINE");
        columnMapper.put(IColumnConstants.PROCESS_ASSIGNEES_COLUMN, "PREDEFINE_PARTICIPANT");
        columnMapper.put(IColumnConstants.PROCESS_THREAD_COLUMN, "PREDEFINE_COPY");
        columnMapper.put(IColumnConstants.PROCESS_CREATOR_COLUMN, "PREDEFINE_AUTHOR");
        columnMapper.put(IColumnConstants.PROCESS_CREATEDDATE_COLUMN, "PREDEFINE_CREATION TIME");
        columnMapper.put(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN, "PREDEFINE_PARENT COPY");
        columnMapper.put(IColumnConstants.PROCESS_INSTANCEID_COLUMN, "PREDEFINE_INSTANCE NUMBER");
        columnMapper.put(IColumnConstants.PROCESS_NUMBER_COLUMN, "PREDEFINE_TASK NUMBER");
        columnMapper.put(IColumnConstants.PROCESS_CREATOR_COLUMN, VarDefinition.AUTHOR_DISPLAYNAME);
        columnMapper.put(IColumnConstants.PROCESS_APPLICATIONNAME_COLUMN, VARIABLE_ID_PROJECT_APPLICATION);
        columnMapper.put(IColumnConstants.PROCESS_COMPOSITENAME_COLUMN, VARIABLE_ID_PROJECT_NAME);
        columnMapper.put(IColumnConstants.PROCESS_COMPOSITEVERSION_COLUMN, VARIABLE_ID_PROJECT_NAME);
        columnMapper.put(IColumnConstants.PROCESS_PROCESSNAME_COLUMN, VARIABLE_ID_PROCESS_NAME);
        columnMapper.put(IColumnConstants.PROCESS_ACTIVITYTYPE_COLUMN, VARIABLE_ID_ACTIVITY_TYPE);
    }
}

