/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import fuego.papi.StatusScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatusScopeHelper {
    private static Map<StatusScope, List<String>> mapper = new HashMap<StatusScope, List<String>>();

    public static List<String> getObpiState(StatusScope scope) {
        return mapper.get(scope) != null ? mapper.get(scope) : mapper.get(StatusScope.ALL);
    }

    public static String getSimpleObpiState(StatusScope scope) {
        switch (scope) {
            case ONLY_INPROCESS: 
            case INPROCESS_AND_ABORTED: 
            case INPROCESS_AND_COMPLETED: 
            case ALL: {
                return "OPEN";
            }
            case OPEN: {
                return "OPEN";
            }
            case ONLY_ABORTED: 
            case ABORTED_AND_COMPLETED: {
                return "CANCELED";
            }
            case ONLY_COMPLETED: {
                return "COMPLETED";
            }
            case ONLY_ERRORED: {
                return "ERRORED";
            }
            case ONLY_PENDING_MIGRATION: {
                return "PENDING_MIGRATION";
            }
            case ONLY_SUSPENDED: {
                return "SUSPENDED";
            }
        }
        return "OPEN";
    }

    public static StatusScope getPAPIStatus(List<String> obpiStatus) {
        StatusScope statusScope = null;
        for (String status : obpiStatus) {
            StatusScope _statusScope = StatusScopeHelper.getPapiStatus(status);
            if (statusScope == null) {
                statusScope = _statusScope;
                continue;
            }
            if (statusScope == StatusScope.ALL) break;
            statusScope = StatusScopeHelper.addStatus(statusScope, _statusScope);
        }
        return statusScope;
    }

    private static StatusScope getPapiStatus(String obpiStatus) {
        if (obpiStatus == null || obpiStatus.isEmpty()) {
            return StatusScope.ONLY_INPROCESS;
        }
        if (obpiStatus.equals("OPEN")) {
            return StatusScope.ONLY_INPROCESS;
        }
        if (obpiStatus.equals("ABORTED") || obpiStatus.equals("CANCELED")) {
            return StatusScope.ONLY_ABORTED;
        }
        if (obpiStatus.equals("COMPLETED")) {
            return StatusScope.ONLY_COMPLETED;
        }
        return StatusScope.ALL;
    }

    private static StatusScope addStatus(StatusScope originalScope, StatusScope addedScope) {
        if (originalScope == null) {
            return addedScope;
        }
        switch (originalScope) {
            case ONLY_INPROCESS: {
                switch (addedScope) {
                    case ONLY_INPROCESS: {
                        return StatusScope.ONLY_INPROCESS;
                    }
                    case ONLY_ABORTED: {
                        return StatusScope.INPROCESS_AND_ABORTED;
                    }
                    case ONLY_COMPLETED: {
                        return StatusScope.INPROCESS_AND_COMPLETED;
                    }
                    case INPROCESS_AND_ABORTED: {
                        return StatusScope.INPROCESS_AND_ABORTED;
                    }
                    case INPROCESS_AND_COMPLETED: {
                        return StatusScope.INPROCESS_AND_COMPLETED;
                    }
                    case ABORTED_AND_COMPLETED: {
                        return StatusScope.ALL;
                    }
                }
                return originalScope;
            }
            case ONLY_ABORTED: {
                switch (addedScope) {
                    case ONLY_INPROCESS: {
                        return StatusScope.INPROCESS_AND_ABORTED;
                    }
                    case ONLY_ABORTED: {
                        return StatusScope.ONLY_ABORTED;
                    }
                    case ONLY_COMPLETED: {
                        return StatusScope.ABORTED_AND_COMPLETED;
                    }
                    case INPROCESS_AND_ABORTED: {
                        return StatusScope.INPROCESS_AND_ABORTED;
                    }
                    case INPROCESS_AND_COMPLETED: {
                        return StatusScope.ALL;
                    }
                    case ABORTED_AND_COMPLETED: {
                        return StatusScope.ABORTED_AND_COMPLETED;
                    }
                }
                return originalScope;
            }
            case ONLY_COMPLETED: {
                switch (addedScope) {
                    case ONLY_INPROCESS: {
                        return StatusScope.INPROCESS_AND_ABORTED;
                    }
                    case ONLY_ABORTED: {
                        return StatusScope.ABORTED_AND_COMPLETED;
                    }
                    case ONLY_COMPLETED: {
                        return StatusScope.ONLY_COMPLETED;
                    }
                    case INPROCESS_AND_ABORTED: {
                        return StatusScope.ALL;
                    }
                    case INPROCESS_AND_COMPLETED: {
                        return StatusScope.INPROCESS_AND_COMPLETED;
                    }
                    case ABORTED_AND_COMPLETED: {
                        return StatusScope.ABORTED_AND_COMPLETED;
                    }
                }
                return originalScope;
            }
            case INPROCESS_AND_ABORTED: {
                switch (addedScope) {
                    case ONLY_INPROCESS: 
                    case INPROCESS_AND_ABORTED: 
                    case ONLY_ABORTED: {
                        return StatusScope.INPROCESS_AND_ABORTED;
                    }
                    case INPROCESS_AND_COMPLETED: 
                    case ABORTED_AND_COMPLETED: 
                    case ONLY_COMPLETED: {
                        return StatusScope.ALL;
                    }
                }
                return originalScope;
            }
            case INPROCESS_AND_COMPLETED: {
                switch (addedScope) {
                    case ONLY_INPROCESS: 
                    case INPROCESS_AND_COMPLETED: 
                    case ONLY_COMPLETED: {
                        return StatusScope.INPROCESS_AND_COMPLETED;
                    }
                    case INPROCESS_AND_ABORTED: 
                    case ONLY_ABORTED: 
                    case ABORTED_AND_COMPLETED: {
                        return StatusScope.ALL;
                    }
                }
                return originalScope;
            }
            case ABORTED_AND_COMPLETED: {
                switch (addedScope) {
                    case ONLY_INPROCESS: 
                    case INPROCESS_AND_ABORTED: 
                    case INPROCESS_AND_COMPLETED: {
                        return StatusScope.ALL;
                    }
                    case ONLY_ABORTED: 
                    case ABORTED_AND_COMPLETED: 
                    case ONLY_COMPLETED: {
                        return StatusScope.ABORTED_AND_COMPLETED;
                    }
                }
                return originalScope;
            }
        }
        return originalScope;
    }

    static {
        ArrayList<String> inProcess = new ArrayList<String>();
        inProcess.add("OPEN");
        ArrayList<String> aborted = new ArrayList<String>();
        aborted.add("ABORTED");
        aborted.add("CANCELED");
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("COMPLETED");
        ArrayList<String> errored = new ArrayList<String>();
        errored.add("ERRORED");
        ArrayList<String> migrationPending = new ArrayList<String>();
        migrationPending.add("PENDING_MIGRATION");
        migrationPending.add("PENDING_MIGRATION_SUSPENDED");
        ArrayList<String> suspended = new ArrayList<String>();
        suspended.add("SUSPENDED");
        ArrayList<String> abortedAndCompleted = new ArrayList<String>();
        abortedAndCompleted.addAll(aborted);
        abortedAndCompleted.addAll(completed);
        ArrayList<String> inProcessAndAborted = new ArrayList<String>();
        inProcessAndAborted.addAll(inProcess);
        inProcessAndAborted.addAll(aborted);
        ArrayList<String> inProcessAndCompleted = new ArrayList<String>();
        inProcessAndCompleted.addAll(inProcess);
        inProcessAndCompleted.addAll(completed);
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(inProcess);
        all.addAll(aborted);
        all.addAll(completed);
        all.addAll(errored);
        all.addAll(migrationPending);
        all.addAll(suspended);
        ArrayList<String> open = new ArrayList<String>();
        open.addAll(inProcess);
        open.addAll(errored);
        open.addAll(migrationPending);
        open.addAll(suspended);
        mapper.put(StatusScope.ONLY_INPROCESS, inProcess);
        mapper.put(StatusScope.ONLY_ABORTED, aborted);
        mapper.put(StatusScope.ONLY_COMPLETED, completed);
        mapper.put(StatusScope.ONLY_ERRORED, errored);
        mapper.put(StatusScope.ONLY_PENDING_MIGRATION, migrationPending);
        mapper.put(StatusScope.ABORTED_AND_COMPLETED, abortedAndCompleted);
        mapper.put(StatusScope.INPROCESS_AND_ABORTED, inProcessAndAborted);
        mapper.put(StatusScope.INPROCESS_AND_COMPLETED, inProcessAndCompleted);
        mapper.put(StatusScope.ONLY_SUSPENDED, suspended);
        mapper.put(StatusScope.ALL, all);
        mapper.put(StatusScope.OPEN, open);
    }
}

