/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessInstanceStateHelper {
    private static Map<Integer, List<String>> papiObpiMapper = new HashMap<Integer, List<String>>();
    private static Map<String, Integer> obpiPapiMapper = new HashMap<String, Integer>();

    public static List<String> getOBPIState(int state) {
        ArrayList<String> defaultState = new ArrayList<String>();
        defaultState.add("OPEN");
        return papiObpiMapper.get(state) != null ? papiObpiMapper.get(state) : defaultState;
    }

    public static String getSimpleOBPIState(int state) {
        return ProcessInstanceStateHelper.getOBPIState(state).get(0);
    }

    public static int getPAPIState(String state) {
        return obpiPapiMapper.get(state) != null ? obpiPapiMapper.get(state) : 0;
    }

    static {
        ArrayList<String> aborted = new ArrayList<String>();
        aborted.add("ABORTED");
        aborted.add("CANCELED");
        aborted.add("STALE");
        ArrayList<String> activityCompleted = new ArrayList<String>();
        activityCompleted.add("OPEN");
        ArrayList<String> instanceCompleted = new ArrayList<String>();
        instanceCompleted.add("COMPLETED");
        ArrayList<String> exception = new ArrayList<String>();
        exception.add("ERRORED");
        ArrayList<String> grabbed = new ArrayList<String>();
        grabbed.add("OPEN");
        ArrayList<String> none = new ArrayList<String>();
        none.add("OPEN");
        ArrayList<String> running = new ArrayList<String>();
        running.add("OPEN");
        ArrayList<String> suspended = new ArrayList<String>();
        suspended.add("OPEN");
        ArrayList<String> pendingMigration = new ArrayList<String>();
        pendingMigration.add("PENDING_MIGRATION");
        pendingMigration.add("PENDING_MIGRATION_SUSPENDED");
        papiObpiMapper.put(6, aborted);
        papiObpiMapper.put(7, activityCompleted);
        papiObpiMapper.put(5, instanceCompleted);
        papiObpiMapper.put(2, exception);
        papiObpiMapper.put(4, grabbed);
        papiObpiMapper.put(0, none);
        papiObpiMapper.put(1, running);
        papiObpiMapper.put(3, suspended);
        papiObpiMapper.put(8, pendingMigration);
        obpiPapiMapper.put("ABORTED", 6);
        obpiPapiMapper.put("COMPLETED", 5);
        obpiPapiMapper.put("OPEN", 1);
        obpiPapiMapper.put("STALE", 6);
        obpiPapiMapper.put("ERRORED", 2);
        obpiPapiMapper.put("CANCELED", 6);
        obpiPapiMapper.put("SUSPENDED", 3);
        obpiPapiMapper.put("PENDING_MIGRATION", 8);
        obpiPapiMapper.put("PENDING_MIGRATION_SUSPENDED", 8);
    }
}

