/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import oracle.bpm.papi.ora.helper.OrganizationalUnitIdHelper;
import oracle.bpm.services.common.model.ComponentDNModel;

public class ProcessIdHelper {
    public static String getOUFromID(String processId) {
        return OrganizationalUnitIdHelper.getRootId();
    }

    public static String getProcessNameFromID(String processId) {
        return ComponentDNModel.parseConsolidatedComponentDN((String)processId).getComponentName();
    }

    public static int getProcessMayorFromID(String processId) {
        ComponentDNModel componentDn = ComponentDNModel.parseComponentDN((String)processId);
        Double revisionNumber = 1.0;
        try {
            String revision = componentDn.getCompositeDN().getRevision();
            revisionNumber = new Double(revision);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return revisionNumber.intValue();
    }

    public static int getProcessMinorFromID(String processId) {
        ComponentDNModel componentDn = ComponentDNModel.parseComponentDN((String)processId);
        Double revisionNumber = 1.0;
        try {
            String revision = componentDn.getCompositeDN().getRevision();
            revisionNumber = new Double(revision);
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        int mayor = revisionNumber.intValue();
        int minor = 0;
        Double revision = revisionNumber - (double)mayor;
        while (revision != 0.0) {
            revision = revision * 10.0;
            minor *= 10;
            minor = (int)((double)minor + revision);
            revision = revision - (double)revision.intValue();
        }
        return minor;
    }

    public static String getProcessVariationFromID(String processId) {
        ComponentDNModel componentDn = ComponentDNModel.parseComponentDN((String)processId);
        return componentDn.getCompositeDN().getLabel();
    }

    public static String getProcessVersionFromID(String processId) {
        ComponentDNModel componentDn = ComponentDNModel.parseComponentDN((String)processId);
        return componentDn.getCompositeDN().getRevision() + "*" + componentDn.getCompositeDN().getLabel();
    }

    public static String getConsolidatedId(String processId) {
        ComponentDNModel componentDn = ComponentDNModel.parseConsolidatedComponentDN((String)processId);
        return componentDn.getConsolidatedDNString();
    }

    public static String buildId(String organizationalUnit, String processName, String processVersion) {
        organizationalUnit = OrganizationalUnitIdHelper.isRootId(organizationalUnit) ? "" : "/" + organizationalUnit;
        return organizationalUnit + "/" + processName + "#" + processVersion;
    }

    public static boolean isValidId(String processId) {
        try {
            ComponentDNModel.parseComponentDN((String)processId);
        }
        catch (Exception excpetion) {
            return false;
        }
        return true;
    }

    public static boolean isConsolidatedId(String processId) {
        ComponentDNModel componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)processId);
        return componentDN.getCompositeDN().getRevision() != null;
    }

    public static String buildActivityId(String processId, String activityName) {
        return processId + "/" + activityName;
    }
}

