/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import fuego.papi.Presentation;
import fuego.papi.PresentationType;
import fuego.papi.VarDefinition;
import fuego.papi.ViewType;
import java.util.ArrayList;
import oracle.bpm.papi.ora.view.PresentationAdapter;

public class PresentationHelper {
    public static Presentation getDefaultActivityPresentation() {
        ArrayList<Presentation.Column> defaultPresentationColumns = new ArrayList<Presentation.Column>();
        VarDefinition varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_DESCRIPTION");
        if (varDefinition != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_INSTANCE NUMBER")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_PROCESS")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_CREATION TIME")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_STATUS")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        int size = defaultPresentationColumns.size();
        return PresentationAdapter.create(PresentationType.INSTANCES, "default_activity", defaultPresentationColumns.toArray(new Presentation.Column[size]));
    }

    public static Presentation getDefaultApplicationsPresentation() {
        VarDefinition[] defaultVariables = VarDefinition.createApplicationDefaults();
        Presentation.Column[] defaultPresentationColumns = new Presentation.Column[defaultVariables.length];
        for (int i = 0; i < defaultVariables.length; ++i) {
            defaultPresentationColumns[i] = new Presentation.Column(defaultVariables[i]);
        }
        return PresentationAdapter.create(PresentationType.APPLICATIONS, "default_applications", defaultPresentationColumns);
    }

    public static Presentation getDefaultAttachmentsPresentation() {
        VarDefinition[] defaultVariables = VarDefinition.createAttachmentDefaults();
        Presentation.Column[] defaultPresentationColumns = new Presentation.Column[defaultVariables.length];
        for (int i = 0; i < defaultVariables.length; ++i) {
            defaultPresentationColumns[i] = new Presentation.Column(defaultVariables[i]);
        }
        return PresentationAdapter.create(PresentationType.ATTACHMENTS, "default_attachments", defaultPresentationColumns);
    }

    public static Presentation getDefaultFolderPresentation() {
        return PresentationAdapter.create(PresentationType.FOLDER, "default_folder", new Presentation.Column[0]);
    }

    public static Presentation getDefaultInstancesPresentation() {
        ArrayList<Presentation.Column> defaultPresentationColumns = new ArrayList<Presentation.Column>();
        VarDefinition varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_DESCRIPTION");
        if (varDefinition != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_INSTANCE NUMBER")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_AUTHOR")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_PROCESS")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_CREATION TIME")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        if ((varDefinition = (VarDefinition)VarDefinition.getDefaultVarDefinition().get("PREDEFINE_STATUS")) != null) {
            defaultPresentationColumns.add(new Presentation.Column(varDefinition));
        }
        int size = defaultPresentationColumns.size();
        return PresentationAdapter.create(PresentationType.INSTANCES, "default_instances", defaultPresentationColumns.toArray(new Presentation.Column[size]));
    }

    public static Presentation getDefaultPresentation(ViewType viewType) {
        if (viewType == ViewType.APPLICATIONS) {
            return PresentationHelper.getDefaultApplicationsPresentation();
        }
        if (viewType == ViewType.ATTACHMENTS) {
            return PresentationHelper.getDefaultAttachmentsPresentation();
        }
        if (viewType == ViewType.ACTIVITY_INSTANCES) {
            return PresentationHelper.getDefaultActivityPresentation();
        }
        if (viewType == ViewType.FOLDER) {
            return PresentationHelper.getDefaultFolderPresentation();
        }
        return PresentationHelper.getDefaultInstancesPresentation();
    }

    public static Presentation getDefaultPresentation(PresentationType presentationType) {
        if (presentationType == PresentationType.INSTANCES) {
            return PresentationHelper.getDefaultInstancesPresentation();
        }
        if (presentationType == PresentationType.APPLICATIONS) {
            return PresentationHelper.getDefaultApplicationsPresentation();
        }
        if (presentationType == PresentationType.ATTACHMENTS) {
            return PresentationHelper.getDefaultAttachmentsPresentation();
        }
        return PresentationHelper.getDefaultFolderPresentation();
    }

    public static Presentation[] getDefaultPresentations() {
        Presentation[] presentations = new Presentation[]{PresentationHelper.getDefaultInstancesPresentation(), PresentationHelper.getDefaultActivityPresentation(), PresentationHelper.getDefaultAttachmentsPresentation(), PresentationHelper.getDefaultApplicationsPresentation(), PresentationHelper.getDefaultFolderPresentation()};
        return presentations;
    }

    public static Presentation getDefaultPresentation(String presentationId) {
        if (presentationId != null && !presentationId.isEmpty()) {
            if ("default_activity".equalsIgnoreCase(presentationId)) {
                return PresentationHelper.getDefaultActivityPresentation();
            }
            if ("default_applications".equalsIgnoreCase(presentationId)) {
                return PresentationHelper.getDefaultApplicationsPresentation();
            }
            if ("default_attachments".equalsIgnoreCase(presentationId)) {
                return PresentationHelper.getDefaultAttachmentsPresentation();
            }
            if ("default_folder".equalsIgnoreCase(presentationId)) {
                return PresentationHelper.getDefaultFolderPresentation();
            }
            if ("default_instances".equalsIgnoreCase(presentationId)) {
                return PresentationHelper.getDefaultInstancesPresentation();
            }
        }
        return null;
    }
}

