/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import oracle.bpm.papi.ora.InstanceEventAdapter;

public class InstanceEventHelper {
    public static String makeEventData(InstanceEventAdapter event) {
        switch (event.getType()) {
            case 26: {
                return InstanceEventHelper.makeStartTaskExecutionData(event);
            }
            case 7: {
                return InstanceEventHelper.makeTaskExecutionData(event);
            }
            case 3: {
                return InstanceEventHelper.makeInstanceOutData(event);
            }
            case 28: {
                return InstanceEventHelper.makeExceptionData(event);
            }
            case 27: {
                return InstanceEventHelper.makeTransitionData(event);
            }
            case 14: {
                return InstanceEventHelper.makeSubflowInstanceCreatedData(event);
            }
            case 5: {
                return InstanceEventHelper.makeItemSelectedData(event);
            }
            case 6: {
                return InstanceEventHelper.makeItemUnselectedData(event);
            }
        }
        return "";
    }

    private static String makeItemUnselectedData(InstanceEventAdapter event) {
        String data = "";
        data = data + "ITEMIN=0:";
        if (event.getAuditInstance().getReferenceId() != null) {
            data = data + "ITEMID=" + event.getAuditInstance().getReferenceId() + ":";
        }
        return data;
    }

    private static String makeItemSelectedData(InstanceEventAdapter event) {
        String data = "";
        data = data + "ITEMIN=0:";
        if (event.getAuditInstance().getReferenceId() != null) {
            data = data + "ITEMID=" + event.getAuditInstance().getReferenceId() + ":";
        }
        return data;
    }

    private static String makeSubflowInstanceCreatedData(InstanceEventAdapter event) {
        String referenceId = event.getAuditInstance().getReferenceId();
        return referenceId == null ? "" : referenceId;
    }

    private static String makeStartTaskExecutionData(InstanceEventAdapter event) {
        String data = "";
        data = data + "ITEMIN=0:";
        if (event.getAuditInstance().getReferenceId() != null) {
            data = data + "ITEMID=" + event.getAuditInstance().getReferenceId() + ":";
        }
        data = data + "ITEMID=" + event.getAuditInstance().getActivityId() + ":";
        return data;
    }

    private static String makeTaskExecutionData(InstanceEventAdapter event) {
        String data = "";
        data = data + "ITEMIN=0:";
        data = event.getAuditInstance().getReferenceId() != null ? data + "ITEMID=" + event.getAuditInstance().getReferenceId() + ":" : data + "ITEMID=" + event.getAuditInstance().getActivityId() + ":";
        return data;
    }

    private static String makeInstanceOutData(InstanceEventAdapter event) {
        String data = "";
        data = event.getAuditInstance().getDueDate() != null ? data + "DUE=" + Boolean.TRUE + ":" : data + "DUE=" + Boolean.FALSE + ":";
        return data;
    }

    private static String makeTransitionData(InstanceEventAdapter event) {
        StringBuilder data = new StringBuilder();
        data.append("FROM=");
        data.append(event.getAuditInstance().getSourceActivity());
        data.append(":");
        data.append("TO=");
        data.append(event.getAuditInstance().getTargetActivity());
        data.append(":");
        String flowElement = event.getAuditInstance().getFlowElementType();
        if ("SEQUENCE".equalsIgnoreCase(flowElement)) {
            data.append("TYPE");
            data.append("=UNCONDITIONAL:");
        }
        return data.toString();
    }

    private static String makeExceptionData(InstanceEventAdapter event) {
        return "EXCEPTION=" + event.getAuditInstance().getFaultType() + ":";
    }
}

