/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.helper;

import fuego.papi.OperationException;
import fuego.papi.exception.CannotCreateInstanceException;
import fuego.papi.exception.InstanceOperationException;
import fuego.papi.exception.NoPermissionException;
import fuego.papi.exception.ProcessNotFoundException;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.services.common.exception.BPMException;

public class ExceptionHelper {
    public static OperationException wrapException(BPMException cause) {
        OperationException newException;
        try {
            switch (cause.getErrorCode()) {
                case 70204: {
                    String processId = (String)cause.getErrorArgs()[0];
                    newException = new CannotCreateInstanceException(processId);
                    newException.initCause((Throwable)cause);
                    break;
                }
                case 70206: {
                    String instanceId = (String)cause.getErrorArgs()[0];
                    newException = new InstanceOperationException(instanceId, (Throwable)cause);
                    break;
                }
                case 70205: {
                    String user = (String)cause.getErrorArgs()[2];
                    newException = new NoPermissionException(user);
                    newException.initCause((Throwable)cause);
                    break;
                }
                case 70207: {
                    String user = (String)cause.getErrorArgs()[2];
                    newException = new NoPermissionException(user);
                    newException.initCause((Throwable)cause);
                    break;
                }
                case 70806: {
                    String processId = (String)cause.getErrorArgs()[0];
                    newException = new ProcessNotFoundException(processId, (Throwable)cause);
                    break;
                }
                default: {
                    newException = OperationException.wrap((Throwable)cause);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("PAPI: Exception could not be properly wrapped. Using default wrapper exception for '" + (Object)((Object)cause) + "'.");
            newException = OperationException.wrap((Throwable)cause);
        }
        return newException;
    }

    public static OperationException wrapException(WorkflowException cause) {
        OperationException newException;
        try {
            switch (cause.getErrorCode()) {
                case 30513: {
                    String user = (String)cause.getErrorArgs()[0];
                    newException = new NoPermissionException(user);
                    newException.initCause((Throwable)cause);
                    break;
                }
                case 30515: {
                    String user = (String)cause.getErrorArgs()[0];
                    newException = new NoPermissionException(user);
                    newException.initCause((Throwable)cause);
                    break;
                }
                default: {
                    newException = OperationException.wrap((Throwable)cause);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("PAPI: Exception could not be properly wrapped. Using default wrapper exception for '" + (Object)((Object)cause) + "'.");
            newException = OperationException.wrap((Throwable)cause);
        }
        return newException;
    }
}

