/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.collections;

import fuego.papi.Ordering;
import java.io.Serializable;
import java.util.ArrayList;
import oracle.bpel.services.workflow.query.model.ObjectFactory;
import oracle.bpel.services.workflow.query.model.OrderingClauseType;
import oracle.bpel.services.workflow.query.model.TaskOrderingType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpm.papi.ora.helper.VarDefinitionHelper;

public class TaskOrdering
extends ArrayList<Entry> {
    public static final String SORT_ASC = "ASC";
    public static final String SORT_DESC = "DESC";
    private static final ObjectFactory objectFactory = new ObjectFactory();
    private static final long serialVersionUID = 20090813133700L;

    private TaskOrdering(int capacity) {
        super(capacity);
    }

    public static TaskOrdering create() {
        return new TaskOrdering(10);
    }

    public static TaskOrdering create(TaskOrderingType taskOrderingType) {
        TaskOrdering taskOrdering = new TaskOrdering(10);
        for (Object object : taskOrderingType.getClause()) {
            OrderingClauseType orderingClauseType = (OrderingClauseType)object;
            Column column = Column.getColumn((String)orderingClauseType.getTable(), (String)orderingClauseType.getColumn());
            if (column == null) continue;
            taskOrdering.add(Entry.create(column, orderingClauseType.getSortOrder()));
        }
        return taskOrdering;
    }

    public static TaskOrdering create(Ordering ordering) {
        TaskOrdering taskOrdering = new TaskOrdering(10);
        for (Ordering.Entry entry : ordering.toArray()) {
            Column column = VarDefinitionHelper.getColumnForVariable(entry.getVariableId());
            if (column == null) continue;
            taskOrdering.add(Entry.create(column, entry.isAscending()));
        }
        return taskOrdering;
    }

    public Entry[] toArray() {
        return super.toArray(new Entry[this.size()]);
    }

    public TaskOrderingType getBpelOrdering() {
        TaskOrderingType taskOrderingType = objectFactory.createTaskOrderingType();
        for (Entry entry : this.toArray()) {
            OrderingClauseType orderingClauseType = objectFactory.createOrderingClauseType();
            orderingClauseType.setTable(entry.getColumn().getTableName());
            orderingClauseType.setColumn(entry.getColumn().getName());
            orderingClauseType.setSortOrder(entry.getStringSorting());
            taskOrderingType.getClause().add(orderingClauseType);
        }
        return taskOrderingType;
    }

    public Ordering getPapiOrdering() {
        Ordering ordering = new Ordering();
        for (Entry entry : this.toArray()) {
            String variable = VarDefinitionHelper.getVariableIdForColumn(entry.getColumn());
            if (variable == null) continue;
            ordering.add(variable, entry.getSorting());
        }
        return ordering;
    }

    public static class Entry
    implements Serializable {
        private Column column;
        private boolean sorting;
        private static final long serialVersionUID = 20091106102200L;

        private Entry(Column column, boolean sorting) {
            this.column = column;
            this.sorting = sorting;
        }

        public Column getColumn() {
            return this.column;
        }

        public boolean getSorting() {
            return this.sorting;
        }

        public String getStringSorting() {
            return this.sorting ? TaskOrdering.SORT_ASC : TaskOrdering.SORT_DESC;
        }

        protected static Entry create(Column column) {
            return new Entry(column, true);
        }

        protected static Entry create(Column column, boolean sorting) {
            return new Entry(column, sorting);
        }

        protected static Entry create(Column column, String strSorting) {
            boolean sorting = strSorting == null || !TaskOrdering.SORT_DESC.equalsIgnoreCase(strSorting);
            return new Entry(column, sorting);
        }
    }
}

