/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.collections;

import fuego.papi.Presentation;
import fuego.papi.ProcessServiceSession;
import fuego.papi.VarDefinition;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import oracle.bpel.services.workflow.user.model.ColumnListType;
import oracle.bpel.services.workflow.user.model.ColumnType;
import oracle.bpel.services.workflow.user.model.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public class PapiColumnList
extends ArrayList<Presentation.Column> {
    private static final long serialVersionUID = 20090813133830L;

    private PapiColumnList(int capacity) {
        super(capacity);
    }

    public static PapiColumnList create() {
        return new PapiColumnList(10);
    }

    public static PapiColumnList create(Presentation.Column[] papiColumns) {
        PapiColumnList papiColumnList = new PapiColumnList(10);
        papiColumnList.addAll(Arrays.asList(papiColumns));
        return papiColumnList;
    }

    public static PapiColumnList create(@NotNull ProcessServiceSession session, @NotNull ColumnListType columnListType) {
        PapiColumnList papiColumnList = new PapiColumnList(10);
        for (Object object : columnListType.getColumn()) {
            if (object == null) continue;
            ColumnType columnType = (ColumnType)object;
            String columnName = columnType.getColumnName();
            int columnWidth = columnType.getColumnWidth() == null ? 25 : columnType.getColumnWidth().intValue();
            Presentation.Column papiColumn = new Presentation.Column(columnName, columnWidth);
            VarDefinition varDefinition = session.variableGet(columnName);
            if (varDefinition != null) {
                papiColumn.setVarDefinition(varDefinition);
            }
            papiColumnList.add(papiColumn);
        }
        return papiColumnList;
    }

    public Presentation.Column[] toArray() {
        return super.toArray(new Presentation.Column[this.size()]);
    }

    public ColumnListType getBpelColumns() {
        ObjectFactory factory = new ObjectFactory();
        ColumnListType columnListType = factory.createColumnListType();
        for (Presentation.Column column : this.toArray()) {
            ColumnType columnType = factory.createColumnType();
            columnType.setColumnName(column.getId());
            columnType.setColumnWidth(new BigInteger(String.valueOf(column.getSize())));
            columnType.setDisplayName(column.getLabel(Locale.getDefault()));
            if (column.getColumnFormat() != null) {
                columnType.setFormatMask(column.getColumnFormat().getPattern());
            }
            columnListType.getColumn().add(columnType);
        }
        return columnListType;
    }

    public Presentation.Column[] getPapiColumns() {
        return this.toArray();
    }
}

