/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.collections;

import fuego.papi.Presentation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Locale;
import oracle.bpel.services.workflow.user.model.ColumnListType;
import oracle.bpel.services.workflow.user.model.ColumnType;
import oracle.bpel.services.workflow.user.model.ObjectFactory;

public class ColumnTypeList
extends ArrayList<ColumnType> {
    private static final long serialVersionUID = 20090813133830L;

    private ColumnTypeList(int capacity) {
        super(capacity);
    }

    public static ColumnTypeList create() {
        return new ColumnTypeList(10);
    }

    public static ColumnTypeList create(Presentation.Column[] papiColumns) {
        ColumnTypeList columnTypeList = new ColumnTypeList(10);
        for (Presentation.Column column : papiColumns) {
            ObjectFactory factory = new ObjectFactory();
            ColumnType columnType = factory.createColumnType();
            columnType.setColumnName(column.getId());
            columnType.setColumnWidth(new BigInteger(String.valueOf(column.getSize())));
            columnType.setDisplayName(column.getLabel(Locale.getDefault()));
            if (column.getColumnFormat() != null) {
                columnType.setFormatMask(column.getColumnFormat().getPattern());
            }
            columnTypeList.add(columnType);
        }
        return columnTypeList;
    }

    public static ColumnTypeList create(ColumnListType columnListType) {
        ColumnTypeList columnTypeList = new ColumnTypeList(10);
        for (Object object : columnListType.getColumn()) {
            columnTypeList.add((ColumnType)object);
        }
        return columnTypeList;
    }

    public ColumnType[] toArray() {
        return super.toArray(new ColumnType[this.size()]);
    }

    public ColumnListType getBpelColumns() {
        ColumnListType columnListType = new ObjectFactory().createColumnListType();
        for (ColumnType column : this.toArray()) {
            columnListType.getColumn().add(column);
        }
        return columnListType;
    }

    public Presentation.Column[] getPapiColumns() {
        ArrayList<Presentation.Column> papiColumns = new ArrayList<Presentation.Column>();
        for (ColumnType column : this.toArray()) {
            String columnName = column.getColumnName();
            int columnSize = column.getColumnWidth() != null ? column.getColumnWidth().intValue() : 25;
            Presentation.Column papiColumn = new Presentation.Column(columnName, columnSize);
            papiColumns.add(papiColumn);
        }
        return papiColumns.toArray(new Presentation.Column[papiColumns.size()]);
    }
}

