/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.Activity;
import fuego.papi.ApplicationsView;
import fuego.papi.Arguments;
import fuego.papi.Attachment;
import fuego.papi.AttachmentsView;
import fuego.papi.BatchOperationException;
import fuego.papi.CommunicationException;
import fuego.papi.Comparison;
import fuego.papi.Consult;
import fuego.papi.EditablePresentation;
import fuego.papi.EditableView;
import fuego.papi.Filter;
import fuego.papi.GlobalExecution;
import fuego.papi.InstanceInfo;
import fuego.papi.InstancesView;
import fuego.papi.Note;
import fuego.papi.ObjectClassInstance;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.Ordering;
import fuego.papi.Participant;
import fuego.papi.ParticipantFor;
import fuego.papi.ParticipantScope;
import fuego.papi.Presentation;
import fuego.papi.PresentationType;
import fuego.papi.Process;
import fuego.papi.ProcessDiagram;
import fuego.papi.ProcessNotAvailableException;
import fuego.papi.ProcessService;
import fuego.papi.PropertyOperationException;
import fuego.papi.SearchScope;
import fuego.papi.StatusScope;
import fuego.papi.Task;
import fuego.papi.TaskExecution;
import fuego.papi.VarDefinition;
import fuego.papi.View;
import fuego.papi.ViewOperationException;
import fuego.papi.ViewType;
import fuego.papi.attachment.AttachmentStorageType;
import fuego.papi.collections.ActivityList;
import fuego.papi.collections.AttachmentList;
import fuego.papi.collections.InstanceActivityPair;
import fuego.papi.collections.InstanceActivityPairSet;
import fuego.papi.collections.InstanceEventList;
import fuego.papi.collections.InstanceInfoList;
import fuego.papi.collections.NoteList;
import fuego.papi.collections.ParticipantList;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.collections.ProcessList;
import fuego.papi.collections.VarDefinitionList;
import fuego.papi.exception.ActivityCannotRunException;
import fuego.papi.exception.ApplicationsNotAvailableException;
import fuego.papi.exception.AttachmentNotFoundException;
import fuego.papi.exception.InstanceNotFoundException;
import fuego.papi.exception.InstancesException;
import fuego.papi.exception.InstancesNotAvailableInEngineException;
import fuego.papi.exception.InvalidVariableIdException;
import fuego.papi.exception.NoPermissionException;
import fuego.papi.exception.PresentationNotFoundException;
import fuego.papi.exception.TaskSelectedByOtherException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.util.WorkflowAttachmentUtil;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.WorkflowContext;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.log.Log;
import oracle.bpm.papi.ora.AttachmentAdapter;
import oracle.bpm.papi.ora.BaseSessionAdapter;
import oracle.bpm.papi.ora.ConnectionPassportAdapter;
import oracle.bpm.papi.ora.InstanceEventAdapter;
import oracle.bpm.papi.ora.InstanceInfoAdapter;
import oracle.bpm.papi.ora.NoteAdapter;
import oracle.bpm.papi.ora.ProcessDiagramAdapter;
import oracle.bpm.papi.ora.ProcessServiceAdapter;
import oracle.bpm.papi.ora.ProcessServiceAdminSessionAdapter;
import oracle.bpm.papi.ora.ProcessServiceCache;
import oracle.bpm.papi.ora.helper.ExceptionHelper;
import oracle.bpm.papi.ora.helper.VarDefinitionHelper;
import oracle.bpm.papi.ora.layout.ObjectClassQuery;
import oracle.bpm.papi.ora.metadata.ProcessAdapter;
import oracle.bpm.papi.ora.mgr.OrganizationManager;
import oracle.bpm.papi.ora.mgr.SessionPresentationManager;
import oracle.bpm.papi.ora.mgr.SessionProcessManager;
import oracle.bpm.papi.ora.mgr.SessionViewManager;
import oracle.bpm.papi.ora.org.ParticipantAdapter;
import oracle.bpm.papi.ora.util.ExecutionURLUtils;
import oracle.bpm.papi.ora.util.FilterQueryUtils;
import oracle.bpm.papi.ora.util.PropertiesHelper;
import oracle.bpm.papi.ora.view.FilterAdapter;
import oracle.bpm.papi.ora.view.PresentationAdapterUtils;
import oracle.bpm.papi.ora.view.ViewAdapter;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.instancemanagement.IInstanceManagementService;
import oracle.bpm.services.instancemanagement.model.IProcessAttachment;
import oracle.bpm.services.instancemanagement.model.IProcessComment;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.impl.ProcessAttachment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessComment;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import oracle.bpm.services.permissions.IPermissionsService;
import oracle.bpm.util.Base64;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.FileUtils;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;
import org.jetbrains.annotations.NotNull;

public class ProcessServiceSessionAdapter
extends BaseSessionAdapter {
    private transient IBPMContext bpmContext;
    private transient IBPMServiceClient bpmServiceClient;
    private transient BPMUser bpmUser;
    private transient String currentHost;
    private transient ConnectionPassportAdapter currentPassport;
    private volatile boolean isOpened;
    private transient ParticipantAdapter participant;
    private transient SessionPresentationManager presentationManager;
    private transient SessionProcessManager processManager;
    private transient ProcessServiceAdapter processService;
    private transient String sessionId;
    private transient Map<String, Object> sessionProperties;
    private transient SessionViewManager viewManager;
    private transient IWorkflowServiceClient wfServiceClient;
    private static final long serialVersionUID = 4252548381169481478L;

    ProcessServiceSessionAdapter(ProcessServiceAdapter processService, ConnectionPassportAdapter passport, String host, IBPMContext bpmContext) throws OperationException {
        this.processService = processService;
        this.currentPassport = passport;
        this.currentHost = host;
        this.bpmContext = bpmContext;
        this.bpmServiceClient = processService.getBPMServiceClientFactory().getBPMServiceClient();
        this.wfServiceClient = processService.getBPMServiceClientFactory().getWorkflowServiceClient();
        this.processManager = SessionProcessManager.create(this);
        this.viewManager = new SessionViewManager(this);
        this.presentationManager = new SessionPresentationManager(this);
        this.sessionId = String.valueOf(System.currentTimeMillis());
        this.sessionProperties = new HashMap<String, Object>();
        this.participant = OrganizationManager.lookupParticipant(this);
        this.isOpened = true;
    }

    public InstanceInfoList processesGetInstancesByFilter(ProcessIdSet processes, Filter filter) throws BatchOperationException {
        InstanceInfoList instances = InstanceInfoList.create();
        if (filter == null) {
            return instances;
        }
        Participant participant = this.participantCurrent();
        ParticipantScope participantScope = filter.getSearchScope().getParticipantScope();
        if (participantScope == ParticipantScope.ALL && !participant.isAdministrator()) {
            return instances;
        }
        if (participantScope == ParticipantScope.ALL_IN_ROLE) {
            return instances;
        }
        if (processes == null || processes.isEmpty()) {
            return instances;
        }
        ProcessIdSet processIds = ProcessIdSet.create();
        for (String processId : processes) {
            processIds.addAll((List)this.processGetAllVersions(processId));
        }
        if (processIds.isEmpty()) {
            return instances;
        }
        try {
            Predicate predicate = FilterQueryUtils.getQueryPredicate(this, processIds, filter);
            if (predicate != null) {
                instances = this.processesGetInstancesByPredicate(predicate, FilterQueryUtils.getInstanceQueryInput(filter), FilterQueryUtils.getWorkflowOrdering(filter));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        return instances;
    }

    public InstanceInfoList processesGetInstancesByPredicate(Predicate predicate, IInstanceQueryInput queryInput, oracle.bpel.services.workflow.repos.Ordering ordering) throws BatchOperationException {
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            if (ordering == null) {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
                ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            }
            if (queryInput == null) {
                queryInput = new InstanceQueryInput();
                queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP);
                queryInput.addState("OPEN");
            }
            IInstanceQueryService processQueryService = this.getBPMServiceClient().getInstanceQueryService();
            ProcessIdSet processes = ProcessIdSet.create().addAll((List)this.processesGetIds());
            List<Column> displayColumns = FilterQueryUtils.getDisplayColumns(this, processes);
            List processInstances = processQueryService.queryInstances(this.getBPMContext(), displayColumns, predicate, ordering, queryInput);
            for (IProcessInstance processInstance : processInstances) {
                instances.add((Object)InstanceInfoAdapter.create(this, processInstance));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        return instances;
    }

    public IWorkflowServiceClient getWorkflowServiceClient() {
        return this.wfServiceClient;
    }

    public IBPMServiceClient getBPMServiceClient() {
        return this.bpmServiceClient;
    }

    public IBPMContext getBPMContext() {
        return this.bpmContext;
    }

    public SessionProcessManager getProcessManager() {
        return this.processManager;
    }

    public SessionViewManager getViewManager() {
        return this.viewManager;
    }

    public SessionPresentationManager getPresentationManager() {
        return this.presentationManager;
    }

    public ConnectionPassportAdapter getPassport() {
        return this.currentPassport;
    }

    public BPMUser getBPMUser() throws OperationException {
        if (this.bpmUser == null) {
            try {
                this.bpmUser = this.processService.getBPMIdentityService().lookupUser(this.getBPMContext().getUser());
            }
            catch (BPMIdentityException cause) {
                throw new OperationException((Throwable)cause);
            }
        }
        return this.bpmUser;
    }

    public boolean isAdministrator() {
        return false;
    }

    public InstanceInfo activityCommit(Activity activity, InstanceInfo instance, Arguments args) throws OperationException {
        return this.processGetInstance(instance.getId());
    }

    public void activityAbort(Activity activity, int taskIn, InstanceInfo instance) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public TaskExecution activityPost(Activity activity, InstanceInfo instance, int taskToExecute, Arguments args) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instanceAttach_old(InstanceInfo instanceInfo, String name, String description, String remarks, File file, String contentType, Locale locale, AttachmentStorageType storageType) throws OperationException, IOException {
        try {
            ProcessAttachment attachment = new ProcessAttachment();
            attachment.setName(file.getName());
            attachment.setMimeType(contentType);
            byte[] bytes = FileUtils.readBytes((File)file);
            String content = Base64.encode((byte[])bytes);
            attachment.setContent(content);
            attachment.setMimeType(contentType);
            IInstanceManagementService service = this.getBPMServiceClient().getInstanceManagementService();
            service.addAttachment(this.getBPMContext(), this.getProcessInstance(instanceInfo), (IProcessAttachment)attachment);
        }
        catch (Exception e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void instanceAttach(InstanceInfo instanceInfo, String name, String description, String remarks, File file, String contentType, Locale locale, AttachmentStorageType storageType) throws OperationException, IOException {
        try {
            IBPMContext context = this.getBPMContext();
            String soaUrl = this.getWorkflowServiceClient().getRuntimeConfigService().getInternalServerURL();
            String taskId = this.getProcessInstance(instanceInfo).getSystemAttributes().getProcessInstanceId();
            int version = this.getProcessInstance(instanceInfo).getSystemAttributes().getVersion();
            FileInputStream inputStream = new FileInputStream(file);
            WorkflowAttachmentUtil.uploadAttachment((IWorkflowContext)context, (IWorkflowServiceClient)this.wfServiceClient, (String)taskId, (int)version, (String)file.getName(), (String)contentType, (InputStream)inputStream, (String)description, null, null);
        }
        catch (Exception e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void instanceLinkExternalAttachment(InstanceInfo instanceInfo, String externalId, AttachmentStorageType storageType) throws OperationException, IOException {
        IInstanceManagementService managementService = this.getBPMServiceClient().getInstanceManagementService();
        IProcessInstance instance = this.getProcessInstance(instanceInfo);
        ProcessAttachment attachment = new ProcessAttachment();
        attachment.setURI(externalId);
        attachment.setName(externalId);
        try {
            managementService.addAttachment(this.getBPMContext(), instance, (IProcessAttachment)attachment);
        }
        catch (BPMException e) {
            throw new RuntimeException(e);
        }
    }

    public ActivityList instanceGetGlobalActivities(InstanceInfo instance) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public InstanceInfoList activityGetGrabbableInstances(Activity activity) throws OperationException, BatchOperationException {
        StringList processIds = this.processGetAllVersions(activity.getProcessId());
        FilterAdapter filter = FilterAdapter.create();
        filter.setMatchAll(false);
        filter.setSearchScope(new SearchScope(ParticipantScope.ALL_IN_ROLE, StatusScope.ONLY_INPROCESS, null));
        VarDefinition varActivity = VarDefinition.getDefaultVarDefinition((String)"PREDEFINE_ACTIVITY");
        for (Activity source : activity.getSourceActivitiesForGrab()) {
            filter.addAttribute(varActivity, Comparison.IS, (Object)source.getName());
        }
        return this.processesGetInstancesByFilter(this.getProcessSet(processIds), filter);
    }

    public ParticipantList instancesGetParticipants(InstanceActivityPairSet instanceActivityPairSet, ParticipantFor participantFor, String filter, int max) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void attachmentCheckIn(Attachment attachment, String remarks, File file) throws OperationException {
        AttachmentAdapter attachmentAdapter = (AttachmentAdapter)attachment;
        IInstanceManagementService service = this.getBPMServiceClient().getInstanceManagementService();
        try {
            service.addAttachment(this.getBPMContext(), this.getProcessInstance(attachment.getInstanceId()), attachmentAdapter.getProcessAttachment());
        }
        catch (BPMException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void attachmentCheckOut(Attachment attachment, String folder) throws OperationException {
        try {
            File fileFolder = new File(folder);
            File file = new File(fileFolder, attachment.getName());
            this.attachmentCheckOutToStream(attachment, (OutputStream)new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public final boolean instanceCanBeAborted(InstanceInfo instance) {
        boolean canBeAborted = false;
        try {
            List actions;
            boolean statusOk;
            boolean bl = statusOk = instance.getStatus() == 1;
            if (statusOk && (actions = this.getBPMServiceClient().getInstanceManagementService().getAllowedActions(this.getBPMContext(), this.getProcessInstance(instance))).contains(IPermissionsService.InstanceAction.CANCEL.toString())) {
                canBeAborted = true;
            }
        }
        catch (OperationException e) {
            throw new OperationRuntimeException((Throwable)e);
        }
        catch (BPMException e) {
            throw new OperationRuntimeException((Throwable)e);
        }
        return canBeAborted;
    }

    public boolean instanceCanBeSentBack(InstanceInfo instance) {
        return false;
    }

    public final boolean instanceCanBeProcessed(InstanceInfo instance) {
        if (this.isInstancePendingMigration(instance)) {
            return false;
        }
        oracle.bpel.services.workflow.task.model.Task task = null;
        if (instance instanceof InstanceInfoAdapter) {
            task = ((InstanceInfoAdapter)instance).getHumanWorkflowTask();
        }
        if (task == null) {
            try {
                Process process = this.processGet(instance.getProcessId());
                Activity activity = process.getActivity(instance.getActivityName());
                if (activity != null && activity.getType() == 0x80000D) {
                    InstanceInfoAdapter instanceAdapter = (InstanceInfoAdapter)this.processGetInstance(instance.getId());
                    task = instanceAdapter.getHumanWorkflowTask();
                }
            }
            catch (OperationException initCause) {
                throw new OperationRuntimeException((Throwable)initCause);
            }
        }
        return this.taskCanBeProcessed(task);
    }

    public final boolean instanceCanBeReassigned(InstanceInfo instance) {
        return false;
    }

    public boolean instanceCanBeDelegated(InstanceInfo instance) {
        return false;
    }

    public boolean instanceCanBeEscalated(InstanceInfo instance) {
        return false;
    }

    public boolean instanceCanBeReassignedToPeer(InstanceInfo instance) {
        return false;
    }

    public final boolean instanceCanBeResumed(InstanceInfo instance) {
        return false;
    }

    public final boolean instanceCanBeSelected(InstanceInfo instance) {
        return false;
    }

    public final boolean instanceCanBeSent(InstanceInfo instance) {
        return false;
    }

    public final boolean instanceCanBeSuspended(InstanceInfo instance) {
        return false;
    }

    public final boolean instanceCanBeUngrabbed(InstanceInfo instance) {
        return false;
    }

    public final boolean instanceCanBeUnselected(InstanceInfo instance) {
        return false;
    }

    public void instancesAbort(InstanceActivityPairSet instanceActivityPairs) throws OperationException, BatchOperationException {
        for (InstanceActivityPair instanceActivityPair : instanceActivityPairs) {
            String instanceId = instanceActivityPair.getInstanceId();
            try {
                this.getBPMServiceClient().getInstanceManagementService().cancelProcessInstance(this.getBPMContext(), this.getProcessInstance(instanceId));
            }
            catch (BPMException e) {
                throw ExceptionHelper.wrapException(e);
            }
        }
    }

    public void instancesAddConsult(InstanceActivityPairSet instanceActivityPairs, String consult, String toParticipant) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesAddNote(InstanceActivityPairSet instanceActivityPairs, String note) throws OperationException, BatchOperationException {
        ProcessComment comment = new ProcessComment();
        comment.setComment(note);
        for (InstanceActivityPair instanceActivityPair : instanceActivityPairs) {
            String instanceId = instanceActivityPair.getInstanceId();
            IProcessInstance processInstance = this.getProcessInstance(instanceId);
            try {
                this.getBPMServiceClient().getInstanceManagementService().addComment(this.getBPMContext(), processInstance, (IProcessComment)comment);
            }
            catch (BPMException e) {
                throw new OperationException((Throwable)e);
            }
        }
    }

    public void instancesGrab(InstanceActivityPairSet instanceActivityPairs, String grabActivityName) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesResume(InstanceActivityPairSet instanceActivityPairs) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesReassign(InstanceActivityPairSet instanceActivityPairSet, String participant) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesSelect(InstanceActivityPairSet instanceActivityPairs) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesSend(InstanceActivityPairSet instanceActivityPairs) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesSendBack(InstanceActivityPairSet instanceActivityPairs, boolean skip) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesSendTo(InstanceActivityPairSet instanceActivityPairs, String activityName, String participant) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesSuspend(InstanceActivityPairSet instanceActivityPairs) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Map instancesGetTargetParticipantsForActivity(InstanceActivityPairSet instanceActivityPairs, String activityName, String filter, int max) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public ActivityList instancesGetTargetActivitiesList(InstanceActivityPairSet instanceActivityPairs) throws BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesUngrab(InstanceActivityPairSet instanceActivityPairs) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesUnselect(InstanceActivityPairSet instanceActivityPairs) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void attachmentEdit(Attachment attachment) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Arguments activityPrepare(Activity activity, InstanceInfo instance, Arguments args) throws OperationException {
        if (activity != null && activity.getType() != 0x80000D) {
            throw new ActivityCannotRunException(activity.getLabel(this.participantLocale()));
        }
        oracle.bpel.services.workflow.task.model.Task task = null;
        if (instance instanceof InstanceInfoAdapter) {
            task = ((InstanceInfoAdapter)instance).getHumanWorkflowTask();
        }
        if (task == null) {
            InstanceInfoAdapter instanceAdapter = (InstanceInfoAdapter)this.processGetInstance(instance.getId());
            task = instanceAdapter.getHumanWorkflowTask();
        }
        if (task == null) {
            throw new TaskSelectedByOtherException();
        }
        return ExecutionURLUtils.buildTaskDetailsArguments((IWorkflowContext)this.getBPMContext(), task, args, this.getWorkflowServiceClient());
    }

    public void attachmentRelease(Attachment attachment) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesRemoveBookmark(InstanceActivityPairSet instanceActivityPairs) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public final boolean taskCanBeProcessed(InstanceInfo instance, int taskNumber) {
        return taskNumber == 0 && this.instanceCanBeProcessed(instance);
    }

    public final boolean taskCanBeSelected(InstanceInfo instance, int taskNumber) {
        return false;
    }

    public final boolean taskCanBeUnselected(InstanceInfo instance, int taskNumber) {
        return false;
    }

    public void tasksSelect(InstanceInfo instance, int[] taskNumbers) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void tasksUnselect(InstanceInfo instance, int[] taskNumbers) throws OperationException, BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public String processGetActiveVersion(String process) {
        ProcessIdSet processIdSet;
        try {
            processIdSet = this.processManager.getActiveVersions(process);
        }
        catch (Exception e) {
            throw new OperationRuntimeException((Throwable)e);
        }
        if (processIdSet.size() == 0) {
            return "";
        }
        return processIdSet.toArray()[processIdSet.size() - 1];
    }

    public String activityGetDocumentation(Activity activity, Locale locale) throws OperationException {
        try {
            ProcessAdapter adapter = this.processManager.getProcess(activity.getProcessId());
            Sequence activities = adapter.getProcess().getActivities();
            for (oracle.bpm.project.model.processes.Activity _activity : activities) {
                if (!_activity.getId().equalsIgnoreCase(activity.getId())) continue;
                return _activity.getDocumentationMap().getString(locale);
            }
        }
        catch (BPMException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public ActivityList viewGetApplications(ApplicationsView view) throws OperationException, BatchOperationException {
        ProcessIdSet processIdSet = ProcessIdSet.create();
        for (String consolidatedProcessId : view.getAssignedProcesses()) {
            processIdSet.addAll((List)this.processGetAllVersions(consolidatedProcessId));
        }
        return this.processesGetApplications(processIdSet);
    }

    @Override
    public ActivityList viewGetApplications(String applicationViewId) throws OperationException, BatchOperationException {
        View view = this.viewGet(applicationViewId);
        if (view.getType() == ViewType.APPLICATIONS) {
            return this.viewGetApplications((ApplicationsView)view);
        }
        return ActivityList.create();
    }

    public Attachment attachmentGet(String attachmentId) throws OperationException {
        int indexOf = attachmentId.lastIndexOf("#");
        String instanceId = attachmentId.substring(0, indexOf);
        String name = attachmentId.substring(indexOf + 1);
        for (Attachment attachment : this.instanceGetAttachments(instanceId)) {
            if (!attachment.getName().equalsIgnoreCase(name)) continue;
            return attachment;
        }
        throw new AttachmentNotFoundException(attachmentId);
    }

    public Attachment attachmentGetLastVersion(String attachmentId) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public AttachmentList attachmentGetAllVersions(String attachmentId) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public AttachmentList instanceGetAttachments(InstanceInfo instance) throws OperationException {
        AttachmentList ret = AttachmentList.create();
        IProcessInstance processInstance = this.getProcessInstance(instance);
        List attachmentList = processInstance.getAttachment();
        for (IProcessAttachment attach : attachmentList) {
            String description = attach.getMimeType();
            AttachmentAdapter attachment = AttachmentAdapter.create(attach, processInstance, description);
            ret.add((Object)attachment);
        }
        Collections.reverse(ret);
        return ret;
    }

    public AttachmentList viewGetAttachments(AttachmentsView view) throws BatchOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public StringList instancesGetBookmarks() throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Calendar participantCalendar() throws OperationException {
        return Calendar.getInstance(this.participantTimeZone(), this.participantLocale());
    }

    public Map<String, View> viewGetChildren(String viewId) {
        return this.viewManager.getChildrenViews(viewId);
    }

    public Consult instanceGetLastConsult(InstanceInfo instance) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public StringList instancesGetConsults() throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void viewsSetDefaultOrder(String variableId, boolean ascendingOrder) throws InvalidVariableIdException {
        Ordering ordering = new Ordering();
        ordering.add(variableId, ascendingOrder);
        this.viewManager.setDefaultOrdering(ordering);
    }

    public Presentation presentationGetDefault(PresentationType presentationType) {
        return PresentationAdapterUtils.getDefaultPresentation(presentationType);
    }

    public Presentation presentationGetDefault(ViewType viewType) {
        return PresentationAdapterUtils.getDefaultPresentation(viewType);
    }

    public EditableView viewEdit(View view) throws ViewOperationException {
        return this.viewManager.getEditableView(view);
    }

    public ActivityList processesGetGlobalActivities(ProcessIdSet processIdSet, boolean hasInstanceAccess) throws BatchOperationException {
        HashMap<String, OperationException> exceptions = new HashMap<String, OperationException>();
        ActivityList activities = ActivityList.create();
        for (String processId : processIdSet) {
            try {
                Process process = this.processGet(processId);
                for (Activity activity : process.getActivities()) {
                    if (!activity.hasType(4) || activity.hasType(1)) continue;
                    activities.add((Object)activity);
                }
            }
            catch (OperationException e) {
                exceptions.put(processId, e);
            }
        }
        if (exceptions.isEmpty()) {
            return activities;
        }
        throw new ApplicationsNotAvailableException((List)activities, exceptions);
    }

    public ActivityList processesGetApplications(ProcessIdSet processes) throws BatchOperationException {
        return this.getProcessManager().getApplications(processes);
    }

    public ActivityList processesGetGlobalActivities(ProcessIdSet processIdSet, int taskType, boolean hasInstanceAccess) throws BatchOperationException {
        ActivityList activities = ActivityList.create();
        for (Activity activity : this.processesGetGlobalActivities(processIdSet, hasInstanceAccess)) {
            for (Task task : activity.getTasks()) {
                if (task.getType() != taskType) continue;
                activities.add((Object)activity);
            }
        }
        return activities;
    }

    public ActivityList instanceGrabbableFrom(InstanceInfo instance) throws OperationException {
        return ActivityList.create();
    }

    public String participantHost() {
        return this.currentHost;
    }

    public InstanceInfo processGetInstance(String instanceId, String activityName) throws OperationException {
        return this.processGetInstance(instanceId);
    }

    public InstanceInfo processGetInstance(String instanceId) throws OperationException {
        try {
            IInstanceQueryService queryService = this.getBPMServiceClient().getInstanceQueryService();
            IProcessInstance instance = queryService.getProcessInstance(this.getBPMContext(), instanceId);
            if (instance == null) {
                throw new InstanceNotFoundException(instanceId);
            }
            InstanceInfoAdapter instanceAdpater = InstanceInfoAdapter.create(this, instance);
            this.instanceGetTask(instanceAdpater, instance);
            return instanceAdpater;
        }
        catch (BPMException e) {
            throw ExceptionHelper.wrapException(e);
        }
    }

    public InstanceInfo processGetInstanceByCorrelation(String processId, String correlationName, Object[] correlationValues) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public DynamicObject instanceGetData(InstanceInfo instance) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public InstanceEventList instanceGetEvents(InstanceInfo instance) throws OperationException {
        InstanceEventList events = InstanceEventList.create();
        try {
            IInstanceQueryService service = this.getBPMServiceClient().getInstanceQueryService();
            List auditInstances = service.queryAuditInstanceByProcessId(this.getBPMContext(), instance.getId());
            TreeSet<String> transitions = new TreeSet<String>();
            for (IAuditInstance auditInstance : auditInstances) {
                String transitionId;
                events.add((Object)InstanceEventAdapter.create(auditInstance));
                String sourceActivity = auditInstance.getSourceActivity();
                String targetActivity = auditInstance.getTargetActivity();
                if (sourceActivity == null || sourceActivity.isEmpty() || targetActivity == null || targetActivity.isEmpty() || sourceActivity.equalsIgnoreCase(targetActivity) || transitions.contains(transitionId = sourceActivity + "-" + targetActivity)) continue;
                events.add((Object)InstanceEventAdapter.createTransitionEvent(auditInstance));
                transitions.add(transitionId);
            }
        }
        catch (BPMException e) {
            throw ExceptionHelper.wrapException(e);
        }
        return events;
    }

    public NoteList instanceGetNotes(InstanceInfo instance) throws OperationException {
        if (instance == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        List<NoteAdapter> adapterList = NoteAdapter.create(this, this.getProcessInstance(instance));
        NoteList noteList = NoteList.create();
        noteList.addAll(adapterList);
        Collections.reverse(noteList);
        return noteList;
    }

    public InstanceInfoList processGetInstances(String processId) throws OperationException {
        InstanceInfoList instances = InstanceInfoList.create();
        if (processId != null && !processId.isEmpty()) {
            try {
                IInstanceQueryService instanceQueryService = this.getBPMServiceClient().getInstanceQueryService();
                Predicate predicate = new Predicate(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)processId);
                InstanceQueryInput queryInput = new InstanceQueryInput();
                queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
                ProcessIdSet processes = ProcessIdSet.create().add(processId);
                List<Column> displayColumns = FilterQueryUtils.getDisplayColumns(this, processes);
                List processInstances = instanceQueryService.queryInstances(this.getBPMContext(), displayColumns, predicate, null, (IInstanceQueryInput)queryInput);
                for (IProcessInstance processInstance : processInstances) {
                    instances.add((Object)InstanceInfoAdapter.create(this, processInstance));
                }
            }
            catch (WorkflowException e) {
                throw new OperationException((Throwable)e);
            }
            catch (BPMException e) {
                throw new OperationException((Throwable)e);
            }
        }
        return instances;
    }

    public InstanceInfoList viewGetInstances(InstancesView view) throws OperationException, BatchOperationException {
        return this.viewManager.getInstancesByView(view);
    }

    public void participantUpdateLocale(Locale locale) throws OperationException {
        this.getBPMContext().setLocale(locale);
    }

    public Locale participantLocale() throws OperationException {
        return this.getBPMContext().getLocale();
    }

    public Note noteGet(String noteId) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public String organization() {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public StringList organizations() {
        StringList orgs = StringList.create();
        orgs.add((Object)this.organization());
        return orgs;
    }

    @Override
    public View viewGetParent(String viewId) throws OperationException {
        return this.viewGetParent(this.viewGet(viewId));
    }

    public View viewGetParent(View view) throws OperationException {
        return this.viewManager.getParentView(view);
    }

    public String viewGetParentId(String viewId) {
        return ViewAdapter.getParentId(viewId);
    }

    public Participant participantCurrent() {
        if (this.participant == null) {
            try {
                this.participant = OrganizationManager.lookupParticipant(this);
            }
            catch (OperationException initCause) {
                throw new OperationRuntimeException((Throwable)initCause);
            }
        }
        return this.participant;
    }

    public Participant participantFind(String uid) throws OperationException {
        return OrganizationManager.lookupParticipant(this, uid, false);
    }

    public Presentation presentationGet(String presentationId) {
        return this.presentationManager.get(presentationId);
    }

    public Presentation presentationGet(PresentationType presentationType, String presentationId) throws OperationException {
        Presentation presentation = this.presentationManager.get(presentationId);
        if (presentation == null || presentation.getType() != presentationType) {
            throw new PresentationNotFoundException(presentationId, presentationType);
        }
        return presentation;
    }

    public Presentation presentationGet(ViewType viewType, String presentationId) throws OperationException {
        switch (viewType) {
            case ACTIVITY_INSTANCES: {
                return this.presentationGet(PresentationType.ACTIVITY, presentationId);
            }
            case APPLICATIONS: {
                return this.presentationGet(PresentationType.APPLICATIONS, presentationId);
            }
            case ATTACHMENTS: {
                return this.presentationGet(PresentationType.ATTACHMENTS, presentationId);
            }
            case FOLDER: {
                return this.presentationGet(PresentationType.FOLDER, presentationId);
            }
            case BOOKMARKS: 
            case CONSULTATIONS: 
            case HISTORY: 
            case INSTANCES: {
                return this.presentationGet(PresentationType.INSTANCES, presentationId);
            }
        }
        throw new PresentationNotFoundException(presentationId, PresentationType.INSTANCES);
    }

    public StringList presentationsGetIds(PresentationType presentationType) throws OperationException {
        return StringList.create(this.presentationManager.getIds(presentationType));
    }

    public Process processGet(String processId) throws OperationException {
        try {
            return this.processManager.getProcess(processId);
        }
        catch (BPMException cause) {
            throw new ProcessNotAvailableException(processId, (Throwable)cause);
        }
    }

    public Process processGet(String processId, String mdsLabel) throws OperationException {
        try {
            return this.processManager.getProcess(processId, mdsLabel);
        }
        catch (BPMException cause) {
            throw new ProcessNotAvailableException(processId, (Throwable)cause);
        }
    }

    public ProcessDiagram processGetDiagram(Process process, String mdsLabel) throws OperationException {
        try {
            return new ProcessDiagramAdapter(this.processManager.getProcess(process.getId(), mdsLabel));
        }
        catch (BPMException e) {
            throw new OperationException((Throwable)e);
        }
    }

    @Override
    public ProcessDiagram processGetDiagram(String processId, String mdsLabel) throws ProcessNotAvailableException {
        try {
            return new ProcessDiagramAdapter(this.processManager.getProcess(processId, mdsLabel));
        }
        catch (OperationException e) {
            throw new ProcessNotAvailableException(processId, (Throwable)e);
        }
        catch (BPMException e) {
            throw new ProcessNotAvailableException(processId, (Throwable)e);
        }
    }

    public ProcessDiagram processGetDiagram(Process process) throws OperationException {
        return this.processGetDiagram(process, null);
    }

    public String processGetDocumentation(String processId, Locale locale) throws OperationException {
        try {
            ProcessAdapter adapter = this.processManager.getProcess(processId);
            return adapter.getProcess().getDocumentationMap().getString(locale);
        }
        catch (BPMException e) {
            throw new RuntimeException(e);
        }
    }

    public String instanceGetProcessId(InstanceInfo instance) {
        return instance.getProcessId();
    }

    public Object instanceGetVariable(InstanceInfo instance, String variableId) {
        return instance.getVariable(variableId);
    }

    public StringList processesGetIds(boolean onlyActiveProcess) {
        try {
            if (onlyActiveProcess) {
                return this.processManager.getActiveProcessIds();
            }
            return this.processManager.getProcessIds();
        }
        catch (Exception cause) {
            throw new OperationRuntimeException((Throwable)cause);
        }
    }

    public ProcessList processesGet(boolean onlyActiveProcess, boolean force) throws BatchOperationException {
        ProcessList processes = ProcessList.create();
        for (Process process : this.processManager.getProcesses()) {
            if (onlyActiveProcess) {
                if (!process.isActive()) continue;
                processes.add((Object)process);
                continue;
            }
            processes.add((Object)process);
        }
        return processes;
    }

    public void participantUpdateTimeZone(TimeZone timezone) throws OperationException {
        this.getBPMContext().setTimeZone(timezone);
    }

    public TimeZone participantTimeZone() throws OperationException {
        return this.getBPMContext().getTimeZone();
    }

    public VarDefinition variableGet(String variableId) {
        if (variableId.contains("[") && variableId.contains("]")) {
            for (VarDefinition variable : this.variablesGet()) {
                if (variable.isDefault() || !variable.getProcessNameAndID().equalsIgnoreCase(variableId)) continue;
                return variable;
            }
        } else {
            for (VarDefinition variable : this.variablesGet()) {
                if (!variable.getId().equalsIgnoreCase(variableId)) continue;
                return variable;
            }
        }
        return null;
    }

    public VarDefinitionList variablesGet() {
        ProcessList processes = ProcessList.create();
        try {
            processes = this.processesGet(true);
        }
        catch (BatchOperationException e) {
            processes.addAll(Arrays.asList((Process[])e.getAvailableObjects()));
        }
        VarDefinitionList variables = VarDefinitionList.create();
        for (Process process : processes) {
            VarDefinition[] processVars;
            for (VarDefinition processVar : processVars = process.getVariables()) {
                if (variables.contains((Object)processVar)) continue;
                variables.add((Object)processVar);
            }
        }
        return variables;
    }

    public View viewGet(String viewId) throws OperationException {
        return this.viewManager.getView(viewId);
    }

    public StringList viewsGetIds() throws OperationException, BatchOperationException {
        StringList viewsIds = StringList.create();
        viewsIds.addAll(this.viewManager.getViewsIds());
        return viewsIds;
    }

    public ActivityList processGetVisibleActivities(String processId) throws OperationException {
        ActivityList activities = ActivityList.create();
        Process process = this.processGet(processId);
        for (Activity activity : process.getActivities()) {
            if (!activity.hasType(0x80000D)) continue;
            activities.add((Object)activity);
        }
        return activities;
    }

    public AttachmentList processGetWorkingAttachments(String processId) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Presentation presentationCreate(PresentationType presentationType, String id, Presentation.Column[] columns) throws ViewOperationException {
        return this.presentationManager.createPresentation(presentationType, id, columns);
    }

    public EditablePresentation presentationEdit(Presentation presentation) throws ViewOperationException {
        return this.presentationManager.getEditablePresentation(presentation);
    }

    public InstanceInfo processCreateInstance(String targetProcessId, String argumentsSetName, Arguments arguments) throws OperationException {
        try {
            IInstanceManagementService service = this.getBPMServiceClient().getInstanceManagementService();
            String instanceId = service.createProcessInstance(this.getBPMContext(), targetProcessId);
            return this.processGetInstance(instanceId);
        }
        catch (BPMException e) {
            throw ExceptionHelper.wrapException(e);
        }
    }

    public InstanceInfo processCreateInstance(String targetProcessId, String argumentsSetName, Arguments arguments, String name, String description, String remarks, File file, String contentType, Locale locale, AttachmentStorageType storageType) throws OperationException, IOException {
        return this.processCreateInstance(targetProcessId, argumentsSetName, arguments);
    }

    public EditableView viewCreate(ViewType viewType, String viewId, String[] assignedProcesses) throws OperationException {
        return this.viewManager.createView(viewType, viewId, assignedProcesses);
    }

    public View viewRefresh(String viewId) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Presentation presentationRefresh(String presentationId) throws OperationException {
        this.presentationManager.refresh();
        return this.presentationManager.get(presentationId);
    }

    public GlobalExecution activityPostApplication(Activity activity, Arguments arguments) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public boolean viewHasNewInstances(String viewId) {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public boolean viewsHaveNewInstances() throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public InstanceInfo instanceRefresh(InstanceInfo instanceInfo) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public boolean equals(Object compare) {
        if (this == compare) {
            return true;
        }
        if (!(compare instanceof ProcessServiceSessionAdapter)) {
            return false;
        }
        if (this.sessionId == null) {
            return this.participantCurrent().getUid().equals(((ProcessServiceSessionAdapter)compare).getId());
        }
        return this.sessionId.equals(((ProcessServiceSessionAdapter)compare).getId());
    }

    public int hashCode() {
        if (this.sessionId == null) {
            return this.participantCurrent().getUid().hashCode();
        }
        return this.sessionId.hashCode();
    }

    public void participantEnableMailReception(boolean enableMailReception) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public boolean participantChangePasswordEnabled() throws OperationRuntimeException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instanceStoreProperty(InstanceInfo instanceInfo, String key, String value) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public String instanceRetrieveProperty(InstanceInfo instanceInfo, String key) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Map roleRetrieveProperties(String roleId, String category) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Map participantRetrieveProperties(String category) throws OperationException {
        return PropertiesHelper.getPropertiesAsMap(this, category);
    }

    public String participantRetrieveProperty(String category, String key) throws PropertyOperationException {
        try {
            Object value = this.participantRetrieveProperties(category).get(key);
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        catch (OperationException cause) {
            throw new PropertyOperationException(this.participantCurrent().getUid(), (Throwable)cause);
        }
    }

    public InstanceInfo activityExecuteApplication(Activity activity, Arguments arguments) throws OperationException {
        if (!activity.hasType(14)) {
            throw new ActivityCannotRunException(activity.getName());
        }
        return this.processCreateInstance(activity.getProcessId(), arguments);
    }

    public void processRun(String targetProcessId, String argumentsSetName, Arguments arguments, long timeout) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void processesRefresh() {
        this.processManager.refresh();
    }

    public ParticipantList participantFindByName(String name) throws OperationException {
        return OrganizationManager.searchParticipantByName(this, name);
    }

    public void processSendNotification(String targetInstanceOrProcessId, String activityName, String targetArgumentsSetName, Arguments notification, String sourceInstanceId) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesAddBookmark(InstanceActivityPairSet instanceActivityPairs) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void attachmentCheckOutToStream(Attachment attachment, OutputStream outputStream) throws OperationException {
        InputStream inputStream;
        String soaURL;
        try {
            soaURL = this.getSoaURL();
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        try {
            inputStream = WorkflowAttachmentUtil.getAttachment((IWorkflowContext)this.getBPMContext(), (String)soaURL, (String)attachment.getInstanceId(), (int)1, (String)attachment.getFileName(), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            int data;
            while ((data = inputStream.read()) != -1) {
                outputStream.write(data);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void putSessionProperty(String key, Object value) {
        this.sessionProperties.put(key, value);
    }

    public Object getSessionProperty(String key) {
        return this.sessionProperties.get(key);
    }

    public void participantStoreProperties(String category, Map<String, Object> propertiesMap) throws OperationException {
        if (propertiesMap == null) {
            throw new IllegalArgumentException("properties");
        }
        PropertiesHelper.storeProperties(this, category, propertiesMap);
    }

    public void participantStoreProperty(String category, String key, Object value) throws OperationException {
        TreeMap<String, Object> propertiesMap = new TreeMap<String, Object>();
        propertiesMap.put(key, value);
        this.participantStoreProperties(category, propertiesMap);
    }

    public void viewStore(View view) throws OperationException {
        this.viewManager.storeView(view);
    }

    public StringList processGetAllVersions(String processId) {
        ProcessIdSet processes = ProcessIdSet.create();
        try {
            processes.addAll(this.processManager.getAllVersions(processId).toArray());
        }
        catch (Exception e) {
            throw new OperationRuntimeException((Throwable)e);
        }
        return StringList.create((String[])processes.toArray());
    }

    public StringList processesGetAllVersions(ProcessIdSet processes) {
        ProcessIdSet processIds = ProcessIdSet.create();
        try {
            processIds.addAll(this.processManager.getAllVersions(processes).toArray());
        }
        catch (Exception e) {
            throw new OperationRuntimeException((Throwable)e);
        }
        return StringList.create((String[])processIds.toArray());
    }

    public StringList processesGetAllVersions(ProcessIdSet processes, StringList sessionProcesses) {
        ProcessIdSet processIds = ProcessIdSet.create();
        try {
            for (String processId : processes) {
                processIds.addAll(this.processManager.getVersions(processId, sessionProcesses).toArray());
            }
        }
        catch (BPMException e) {
            throw new RuntimeException(e);
        }
        return StringList.create((String[])processIds.toArray());
    }

    public void presentationRemove(String presentationId) throws OperationException {
        Presentation presentation = this.presentationManager.get(presentationId);
        if (presentation != null) {
            this.presentationManager.remove(presentationId);
            this.presentationManager.delete(presentationId);
        }
    }

    public void viewRemove(String viewId) throws OperationException {
        View view = this.viewManager.getView(viewId);
        if (view != null) {
            this.viewManager.removeView(viewId, true);
            this.viewManager.deleteView(viewId);
        }
    }

    public InstanceInfo activityExecute(Activity activity, InstanceInfo instance, Task taskToExecute, Arguments args) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void presentationStore(Presentation presentation) throws OperationException {
        if (presentation != null) {
            this.presentationManager.store(presentation);
        }
    }

    public final String getId() {
        return this.sessionId;
    }

    public void participantUpdatePassword(String oldPassword, String newPassword) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void instancesAddHistory(InstanceActivityPairSet instances) throws OperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public Map<String, ?> getSecureEngines() {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public ProcessServiceAdminSessionAdapter upgradeToAdminSession() throws NoPermissionException {
        try {
            return ProcessServiceAdminSessionAdapter.create(this);
        }
        catch (OperationException e) {
            throw new NoPermissionException(this.participantCurrent().getUid());
        }
    }

    public ObjectClassInstance objectClassInstanceFetchByName(String objectClass, String name) throws OperationException {
        return ObjectClassQuery.objectClassInstanceFetchByName(this, objectClass, name);
    }

    public ObjectClassInstance[] objectClassInstanceFetchByRolesAndParticipants(String objectClass, String[] roles, String[] participants) throws OperationException {
        HashSet<ObjectClassInstance> objectClassInstanceSet = new HashSet<ObjectClassInstance>();
        objectClassInstanceSet.addAll(ObjectClassQuery.findObjectClassInstanceByRole(this, objectClass, roles));
        objectClassInstanceSet.addAll(ObjectClassQuery.findObjectClassInstanceByParticipant(this, objectClass, participants));
        return objectClassInstanceSet.toArray(new ObjectClassInstance[objectClassInstanceSet.size()]);
    }

    public ObjectClassInstance[] objectClassInstanceFetchByRoles(String objectClass, String[] roles) throws OperationException {
        ArrayList<ObjectClassInstance> objectClassInstanceList = new ArrayList<ObjectClassInstance>();
        objectClassInstanceList.addAll(ObjectClassQuery.findObjectClassInstanceByRole(this, objectClass, roles));
        return objectClassInstanceList.toArray(new ObjectClassInstance[objectClassInstanceList.size()]);
    }

    public ObjectClassInstance[] objectClassInstanceFetchByParticipants(String objectClass, String[] participants) throws OperationException {
        ArrayList<ObjectClassInstance> objectClassInstanceList = new ArrayList<ObjectClassInstance>();
        objectClassInstanceList.addAll(ObjectClassQuery.findObjectClassInstanceByParticipant(this, objectClass, participants));
        return objectClassInstanceList.toArray(new ObjectClassInstance[objectClassInstanceList.size()]);
    }

    public void updateSecurityToken(String tokenType, Object token) {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public ProcessServiceAdapter getProcessService() {
        return this.processService;
    }

    public void close() {
        try {
            this.getProcessService().getBPMServiceClientFactory().getBPMUserAuthenticationService().destroyBPMContext(this.getBPMContext());
            this.getProcessManager().release();
            this.getViewManager().release();
            this.getPresentationManager().release();
            this.getProcessService().removeSession(this);
        }
        catch (BPMException e) {
            throw new OperationRuntimeException((Throwable)e);
        }
        this.isOpened = false;
    }

    public boolean refresh() {
        this.getProcessManager().refresh();
        this.getViewManager().refresh();
        this.getPresentationManager().refresh();
        return true;
    }

    public boolean refreshProcessManager() {
        this.getProcessManager().refresh();
        return true;
    }

    public boolean refreshPresentationManager() {
        this.getPresentationManager().refresh();
        return true;
    }

    public boolean refreshViewManager() {
        this.getViewManager().refresh();
        return true;
    }

    public void setId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Map<String, String> getVariableMapping(@NotNull IProcessInstance processInstance) throws OperationException {
        return this.getVariableMapping(processInstance.getProcessDN());
    }

    public Map<String, String> getVariableMapping(@NotNull String processId) throws OperationException {
        return this.getProcessManager().getVariableMapping(processId);
    }

    public IProcessInstance getProcessInstance(@NotNull String instanceId) throws OperationException {
        try {
            IInstanceQueryService queryService = this.getBPMServiceClient().getInstanceQueryService();
            IProcessInstance instance = queryService.getProcessInstance(this.getBPMContext(), instanceId);
            if (instance == null) {
                throw new InstanceNotFoundException(instanceId);
            }
            return instance;
        }
        catch (BPMException e) {
            throw ExceptionHelper.wrapException(e);
        }
    }

    public IProcessInstance getProcessInstance(@NotNull InstanceInfo instance) throws OperationException {
        return this.getProcessInstance(instance.getId());
    }

    public void executeTask(List taskIds, String action) throws OperationException {
        try {
            this.getWorkflowServiceClient().getTaskService().updateOutcomeOfTasks((IWorkflowContext)this.bpmContext, taskIds, action);
        }
        catch (Exception exc) {
            throw new OperationException((Throwable)exc);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isOpened()) {
            Log.logDebug((String)" Any Context opened should be closed at the client end, this log indicates there are some open context");
        }
    }

    protected ProcessIdSet getProcessSet(StringList processes) {
        ProcessIdSet processIdSet = ProcessIdSet.create();
        for (String process : processes) {
            processIdSet.add(process);
        }
        return processIdSet;
    }

    protected Activity getInstanceActivity(InstanceInfo instance) {
        try {
            Process process = this.processGet(instance.getProcessId());
            return process.getActivity(Activity.makeId((String)instance.getProcessId(), (String)instance.getActivityName()));
        }
        catch (OperationException e) {
            throw new OperationRuntimeException((Throwable)e);
        }
    }

    private boolean taskCanBeProcessed(oracle.bpel.services.workflow.task.model.Task task) {
        if (task != null) {
            Participant participant = this.participantCurrent();
            for (Object userObject : task.getSystemAttributes().getAssignees()) {
                IdentityType identityType = (IdentityType)userObject;
                String type = identityType.getType();
                if (type == null || !("user".equalsIgnoreCase(type) ? participant.getUid().equalsIgnoreCase(identityType.getId()) : "application_role".equalsIgnoreCase(type) && participant.hasRole(identityType.getId()))) continue;
                return true;
            }
        }
        return false;
    }

    private Predicate getInstancePredicateForTask(InstanceInfoAdapter instance, IProcessInstance bpmInstance) throws OperationException {
        try {
            Predicate instancePredicate;
            IInstanceQueryService queryService = this.getBPMServiceClient().getInstanceQueryService();
            ArrayList<Column> displayColumns = new ArrayList<Column>();
            displayColumns.add(IColumnConstants.PROCESS_ACTIVITYID_COLUMN);
            displayColumns.add(IColumnConstants.PROCESS_THREAD_COLUMN);
            displayColumns.add(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN);
            List parallelInstances = queryService.queryParallelInstances(this.getBPMContext(), bpmInstance, displayColumns);
            if (parallelInstances == null || parallelInstances.size() == 0) {
                instancePredicate = new Predicate(TableConstants.WFTASK_INSTANCEID_COLUMN, 0, (Object)instance.getCubeInstanceId());
                instancePredicate.addClause(7, TableConstants.WFTASK_ACTIVITYID_COLUMN, 0, (Object)instance.getUnqualifiedActivityName());
                instancePredicate.addClause(7, TableConstants.WFTASK_THREAD_COLUMN, 0, (Object)instance.getThreadIn());
                instancePredicate.addClause(7, TableConstants.WFTASK_PARENTTHREAD_COLUMN, 0, (Object)instance.getParentThreadIn());
                instancePredicate.addClause(7, TableConstants.WFTASK_STATE_COLUMN, 1, (Object)"WITHDRAWN");
            } else {
                instancePredicate = new Predicate(TableConstants.WFTASK_INSTANCEID_COLUMN, 0, (Object)instance.getCubeInstanceId());
                Predicate paralleActivitiesPredicate = null;
                for (IProcessInstance processInstance : parallelInstances) {
                    Predicate paralleActivityPredicate = new Predicate(TableConstants.WFTASK_ACTIVITYID_COLUMN, 0, (Object)instance.getUnqualifiedActivityName());
                    paralleActivityPredicate.addClause(7, TableConstants.WFTASK_THREAD_COLUMN, 0, (Object)instance.getThreadIn());
                    paralleActivityPredicate.addClause(7, TableConstants.WFTASK_PARENTTHREAD_COLUMN, 0, (Object)instance.getParentThreadIn());
                    paralleActivityPredicate.addClause(7, TableConstants.WFTASK_STATE_COLUMN, 1, (Object)"WITHDRAWN");
                    if (paralleActivitiesPredicate == null) {
                        paralleActivitiesPredicate = paralleActivityPredicate;
                        continue;
                    }
                    paralleActivitiesPredicate = new Predicate(paralleActivitiesPredicate, 8, paralleActivityPredicate);
                }
                if (paralleActivitiesPredicate != null) {
                    instancePredicate = new Predicate(instancePredicate, 7, paralleActivitiesPredicate);
                }
            }
            return instancePredicate;
        }
        catch (BPMException exc) {
            throw ExceptionHelper.wrapException(exc);
        }
        catch (WorkflowException exc) {
            throw ExceptionHelper.wrapException(exc);
        }
    }

    private void instanceGetTask(InstanceInfoAdapter instance, IProcessInstance bpmInstance) throws OperationException {
        if (!this.isInstancePendingMigration(bpmInstance)) {
            ITaskQueryService queryService = this.getWorkflowServiceClient().getTaskQueryService();
            List tasks = null;
            try {
                ArrayList<ITaskQueryService.OptionalInfo> optionalInfo = new ArrayList<ITaskQueryService.OptionalInfo>();
                optionalInfo.add(ITaskQueryService.OptionalInfo.CUSTOM_ACTIONS);
                Predicate predicate = this.getInstancePredicateForTask(instance, bpmInstance);
                oracle.bpel.services.workflow.repos.Ordering ordering = new oracle.bpel.services.workflow.repos.Ordering(TableConstants.WFTASK_INSTANCEID_COLUMN, true, true);
                ArrayList<String> displayColumns = new ArrayList<String>();
                displayColumns.add("instanceId");
                displayColumns.add("priority");
                displayColumns.add("dueDate");
                displayColumns.add("taskNumber");
                displayColumns.add("state");
                displayColumns.add("outcome");
                displayColumns.add("dueDate");
                displayColumns.add("updatedByDisplayName");
                displayColumns.add("updatedBy");
                displayColumns.add("updatedDate");
                displayColumns.add("participantName");
                displayColumns.add("title");
                displayColumns.add("assignees");
                displayColumns.add("assigneesDisplayName");
                displayColumns.add("outcome");
                displayColumns.add("parentTaskId");
                displayColumns.add("parentTaskVersion");
                displayColumns.add("taskDefinitionId");
                displayColumns.add("taskNamespace");
                displayColumns.add("compositeVersion");
                displayColumns.add("applicationName");
                tasks = queryService.queryTasks((IWorkflowContext)this.getBPMContext(), displayColumns, optionalInfo, ITaskQueryService.AssignmentFilter.MY_AND_GROUP, null, predicate, ordering, 0, 0);
                if (tasks == null || tasks.isEmpty()) {
                    ITaskQueryService.AssignmentFilter assignmentFilter = this.getBPMContext().getIsAdmin() ? ITaskQueryService.AssignmentFilter.ADMIN : ITaskQueryService.AssignmentFilter.OWNER;
                    tasks = queryService.queryTasks((IWorkflowContext)this.getBPMContext(), displayColumns, optionalInfo, assignmentFilter, null, predicate, ordering, 0, 0);
                }
            }
            catch (WorkflowException loggedException) {
                BPMLogger.log((Throwable)loggedException);
            }
            if (tasks != null && !tasks.isEmpty()) {
                instance.setTaskInfo(tasks);
            }
        }
    }

    private boolean isInstancePendingMigration(IProcessInstance bpmInstance) {
        String state = bpmInstance.getSystemAttributes().getState();
        return "PENDING_MIGRATION".equals(state) || "PENDING_MIGRATION_SUSPENDED".equals(state);
    }

    private boolean isInstancePendingMigration(InstanceInfo instanceInfo) {
        return instanceInfo.getStatus() == 8;
    }

    private String getSoaURL() throws WorkflowException {
        IRuntimeConfigService configService = this.getProcessService().getBPMServiceClientFactory().getWorkflowServiceClient().getRuntimeConfigService();
        return configService.getInternalServerURL();
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            String _schemaId = (String)stream.readObject();
            String _sessionId = (String)stream.readObject();
            WorkflowContext _bpmContext = (WorkflowContext)stream.readObject();
            ConnectionPassportAdapter _passport = (ConnectionPassportAdapter)stream.readObject();
            String _host = (String)stream.readObject();
            HashMap _properties = (HashMap)stream.readObject();
            ProcessServiceAdapter processService = ProcessServiceCache.get(_schemaId);
            if (processService == null) {
                Log.logDebug((String)("ProcessServiceSessionAdapter.readObject Process Service NOT found in ProcessServiceCache creating a new one for schema " + _schemaId));
                processService = (ProcessServiceAdapter)this.createProcessService();
            }
            this.processService = processService;
            this.currentPassport = _passport;
            this.currentHost = _host;
            this.bpmContext = _bpmContext;
            this.bpmServiceClient = processService.getBPMServiceClientFactory().getBPMServiceClient();
            this.wfServiceClient = processService.getBPMServiceClientFactory().getWorkflowServiceClient();
            this.processManager = SessionProcessManager.create(this);
            this.viewManager = new SessionViewManager(this);
            this.presentationManager = new SessionPresentationManager(this);
            this.sessionId = _sessionId;
            this.sessionProperties = _properties;
            this.isOpened = true;
            processService.addSession(this);
        }
        catch (ClassNotFoundException exception) {
            throw (IOException)new IOException().initCause(exception);
        }
    }

    private ProcessService createProcessService() {
        ProcessService processService;
        Properties props = new Properties();
        props.setProperty("fuego.papi.factory", "oracle.bpm.papi.ora.ProcessServiceAdapterFactory");
        props.setProperty("oracle.bpm.services.soa", "true");
        try {
            processService = ProcessService.create((Properties)props);
        }
        catch (CommunicationException e) {
            throw new RuntimeException("PAPI Communication Error. \nHint:Possibly the server is unavailable, a network problem exists or there is no service at the specified location.\n" + ExceptionFormatter.fullTechLevel((Throwable)e));
        }
        if (processService == null) {
            throw new RuntimeException("PAPI cannot create ProcessService!");
        }
        return processService;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.processService.getId());
        stream.writeObject(this.sessionId);
        stream.writeObject(this.bpmContext);
        stream.writeObject(this.currentPassport);
        stream.writeObject(this.currentHost);
        stream.writeObject(this.sessionProperties);
    }
}

