/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.ObjectClassInstance;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceAdminSession;
import java.util.List;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.papi.ora.ConnectionPassportAdapter;
import oracle.bpm.papi.ora.Constants;
import oracle.bpm.papi.ora.ProcessServiceAdapter;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.PrincipleRefTypeFactory;
import oracle.bpm.papi.ora.layout.ObjectClassInstanceAdapter;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.processdashboard.IProcessDashboardService;
import oracle.bpm.services.processdashboard.model.PrincipleRef;
import oracle.bpm.services.processdashboard.model.WidgetView;
import oracle.bpm.services.processdashboard.model.impl.PrincipleRefImpl;

public class ProcessServiceAdminSessionAdapter
extends ProcessServiceSessionAdapter
implements ProcessServiceAdminSession {
    private static final long serialVersionUID = 20090813133900L;

    private ProcessServiceAdminSessionAdapter(ProcessServiceAdapter service, ConnectionPassportAdapter passport, String host, IBPMContext context) throws OperationException {
        super(service, passport, host, context);
    }

    public static ProcessServiceAdminSessionAdapter create(ProcessServiceSessionAdapter session) throws OperationException {
        return new ProcessServiceAdminSessionAdapter(session.getProcessService(), session.getPassport(), session.participantHost(), session.getBPMContext());
    }

    @Override
    public boolean isAdministrator() {
        return true;
    }

    public ObjectClassInstance objectClassInstanceCreate(String name, String objectClass, String[] assignedRoles, String[] assignedParticipants, String instanceXml) throws OperationException {
        try {
            ObjectClassInstanceAdapter objectClassInstanceAdapter = ObjectClassInstanceAdapter.createObjectClassInstance(name, objectClass, assignedRoles, assignedParticipants, instanceXml);
            UserApplicationDataType applicationData = this.getWorkflowServiceClient().getUserMetadataService().createUserApplicationData((IWorkflowContext)this.getBPMContext(), objectClassInstanceAdapter.getUserApplicationData());
            objectClassInstanceAdapter.setUserApplicationData(applicationData);
            return objectClassInstanceAdapter;
        }
        catch (JAXBException e) {
            throw new OperationException((Throwable)e);
        }
        catch (WorkflowException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void objectClassInstanceUpdate(ObjectClassInstance instance) throws OperationException {
        IUserMetadataService userMetadataService = this.getWorkflowServiceClient().getUserMetadataService();
        try {
            userMetadataService.updateUserApplicationData((IWorkflowContext)this.getBPMContext(), ((ObjectClassInstanceAdapter)instance).getUserApplicationData());
        }
        catch (WorkflowException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void objectClassInstanceDelete(ObjectClassInstance instance) throws OperationException {
        IUserMetadataService userMetadataService = this.getWorkflowServiceClient().getUserMetadataService();
        try {
            userMetadataService.deleteUserApplicationData((IWorkflowContext)this.getBPMContext(), ((ObjectClassInstanceAdapter)instance).getUserApplicationData().getId());
        }
        catch (WorkflowException e) {
            throw new OperationException((Throwable)e);
        }
    }

    public void grantPermissionToWidget(String widgetId, List<String> roles) throws OperationException {
        IProcessDashboardService dbService = this.getBPMServiceClient().getProcessDashboardService();
        try {
            WidgetView widget = dbService.getWidgetView(this.getBPMContext(), widgetId);
            if (widget != null) {
                for (String role : roles) {
                    List grantees = widget.getGrantees();
                    boolean exists = false;
                    if (grantees != null) {
                        for (PrincipleRef grantee : grantees) {
                            if (!role.equals(grantee.getName())) continue;
                            exists = true;
                            break;
                        }
                    }
                    if (exists) continue;
                    PrincipleRefImpl principle = PrincipleRefImpl.create((PrincipleRefType)PrincipleRefTypeFactory.createPrincipleRefAppRole(role));
                    principle.setRealm(Constants.DEFAULT_APPLICATION);
                    widget.addGrantee((PrincipleRef)principle);
                }
                dbService.updateWidgetView(this.getBPMContext(), widget);
            }
        }
        catch (BPMException ex) {
            throw new OperationException((Throwable)ex);
        }
    }
}

