/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.CommunicationException;
import fuego.papi.Filter;
import fuego.papi.ProcessService;
import java.util.Properties;
import oracle.bpm.lang.ConnectionPassport;
import oracle.bpm.log.Log;
import oracle.bpm.papi.ora.ConnectionPassportAdapter;
import oracle.bpm.papi.ora.ProcessServiceAdapter;
import oracle.bpm.papi.ora.ProcessServiceCache;
import oracle.bpm.papi.ora.view.FilterAdapter;

public class ProcessServiceAdapterFactory
implements ProcessService.Factory {
    public ProcessService create(Properties properties) throws CommunicationException {
        ConnectionPassportAdapter passport = ConnectionPassportAdapter.create("OBPI");
        return this.getOrCreateProcessService("OBPI", passport, properties);
    }

    public ProcessService create(ConnectionPassport passport, Properties properties) throws CommunicationException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Filter createFilter() {
        return FilterAdapter.create();
    }

    public void updateOrgInfo() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessServiceAdapter getOrCreateProcessService(String schemaId, ConnectionPassport passport, Properties properties) throws CommunicationException {
        ProcessServiceAdapter processService = ProcessServiceCache.get(schemaId);
        if (processService == null) {
            ProcessServiceAdapterFactory processServiceAdapterFactory = this;
            synchronized (processServiceAdapterFactory) {
                processService = ProcessServiceCache.get(schemaId);
                if (processService == null) {
                    Log.logDebug((String)"Creating and adding ProcessService to cache.");
                    processService = new ProcessServiceAdapter(passport, properties);
                    ProcessServiceCache.put(processService.getId(), processService);
                }
            }
        }
        return processService;
    }
}

