/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.CommunicationException;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.AuthenticationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.lang.ConnectionPassport;
import oracle.bpm.papi.ora.ConnectionPassportAdapter;
import oracle.bpm.papi.ora.ProcessServiceCache;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.UnsupportedServiceAdapter;
import oracle.bpm.papi.ora.mgr.SessionManager;
import oracle.bpm.papi.ora.mgr.SessionProcessManager;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.tip.pc.services.identity.BPMIdentityService;

public class ProcessServiceAdapter
extends UnsupportedServiceAdapter {
    private BPMIdentityService bpmIdentityService;
    private BPMServiceClientFactory bpmServiceClientFactory;
    private volatile boolean isOpened = true;
    private Properties properties = new Properties();
    private String serviceId;
    private SessionManager sessionManager;
    private static final Object lock = new Object();

    ProcessServiceAdapter(ConnectionPassport passport, Properties properties) throws CommunicationException {
        this.properties.putAll((Map<?, ?>)properties);
        this.serviceId = passport.getId();
        this.sessionManager = new SessionManager();
        this.initBPMServiceClientFactory(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isOpened) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (!this.isOpened) {
                return;
            }
            ProcessServiceSessionAdapter[] sessions = this.sessionManager.getSessions();
            for (int i = 0; i < sessions.length && sessions[i] != null; ++i) {
                if (sessions[i] == null) continue;
                sessions[i].close();
            }
            this.sessionManager.release();
            SessionProcessManager.cleanStaticCaches();
            ProcessServiceCache.remove(this.getId());
            this.isOpened = false;
        }
    }

    public boolean isOpen() {
        return this.isOpened;
    }

    public ConnectionPassport createPassport(String participant) {
        return ConnectionPassportAdapter.create("OBPI", this.createParticipantCredentials(participant, new char[0], null));
    }

    public ProcessServiceSession createSession(ConnectionPassport passport, String host) throws OperationException {
        IBPMContext bpmContext;
        ConnectionPassportAdapter passportAdapter = (ConnectionPassportAdapter)passport;
        String userId = passportAdapter.getParticipantCredentials().getParticipant();
        char[] password = passportAdapter.getParticipantCredentials().getPassword();
        try {
            Object skipAuthObj = passport.getProperty("oracle.obpi.skipauth");
            Object bpmContextObj = passport.getProperty("oracle.obpi.context");
            bpmContext = skipAuthObj != null && Boolean.valueOf(skipAuthObj.toString()).booleanValue() ? (bpmContextObj != null && bpmContextObj instanceof IBPMContext ? (IBPMContext)bpmContextObj : this.bpmServiceClientFactory.getBPMUserAuthenticationService().getBPMContextForAuthenticatedUser()) : this.bpmServiceClientFactory.getBPMUserAuthenticationService().authenticate(userId, password, null);
        }
        catch (BPMException e) {
            throw new AuthenticationException((Throwable)e);
        }
        ProcessServiceSessionAdapter session = new ProcessServiceSessionAdapter(this, passportAdapter, host, bpmContext);
        this.sessionManager.add(session);
        return session;
    }

    public ProcessServiceSession createSession(String userId, String password, String host) throws OperationException {
        ConnectionPassport connectionPassport = this.createPassport(userId);
        connectionPassport.setPassword(password);
        return this.createSession(connectionPassport, host);
    }

    public Properties getProperties() {
        Properties cloneProperties = new Properties();
        cloneProperties.putAll((Map<?, ?>)this.properties);
        return cloneProperties;
    }

    public String getProperty(String propertyKey) {
        return this.properties.getProperty(propertyKey);
    }

    public String getId() {
        return this.serviceId;
    }

    public String toString() {
        return this.getId() + " Process Service";
    }

    public BPMServiceClientFactory getBPMServiceClientFactory() {
        if (this.bpmServiceClientFactory == null) {
            throw new IllegalStateException("BPMServiceClientFactory not initialized.");
        }
        return this.bpmServiceClientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BPMIdentityService getBPMIdentityService() {
        if (this.bpmIdentityService == null) {
            Object object = lock;
            synchronized (object) {
                if (this.bpmIdentityService == null && this.isOpen()) {
                    this.initBPMIdentityService(this.properties);
                }
            }
        }
        return this.bpmIdentityService;
    }

    public void addSession(ProcessServiceSessionAdapter session) {
        this.sessionManager.add(session);
    }

    public void removeSession(ProcessServiceSessionAdapter session) {
        this.sessionManager.remove(session);
    }

    private void initBPMServiceClientFactory(Properties properties) {
        String soa = properties.getProperty("oracle.bpm.services.soa", Boolean.FALSE.toString());
        String initialContextFactory = properties.getProperty("oracle.obpi.contextfactory", "weblogic.jndi.WLInitialContextFactory");
        String host = properties.getProperty("oracle.obpi.host", null);
        int port = Integer.parseInt(properties.getProperty("oracle.obpi.port", "7001"));
        String ejbProviderURL = properties.getProperty("oracle.obpi.ejbproviderurl", "t3://" + host + ":" + port);
        String clientType = properties.getProperty("oracle.bpm.services.client", "REMOTE");
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> _properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, clientType);
        if (Boolean.valueOf(soa).booleanValue()) {
            if (host != null) {
                _properties = new HashMap();
                _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, ejbProviderURL);
            }
        } else {
            if (host == null) {
                host = "localhost";
            }
            _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, ejbProviderURL);
            _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_INITIAL_CONTEXT_FACTORY, initialContextFactory);
        }
        this.bpmServiceClientFactory = BPMServiceClientFactory.getInstance(_properties, null, null);
    }

    private void initBPMIdentityService(Properties properties) {
        String serverURL = null;
        String host = properties.getProperty("oracle.obpi.identity.host", null);
        int port = Integer.parseInt(properties.getProperty("oracle.obpi.identity.port", String.valueOf("7001")));
        if (host != null) {
            serverURL = "http://" + host + ":" + port;
        } else {
            try {
                IRuntimeConfigService configService = this.getBPMServiceClientFactory().getWorkflowServiceClient().getRuntimeConfigService();
                serverURL = configService.getInternalServerURL();
            }
            catch (Throwable exception) {
                BPMLogger.log((Throwable)exception);
            }
        }
        if (serverURL == null) {
            String obpiHost = properties.getProperty("oracle.obpi.host", "localhost");
            int obpiPort = Integer.parseInt(properties.getProperty("oracle.obpi.port", "7001"));
            serverURL = "http://" + obpiHost + ":" + obpiPort;
        }
        String realm = properties.getProperty("oracle.obpi.realm", null);
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> _properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "SOAP");
        _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, serverURL);
        this.bpmIdentityService = WorkflowServiceClientFactory.getSOAPIdentityServiceClient((String)realm, _properties, null);
    }

    private ConnectionPassportAdapter.ParticipantCredentials createParticipantCredentials(String participant, char[] password, String realm) {
        return ConnectionPassportAdapter.ParticipantCredentials.create(participant, password, realm);
    }
}

