/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.InstanceEvent;
import fuego.papi.ProcessDiagram;
import fuego.papi.collections.InstanceEventList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.diagram.AuditProcessDiagrammer;
import oracle.bpm.draw.diagram.DiagramEvent;
import oracle.bpm.draw.diagram.ProcessDiagrammer;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.papi.ora.InstanceEventAdapter;
import oracle.bpm.papi.ora.metadata.AdapterUtils;
import oracle.bpm.papi.ora.metadata.ProcessAdapter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import org.jetbrains.annotations.NotNull;

public class ProcessDiagramAdapter
implements ProcessDiagram {
    private Map<String, AuditProcessDiagrammer> diagrammers = new HashMap<String, AuditProcessDiagrammer>();
    private AuditProcessDiagrammer mainProcessDiagrammer;
    private final ProcessAdapter papiProcess;

    public ProcessDiagramAdapter(@NotNull ProcessAdapter process) {
        this.papiProcess = process;
        this.mainProcessDiagrammer = new AuditProcessDiagrammer(this.papiProcess.getProcess());
        this.diagrammers.put(this.papiProcess.getProcess().getId(), this.mainProcessDiagrammer);
        for (Process callee : this.papiProcess.getCallees()) {
            this.diagrammers.put(callee.getId(), new AuditProcessDiagrammer(callee));
        }
    }

    public String getIconForActivity(@NotNull String activityId) {
        AdapterUtils.ActivityId id = AdapterUtils.ActivityId.parseActivityId(activityId);
        return this.diagrammers.get(id.getProcessName()).getIconForFlowElement(id.getUnqualifiedActivityName());
    }

    public String getImage() {
        return this.getMainProcessDiagrammer().getImage();
    }

    public String getImageForActivity(@NotNull String activityId) {
        AdapterUtils.ActivityId id = AdapterUtils.ActivityId.parseActivityId(activityId);
        return this.diagrammers.get(id.getProcessName()).getImageForFlowElement(id.getUnqualifiedActivityName());
    }

    public void setLocale(Locale locale) {
        for (AuditProcessDiagrammer processDiagrammer : this.diagrammers.values()) {
            processDiagrammer.setLocale(locale);
        }
    }

    public Rectangle getRectangleForActivity(String activityId) {
        AdapterUtils.ActivityId id = AdapterUtils.ActivityId.parseActivityId(activityId);
        return this.diagrammers.get(id.getProcessName()).getBoundsForFlowElement(id.getUnqualifiedActivityName());
    }

    public void setScale(float scale) {
        for (AuditProcessDiagrammer processDiagrammer : this.diagrammers.values()) {
            processDiagrammer.setScale(scale);
        }
    }

    public void highlightActivityPath(@NotNull String[] activityIds) {
        throw new UnsupportedOperationException("Operation not supported in 11g");
    }

    public void highlightActivityPath(InstanceEventList instanceEvents) {
        HashMap graphicalEventsPerProcess = new HashMap();
        for (InstanceEvent instanceEvent : instanceEvents) {
            if (!InstanceEventAdapter.class.isInstance(instanceEvent)) {
                throw new IllegalArgumentException("Illegal InstanceEvents type!");
            }
            IAuditInstance auditInstance = ((InstanceEventAdapter)instanceEvent).getAuditInstance();
            ArrayList<DiagramEvent> graphicalEvents = (ArrayList<DiagramEvent>)graphicalEventsPerProcess.get(auditInstance.getProcessName());
            if (graphicalEvents == null) {
                graphicalEvents = new ArrayList<DiagramEvent>();
                graphicalEventsPerProcess.put(auditInstance.getProcessName(), graphicalEvents);
            }
            Process processModel = this.diagrammers.get(auditInstance.getProcessName()).getProcess();
            for (DiagramEvent dEvent : this.getHighlightEvents(processModel, auditInstance)) {
                if (graphicalEvents.contains(dEvent)) continue;
                graphicalEvents.add(dEvent);
            }
        }
        for (Map.Entry entry : graphicalEventsPerProcess.entrySet()) {
            List events = (List)entry.getValue();
            String processName = (String)entry.getKey();
            this.diagrammers.get(processName).highlight((Iterable)events);
        }
    }

    public void showIconInActivity(String activityId, String path) {
        throw new UnsupportedOperationException();
    }

    public void showTextInActivity(String activityId, String text) {
        throw new UnsupportedOperationException();
    }

    public void setHeadless(boolean isHeadless) {
        throw new UnsupportedOperationException();
    }

    public void setDrawFlowOnly(boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setHorizontalDrawing(boolean isHorizontalDrawing) {
        throw new UnsupportedOperationException();
    }

    public String getRelativePathForActivityIconImage(String activityId) {
        throw new UnsupportedOperationException();
    }

    public String getRelativePathForActivityImage(String activityId) {
        throw new UnsupportedOperationException();
    }

    public void setTheme(String themeName) {
        throw new UnsupportedOperationException();
    }

    public void setTransitionMessageType(String type) {
        throw new UnsupportedOperationException();
    }

    private ProcessDiagrammer getMainProcessDiagrammer() {
        return this.mainProcessDiagrammer;
    }

    private List<DiagramEvent> getHighlightEvents(@NotNull Process processModel, @NotNull IAuditInstance auditInstance) {
        ArrayList<DiagramEvent> events;
        block6: {
            FlowNode flowNode;
            boolean cancelled;
            Date eventDate;
            block5: {
                events = new ArrayList<DiagramEvent>();
                String activityId = auditInstance.getActivityId();
                eventDate = auditInstance.getCreateTime().getTime();
                cancelled = auditInstance.getOperation() == AuditInstanceOperation.FLOW_NODE_CANCELLED;
                DiagramEvent nodeEvent = DiagramEvent.create((DiagramEvent.DiagramEventType)DiagramEvent.DiagramEventType.FLOW_NODE_IN, (String)activityId, (Date)eventDate, (boolean)cancelled);
                events.add(nodeEvent);
                if (!auditInstance.getAuditInstanceType().equalsIgnoreCase("START")) break block5;
                FlowNode flowNode2 = (FlowNode)processModel.findDescendant(FlowNode.class, auditInstance.getActivityId());
                if (flowNode2 == null) break block6;
                String sourceActivity = auditInstance.getSourceActivity();
                Sequence incommingSequenceFlows = flowNode2.getIncomingSequenceFlows();
                if (incommingSequenceFlows != null && !incommingSequenceFlows.isEmpty() && sourceActivity != null) {
                    for (SequenceFlow sequenceFlow : incommingSequenceFlows) {
                        if (!sequenceFlow.getSource().getId().equalsIgnoreCase(sourceActivity)) continue;
                        DiagramEvent sequenceEvent = DiagramEvent.create((DiagramEvent.DiagramEventType)DiagramEvent.DiagramEventType.SEQUENCE_FLOW, (String)sequenceFlow.getId(), (Date)eventDate, (boolean)cancelled);
                        events.add(sequenceEvent);
                    }
                }
                break block6;
            }
            if (auditInstance.getAuditInstanceType().equalsIgnoreCase("END") && (flowNode = (FlowNode)processModel.findDescendant(FlowNode.class, auditInstance.getActivityId())) != null) {
                String targetActivity = auditInstance.getTargetActivity();
                Sequence outgoingSequenceFlows = flowNode.getOutgoingSequenceFlows();
                if (outgoingSequenceFlows != null && !outgoingSequenceFlows.isEmpty() && auditInstance.getOperation() != AuditInstanceOperation.FLOW_NODE_CANCELLED && targetActivity != null) {
                    for (SequenceFlow sequenceFlow : outgoingSequenceFlows) {
                        if (!sequenceFlow.getTarget().getId().equalsIgnoreCase(targetActivity)) continue;
                        DiagramEvent sequenceEvent = DiagramEvent.create((DiagramEvent.DiagramEventType)DiagramEvent.DiagramEventType.SEQUENCE_FLOW, (String)sequenceFlow.getId(), (Date)eventDate, (boolean)cancelled);
                        events.add(sequenceEvent);
                    }
                }
            }
        }
        return events;
    }

    private boolean contains(String[] activityIds, String id) {
        for (String activityId : activityIds) {
            if (!activityId.equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }
}

