/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.Note;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.InstanceInfoAdapter;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.services.instancemanagement.model.IProcessComment;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import org.jetbrains.annotations.NotNull;

public class NoteAdapter
implements Note {
    private String activityName;
    private Object content;
    private Time creationTime;
    private String instanceId;
    private int instanceIn;
    private String participant;
    private String processId;
    private int processIn;

    private NoteAdapter() {
    }

    public static List<NoteAdapter> create(@NotNull ProcessServiceSessionAdapter session, @NotNull IProcessInstance processInstance) {
        ArrayList<NoteAdapter> result = new ArrayList<NoteAdapter>();
        for (Object object : processInstance.getUserComment()) {
            IProcessComment comment = (IProcessComment)object;
            result.add(NoteAdapter.create(session, processInstance, comment));
        }
        return result;
    }

    public static NoteAdapter create(@NotNull ProcessServiceSessionAdapter session, @NotNull IProcessInstance processInstance, @NotNull IProcessComment iProcessComment) {
        InstanceInfoAdapter instanceInfo;
        NoteAdapter noteAdapter = new NoteAdapter();
        noteAdapter.content = iProcessComment.getComment();
        noteAdapter.creationTime = Time.valueOf((Calendar)iProcessComment.getUpdatedDate());
        noteAdapter.participant = iProcessComment.getUpdatedBy().getDisplayName();
        if (noteAdapter.participant == null || noteAdapter.participant.equals("")) {
            noteAdapter.participant = iProcessComment.getUpdatedBy().getId();
        }
        try {
            instanceInfo = InstanceInfoAdapter.create(session, processInstance);
        }
        catch (OperationException e) {
            throw new OperationRuntimeException((Throwable)e);
        }
        noteAdapter.activityName = instanceInfo.getActivityName();
        noteAdapter.instanceId = instanceInfo.getId();
        noteAdapter.instanceIn = instanceInfo.getInstanceIn();
        noteAdapter.processId = instanceInfo.getProcessId();
        noteAdapter.processIn = instanceInfo.getProcessIn();
        return noteAdapter;
    }

    public Object getContent() {
        return this.content;
    }

    public Time getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public int getIn() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getInstanceIn() {
        return this.instanceIn;
    }

    @Deprecated
    public String getName() {
        return this.activityName;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getParticipant() {
        return this.participant;
    }

    @Deprecated
    public int getProcessIn() {
        return this.processIn;
    }

    public String getProcessId() {
        return this.processId;
    }
}

