/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.InstanceInfo;
import fuego.papi.Ordering;
import fuego.papi.exception.InvalidVariableIdException;
import java.util.Comparator;
import java.util.Locale;
import oracle.bpm.lang.Void;

public class InstanceInfoComparator
implements Comparator<InstanceInfo> {
    public Ordering criteria;
    private Locale locale;

    public InstanceInfoComparator() {
        this(null, Locale.getDefault());
    }

    public InstanceInfoComparator(Ordering criteria, Locale locale) {
        this.locale = locale;
        if (criteria == null || criteria.getEntryCount() < 1) {
            this.criteria = new Ordering();
            this.criteria.add("PREDEFINE_RECEIVED TIME", true);
            this.criteria.add("PREDEFINE_PRIORITY", true);
            this.criteria.add("PREDEFINE_ACTIVITY", true);
            this.criteria.add("PREDEFINE_DESCRIPTION", true);
        } else {
            this.criteria = criteria;
        }
    }

    @Override
    public int compare(InstanceInfo instanceLeft, InstanceInfo instanceRight) {
        if (instanceLeft.getProcessIn() == instanceRight.getProcessIn() && instanceLeft.getInstanceIn() == instanceRight.getInstanceIn() && instanceLeft.getThreadIn() == instanceRight.getThreadIn()) {
            return 0;
        }
        for (int i = 0; i < this.criteria.getEntryCount(); ++i) {
            Ordering.Entry entry = this.criteria.getEntry(i);
            int factor = entry.isAscending() ? 1 : -1;
            Object varLeft = null;
            try {
                varLeft = instanceLeft.getExternalVariable(entry.getVariableId(), this.locale);
            }
            catch (InvalidVariableIdException ignore) {
                // empty catch block
            }
            Object varRight = null;
            try {
                varRight = instanceRight.getExternalVariable(entry.getVariableId(), this.locale);
            }
            catch (InvalidVariableIdException ignore) {
                // empty catch block
            }
            if (varLeft != null && varRight == null) {
                return -1 * factor;
            }
            if (varLeft == null && varRight != null) {
                return factor;
            }
            if (varLeft == null) continue;
            int compareValue = 0;
            if (varLeft instanceof String && varRight instanceof String) {
                String stringLeft = (String)varLeft;
                String stringRight = (String)varRight;
                compareValue = stringLeft.compareToIgnoreCase(stringRight) * factor;
            } else if (varLeft instanceof Boolean && varRight instanceof Boolean) {
                boolean boolLeft = (Boolean)varLeft;
                boolean boolRight = (Boolean)varRight;
                if (boolLeft && !boolRight) {
                    compareValue = -1 * factor;
                } else if (!boolLeft && boolRight) {
                    compareValue = factor;
                }
            } else if (varLeft instanceof Number && varRight instanceof Number) {
                Number leftNum = (Number)varLeft;
                Number rightNum = (Number)varRight;
                Double leftDouble = leftNum.doubleValue();
                compareValue = leftDouble.compareTo(rightNum.doubleValue()) * factor;
            } else if (varLeft instanceof Void || varRight instanceof Void) {
                if (!(varRight instanceof Void)) {
                    compareValue = factor;
                } else if (!(varLeft instanceof Void)) {
                    compareValue = -1 * factor;
                }
            } else {
                assert (varLeft instanceof Comparable) : "The Instance Variable must be Comparable";
                compareValue = this.compareAny(varLeft, varRight, factor);
            }
            if (compareValue == 0) continue;
            return compareValue;
        }
        return instanceLeft.compareTo((Object)instanceRight);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InstanceInfoComparator) {
            InstanceInfoComparator compare = (InstanceInfoComparator)obj;
            if (this.criteria.getEntryCount() != compare.criteria.getEntryCount()) {
                return false;
            }
            if (this.criteria == compare.criteria) {
                return true;
            }
            for (int i = 0; i < this.criteria.getEntryCount(); ++i) {
                Ordering.Entry entryLeft = this.criteria.getEntry(i);
                Ordering.Entry entryRight = compare.criteria.getEntry(i);
                if (entryLeft.getVariableId().equals(entryRight.getVariableId()) && entryLeft.isAscending() == entryRight.isAscending()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.criteria.hashCode();
    }

    private int compareAny(Object varLeft, Object varRight, int factor) {
        Comparable comparable = (Comparable)varLeft;
        return factor * comparable.compareTo(varRight);
    }
}

