/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.ProcessInstanceState;
import fuego.papi.Task;
import fuego.papi.VarDefinition;
import fuego.papi.collections.InstanceActivityPair;
import fuego.papi.exception.InvalidTaskNumberException;
import fuego.papi.exception.InvalidVariableIdException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpel.services.workflow.task.model.ActionType;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.Void;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.PriorityHelper;
import oracle.bpm.papi.ora.helper.ProcessInstanceStateHelper;
import oracle.bpm.papi.ora.metadata.ActivityTypeHelper;
import oracle.bpm.papi.ora.metadata.AdapterUtils;
import oracle.bpm.papi.ora.util.VariableProcessInstanceUtils;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import org.jetbrains.annotations.NotNull;

public class InstanceInfoAdapter
extends InstanceInfo {
    private AdapterUtils.ActivityId activityId;
    private BpmnType bpmnType;
    private int bpmPriority;
    private String bpmState;
    private Calendar createdDate;
    private String cubeInstanceId;
    private String description;
    private boolean hasAttachments;
    private boolean hasNotes;
    private String instanceId;
    private int mainThreadRealState;
    private int papiState;
    private int parentThread;
    private String participantDisplayName = null;
    private Calendar processDueDate;
    private String processId;
    private String processLabel;
    private List<oracle.bpel.services.workflow.task.model.Task> task;
    private Map<String, Serializable> variables;
    private static final long serialVersionUID = -7376533895511819057L;

    public InstanceInfoAdapter() {
        this.variables = new TreeMap<String, Serializable>();
    }

    private InstanceInfoAdapter(@NotNull IProcessInstance processInstance, @NotNull Map<String, String> variableMapping) {
        this.initiate(processInstance);
        this.variables = new TreeMap<String, Serializable>();
        for (Map.Entry<String, String> entry : variableMapping.entrySet()) {
            try {
                Object variableValue = VariableProcessInstanceUtils.getValue(processInstance, entry.getValue());
                this.variables.put(entry.getKey(), (Serializable)variableValue);
            }
            catch (OperationException cause) {
                this.variables.put(entry.getKey(), null);
            }
        }
    }

    public static InstanceInfoAdapter create(@NotNull ProcessServiceSessionAdapter session, @NotNull IProcessInstance processInstance) throws OperationException {
        Map<String, String> variableMapping = session.getVariableMapping(processInstance.getProcessDN());
        return new InstanceInfoAdapter(processInstance, variableMapping);
    }

    public final String getCubeInstanceId() {
        return this.cubeInstanceId;
    }

    public final boolean isAborted() {
        return this.papiState == 6;
    }

    @Deprecated
    public Activity getActivity() {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public final boolean isActivityCompleted() {
        return false;
    }

    public Time getActivityDeadline() {
        return this.getMainTask() != null ? Time.valueOf((Object)this.getMainTask()) : null;
    }

    public final Time getDeadline() {
        Time processDeadline = this.getProcessDeadline();
        Time activityDeadline = this.getActivityDeadline();
        return processDeadline == null ? activityDeadline : (activityDeadline == null ? processDeadline : processDeadline.min(activityDeadline));
    }

    public String getActivityId() {
        return this.activityId.getIdString();
    }

    public String getActivityName() {
        return this.activityId.getActivityName();
    }

    public String getUnqualifiedActivityName() {
        return this.activityId.getUnqualifiedActivityName();
    }

    public int getAuthor() {
        return 0;
    }

    public String getLabel() {
        return this.processLabel;
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public final boolean isCompleted() {
        return this.papiState == 5;
    }

    public String getDescription() {
        return this.description;
    }

    public final boolean isException() {
        return false;
    }

    public boolean isExecuting() {
        return this.papiState == 1 || this.papiState == 2 || this.papiState == 7 || this.papiState == 4;
    }

    public final boolean isGrabbed() {
        return false;
    }

    public String getId() {
        return this.instanceId;
    }

    @Deprecated
    public final Object getVar(String variableId, Locale locale) {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public final Object getVariable(String variableId, Locale locale) {
        return this.getVariable(variableId);
    }

    public Object getExternalVariable(String variableId, Locale locale) throws InvalidVariableIdException {
        return this.getExternalVariable(variableId);
    }

    @Deprecated
    public final Object getVar(String variableId) {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public final Object getVariable(String variableId) {
        try {
            return this.getExternalVariable(variableId);
        }
        catch (InvalidVariableIdException invalidExternalVariable) {
            return Void.getInstance();
        }
    }

    public Object getExternalVariable(String variableId) throws InvalidVariableIdException {
        if (variableId.equals("PREDEFINE_DEADLINE")) {
            return this.getDeadline();
        }
        if (variableId.equals("PREDEFINE_DESCRIPTION")) {
            return this.getDescription();
        }
        if (variableId.equals("PREDEFINE_INSTANCE NUMBER")) {
            return this.getInstanceIn();
        }
        if (variableId.equals("PREDEFINE_PRIORITY")) {
            return this.getPriority();
        }
        if (variableId.equals("PREDEFINE_STATUS")) {
            return this.getStatus();
        }
        if (variableId.equals("PREDEFINE_RECEIVED TIME")) {
            return this.getReceptionTime();
        }
        if (variableId.equals("PREDEFINE_PROCESS DEADLINE")) {
            return this.getProcessDeadline();
        }
        if (variableId.equals("PREDEFINE_ACTIVITY DEADLINE")) {
            return this.getActivityDeadline();
        }
        if (variableId.equals("PREDEFINE_PROCESS")) {
            return this.getProcessId();
        }
        if (variableId.equals("PREDEFINE_ACTIVITY")) {
            return this.getActivityName();
        }
        if (variableId.equals("PREDEFINE_AUTHOR") || variableId.equals(VarDefinition.AUTHOR_DISPLAYNAME)) {
            return this.getAuthorId();
        }
        if (variableId.equals("PREDEFINE_CREATION TIME")) {
            return this.getCreationTime();
        }
        if (variableId.equals("PREDEFINE_HAS_ATTACHMENTS")) {
            return this.hasAttachments();
        }
        if (variableId.equals(VarDefinition.HAS_NOTES)) {
            return this.hasNotes();
        }
        if (variableId.equals("PREDEFINE_PARTICIPANT")) {
            return this.getParticipantId();
        }
        if (variableId.equals(VarDefinition.MAIN_TASK_PARTICIPANT_ID)) {
            try {
                return this.getTaskParticipantId(0);
            }
            catch (InvalidTaskNumberException ignore) {
                return null;
            }
        }
        if (variableId.equals("PREDEFINE_PROJECT_APPLICATION")) {
            ComponentDNModel processModelDN = ComponentDNModel.parseComponentDN((String)this.getProcessId());
            return processModelDN.getCompositeDN().getApplicationName();
        }
        if (variableId.equals("PREDEFINE_PROCEJECT_NAME")) {
            ComponentDNModel processModelDN = ComponentDNModel.parseComponentDN((String)this.getProcessId());
            return processModelDN.getCompositeDN().getCompositeName();
        }
        if (variableId.equals("PREDEFINE_PROCEJECT_REVISION")) {
            ComponentDNModel processModelDN = ComponentDNModel.parseComponentDN((String)this.getProcessId());
            return processModelDN.getCompositeDN().getRevision();
        }
        if (variableId.equals("PREDEFINE_PROCESS_NAME")) {
            ComponentDNModel processModelDN = ComponentDNModel.parseComponentDN((String)this.getProcessId());
            return processModelDN.getComponentName();
        }
        if (variableId.equals("PREDEFINE_ACTIVITY_TYPE")) {
            return this.bpmnType == null ? 0 : ActivityTypeHelper.getActivityType(this.bpmnType);
        }
        if (this.variables.containsKey(variableId)) {
            return this.variables.get(variableId);
        }
        throw new InvalidVariableIdException(variableId, false, "");
    }

    public Object getNormalVariable(String variableId) throws InvalidVariableIdException {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public final boolean hasAttachments() {
        return this.hasAttachments;
    }

    public final boolean hasNotes() {
        return this.hasNotes;
    }

    public final boolean hasPendingTasks() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public final boolean hasRepeatableTasks() {
        return false;
    }

    public int getInternalState() {
        return this.papiState;
    }

    public int getNumberOfThreads() {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public int getParentThreadIn() {
        return this.parentThread;
    }

    public String getParticipantId() {
        return this.participantId_d;
    }

    public String getParticipantDisplayName() {
        return this.participantDisplayName;
    }

    public int getParticipantIn() {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public final boolean isPending() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public int getPendingTaskIn() {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public int getPriority() {
        int priority = this.task != null && this.task.size() > 0 ? this.task.get(0).getPriority() : this.bpmPriority;
        return PriorityHelper.getPapiPriority(priority);
    }

    public Time getProcessDeadline() {
        return Time.valueOf((Calendar)this.processDueDate);
    }

    public String getProcessId() {
        return this.processId;
    }

    public Time getReceptionTime() {
        return Time.valueOf((Calendar)this.createdDate);
    }

    public final boolean isRunning() {
        return this.papiState == 1 || this.papiState == 2 || this.papiState == 7 || this.papiState == 4;
    }

    public final boolean isSelected() {
        return this.participantId_d != null && !this.participantId_d.isEmpty();
    }

    public String getRoleId() {
        return this.roleId;
    }

    public int getRoleIn() {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public InstanceActivityPair getInstanceActivityPair() {
        return InstanceActivityPair.valueOf((String)this.getId(), (String)this.getActivityName());
    }

    public int getStatus() {
        return this.papiState;
    }

    public String getStatusDescription(Locale locale) {
        return ProcessInstanceState.getDescription((int)this.getStatus(), (Locale)locale);
    }

    public final boolean isSuspended() {
        return this.papiState == 3;
    }

    public Task getTask(int taskNumber) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public oracle.bpel.services.workflow.task.model.Task getTask() {
        return this.getMainTask();
    }

    public Task getTask(String taskId) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public final boolean isTaskCompleted(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return false;
    }

    public final int getTaskCount() {
        return this.task == null ? 0 : 1;
    }

    public int getTaskIn(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return this.getMainTask().getSystemAttributes().getTaskNumber();
    }

    public final int getTaskInternalStatus(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return this.getMainTask().getSystemAttributes().getState().hashCode();
    }

    public final String getTaskLastExecutionParticipant(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        IdentityType identityType = this.getMainTask() != null ? this.getMainTask().getSystemAttributes().getUpdatedBy() : null;
        return identityType != null ? identityType.getId() : null;
    }

    public final Time getTaskLastExecutionTime(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        Calendar updated = this.getMainTask() != null ? this.getMainTask().getSystemAttributes().getUpdatedDate() : null;
        return updated != null ? Time.valueOf((Calendar)updated) : null;
    }

    public String getTaskParticipantId(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return this.participantId_d;
    }

    public int getTaskRetryCounter(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return 0;
    }

    public final boolean isTaskRunning(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return true;
    }

    public final boolean isTaskSelected(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return this.getMainTask().getSystemAttributes().getParticipantName() != null;
    }

    public String getTaskStatusDescription(int taskNumber, Locale locale) {
        this.validateTaskNumber(taskNumber);
        if (this.task != null) {
            return this.getMainTask().getTitle();
        }
        return "";
    }

    public final boolean isTaskValid(int taskNumber) {
        this.validateTaskNumber(taskNumber);
        return true;
    }

    public Task[] getTasks() {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public final void invalidateTask(int taskNumber) {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public String toString() {
        return "InstanceInfoAdapter[InstanceId:'" + this.getId() + "']";
    }

    public void setTaskInfo(List<oracle.bpel.services.workflow.task.model.Task> task) {
        this.task = task;
        if (task != null) {
            for (oracle.bpel.services.workflow.task.model.Task task1 : task) {
                List assignees = task1.getSystemAttributes().getAssignees();
                if (assignees == null || assignees.size() <= 0) continue;
                for (int i = 0; i < assignees.size(); ++i) {
                    String displayName = ((IdentityType)assignees.get(i)).getDisplayName();
                    if (this.participantId_d == null || this.participantId_d.equals("")) {
                        this.participantId_d = ((IdentityType)assignees.get(i)).getId();
                        if (displayName != null && !displayName.equals("")) {
                            this.participantDisplayName = displayName;
                            continue;
                        }
                        this.participantDisplayName = this.participantId_d;
                        continue;
                    }
                    this.participantId_d = this.participantId_d + " , " + ((IdentityType)assignees.get(i)).getId();
                    this.participantDisplayName = displayName != null && !displayName.equals("") ? this.participantDisplayName + " , " + ((IdentityType)assignees.get(i)).getDisplayName() : this.participantId_d + " , " + ((IdentityType)assignees.get(i)).getDisplayName();
                }
            }
        }
    }

    public oracle.bpel.services.workflow.task.model.Task getHumanWorkflowTask() {
        return this.getMainTask();
    }

    public int getMainThreadRealState() {
        return this.mainThreadRealState;
    }

    public String getProcessLabel() {
        return this.processLabel;
    }

    public List<String> getThreadAssignedTaskIds() {
        ArrayList<String> taskIds = new ArrayList<String>();
        if (this.task != null) {
            for (oracle.bpel.services.workflow.task.model.Task task1 : this.task) {
                if (task1.getSystemAttributes().getCustomActions() == null || task1.getSystemAttributes().getCustomActions().size() <= 0) continue;
                taskIds.add(task1.getSystemAttributes().getTaskId());
            }
        }
        return taskIds;
    }

    public List<ActionType> getThreadCustomActions() {
        oracle.bpel.services.workflow.task.model.Task mainTask = this.getMainTask();
        ArrayList<ActionType> customActions = new ArrayList<ActionType>();
        if (mainTask != null && mainTask.getSystemAttributes().getCustomActions() != null) {
            customActions.addAll(mainTask.getSystemAttributes().getCustomActions());
        }
        return customActions;
    }

    private void initiate(IProcessInstance _processInstance) {
        this.processIn = _processInstance.getProcessDN().hashCode();
        this.processId = _processInstance.getProcessDN();
        this.processLabel = CompositeDNModel.parseCompositeDN((String)_processInstance.getSca().getCompositeDN()).getLabel();
        this.threadIn = _processInstance.getSystemAttributes().getThread();
        this.description = _processInstance.getTitle();
        this.parentThread = _processInstance.getSystemAttributes().getParentThread();
        this.instanceId = _processInstance.getSystemAttributes().getProcessInstanceId();
        this.cubeInstanceId = _processInstance.getCubeInstanceId();
        try {
            this.instanceIn = Integer.valueOf(_processInstance.getCubeInstanceId());
        }
        catch (NumberFormatException exception) {
            this.instanceIn = -1;
        }
        this.creationTime_d = Time.valueOf((Calendar)_processInstance.getSystemAttributes().getCreatedDate());
        this.authorId = _processInstance.getCreator();
        this.participantId_d = null;
        this.participantDisplayName = null;
        this.roleId = null;
        for (IIdentityType assignee : _processInstance.getSystemAttributes().getAssignees()) {
            if (IIdentityType.IDENTITY_TYPE.USER.name().equalsIgnoreCase(assignee.getType())) {
                this.participantId_d = assignee.getId();
                String displayName = null;
                displayName = assignee.getDisplayName();
                if (displayName != null && !displayName.equals("")) {
                    this.participantDisplayName = displayName;
                    continue;
                }
                this.participantDisplayName = this.participantId_d;
                continue;
            }
            if (!IIdentityType.IDENTITY_TYPE.ROLE.name().equalsIgnoreCase(assignee.getType())) continue;
            this.roleId = assignee.getId();
        }
        this.bpmnType = _processInstance.getSystemAttributes().getActivityType();
        this.bpmState = _processInstance.getSystemAttributes().getState();
        this.papiState = ProcessInstanceStateHelper.getPAPIState(this.bpmState);
        this.bpmPriority = _processInstance.getPriority();
        this.hasAttachments = !_processInstance.getAttachment().isEmpty();
        this.hasNotes = !_processInstance.getUserComment().isEmpty();
        this.createdDate = _processInstance.getSystemAttributes().getCreatedDate();
        this.processDueDate = _processInstance.getSystemAttributes().getProcessDueDate();
        String processName = _processInstance.getProcessName();
        if (processName == null) {
            ComponentDNModel componentDNModel = ComponentDNModel.parseComponentDN((String)this.processId);
            processName = componentDNModel.getComponentName();
        }
        String activityName = _processInstance.getSystemAttributes().getActivityId();
        this.activityId = AdapterUtils.ActivityId.createActivityId(ComponentDNModel.parseComponentDN((String)this.processId), processName, activityName);
        this.mainThreadRealState = ProcessInstanceStateHelper.getPAPIState(_processInstance.getCallback().getContext());
    }

    private void validateTaskNumber(int taskNumber) {
        if (taskNumber != 0) {
            throw new InvalidTaskNumberException(taskNumber, this.getActivityName());
        }
        if (this.task == null) {
            // empty if block
        }
    }

    private oracle.bpel.services.workflow.task.model.Task getMainTask() {
        if (this.task != null && this.task.size() > 0) {
            if (this.task.size() == 1) {
                return this.task.get(0);
            }
            oracle.bpel.services.workflow.task.model.Task mainTask = null;
            for (oracle.bpel.services.workflow.task.model.Task task1 : this.task) {
                if (task1.getSystemAttributes().getParentTaskId() == null) {
                    mainTask = task1;
                }
                if (task1.getSystemAttributes().getCustomActions() == null || task1.getSystemAttributes().getCustomActions().size() <= 0) continue;
                return task1;
            }
            if (mainTask != null) {
                return mainTask;
            }
            return this.task.get(0);
        }
        return null;
    }
}

