/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.InstanceEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.EventTypeAdapter;
import oracle.bpm.papi.ora.helper.InstanceEventHelper;
import oracle.bpm.papi.ora.metadata.AdapterUtils;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;

public class InstanceEventAdapter
extends InstanceEvent {
    private AdapterUtils.ActivityId activityId;
    private IAuditInstance auditInstance;
    private static final long serialVersionUID = -7326515047088792588L;

    private InstanceEventAdapter(IAuditInstance auditInstance) {
        this.auditInstance = auditInstance;
        this.id = auditInstance.getQueryId().intValue();
        this.type = EventTypeAdapter.valueOf(auditInstance.getOperation());
        this.category = 0;
        this.timeStamp = Time.valueOf((Calendar)auditInstance.getCreateTime());
        this.processId = auditInstance.getComponentName();
        this.processIn = -1;
        try {
            this.instanceIn = Integer.parseInt(auditInstance.getCompositeInstanceId());
        }
        catch (NumberFormatException e) {
            this.instanceIn = -1;
        }
        this.threadIn = auditInstance.getThreadId().intValue();
        this.activity = auditInstance.getActivityId();
        this.activityId = AdapterUtils.ActivityId.createActivityId(ComponentDNModel.buildComponentDN((String)auditInstance.getDN(), (String)auditInstance.getComponentName()), auditInstance.getProcessName(), auditInstance.getActivityId());
        this.participantIn = -1;
        this.participantId = auditInstance.getParticipant();
        this.receiveTime = null;
        this.activationTime = null;
        Map variables = auditInstance.getVariables();
        if (variables == null) {
            this.bussinesVariablesIds = new String[0];
            this.bussinesVariablesValues = new Object[0];
        } else {
            this.bussinesVariablesIds = variables.keySet().toArray(new String[variables.size()]);
            ArrayList<Object> values = new ArrayList<Object>();
            for (IAuditVariable variable : variables.values()) {
                values.add(variable.getValue());
            }
            this.bussinesVariablesValues = values.toArray(new Object[values.size()]);
        }
        this.eventData = InstanceEventHelper.makeEventData(this);
    }

    public static InstanceEventAdapter create(IAuditInstance auditInstance) {
        return new InstanceEventAdapter(auditInstance);
    }

    public static InstanceEventAdapter createTransitionEvent(IAuditInstance auditInstance) {
        StringBuilder data = new StringBuilder();
        data.append("FROM=");
        data.append(auditInstance.getSourceActivity());
        data.append(":");
        data.append("TO=");
        data.append(auditInstance.getTargetActivity());
        data.append(":");
        InstanceEventAdapter instanceEventAdapter = new InstanceEventAdapter(auditInstance);
        instanceEventAdapter.type = 27;
        instanceEventAdapter.eventData = data.toString();
        instanceEventAdapter.activity = auditInstance.getTargetActivity();
        instanceEventAdapter.activityId = AdapterUtils.ActivityId.createActivityId(ComponentDNModel.buildComponentDN((String)auditInstance.getDN(), (String)auditInstance.getComponentName()), auditInstance.getProcessName(), auditInstance.getTargetActivity());
        return instanceEventAdapter;
    }

    public IAuditInstance getAuditInstance() {
        return this.auditInstance;
    }

    public String getInstanceId() {
        return this.auditInstance.getComponentInstanceId();
    }

    public AdapterUtils.ActivityId getActivityId() {
        return this.activityId;
    }
}

