/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.ConnectionPassport;
import oracle.bpm.util.Properties;

public class ConnectionPassportAdapter
implements ConnectionPassport,
Serializable {
    private String id;
    private ParticipantCredentials participantCredentials;
    static final long serialVersionUID = 20091027170000L;

    private ConnectionPassportAdapter(String id, ParticipantCredentials participantCredentials) {
        this.id = id;
        this.participantCredentials = participantCredentials;
    }

    public static ConnectionPassportAdapter create(String id) {
        ParticipantCredentials participantCredentials = ParticipantCredentials.createEmpty();
        return new ConnectionPassportAdapter(id, participantCredentials);
    }

    public static ConnectionPassportAdapter create(String id, ParticipantCredentials participantCredentials) {
        return new ConnectionPassportAdapter(id, participantCredentials);
    }

    public boolean isAnonymous() {
        return this.participantCredentials == null || this.participantCredentials.getParticipant() == null;
    }

    public String getId() {
        return this.id;
    }

    public void setParticipant(String participant) {
        this.participantCredentials.setParticipant(participant);
    }

    public void setPassword(String password) {
        this.participantCredentials.setPassword(password == null ? new char[]{} : password.toCharArray());
    }

    public String getPreset() {
        return null;
    }

    public Object getProperty(String property) {
        return this.participantCredentials.getProperty(property);
    }

    public String getUrl() {
        return null;
    }

    public void fillPassport() {
    }

    public void putProperties(Properties properties) {
        for (Object propertyKey : properties.keySet()) {
            if (!(propertyKey instanceof String)) continue;
            String key = (String)propertyKey;
            this.participantCredentials.putProperty(key, properties.get((Object)key));
        }
    }

    public void putProperty(String property, Object value) {
        this.participantCredentials.putProperty(property, value);
    }

    public ParticipantCredentials getParticipantCredentials() {
        return this.participantCredentials;
    }

    public static class ParticipantCredentials
    implements Serializable {
        private String participantId;
        private char[] password;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private String realm;
        static final long serialVersionUID = 20091027170000L;

        private ParticipantCredentials(String participant, char[] pass, String realmName) {
            this.participantId = participant;
            this.password = pass;
            this.realm = realmName;
        }

        public static ParticipantCredentials create(String participant, char[] password, String realm) {
            return new ParticipantCredentials(participant, password, realm);
        }

        public static ParticipantCredentials createEmpty() {
            return new ParticipantCredentials(null, null, null);
        }

        public static ParticipantCredentials create(String participant, String password, String realm) {
            return ParticipantCredentials.create(participant, password.toCharArray(), realm);
        }

        public String getParticipant() {
            return this.participantId;
        }

        public void setParticipant(String realmName) {
            this.realm = realmName;
        }

        public char[] getPassword() {
            return this.password;
        }

        public void setPassword(char[] password) {
            this.password = password;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realmName) {
            this.realm = realmName;
        }

        public Object getProperty(String propertyKey) {
            return this.properties.get(propertyKey);
        }

        public void putProperty(String propertyKey, Object propertyValue) {
            this.properties.put(propertyKey, propertyValue);
        }
    }
}

