/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.Activity;
import fuego.papi.ApplicationsView;
import fuego.papi.Arguments;
import fuego.papi.Attachment;
import fuego.papi.AttachmentOperationException;
import fuego.papi.BatchOperationException;
import fuego.papi.Consult;
import fuego.papi.GlobalExecution;
import fuego.papi.InstanceInfo;
import fuego.papi.InstancesView;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.ParticipantFor;
import fuego.papi.Process;
import fuego.papi.ProcessDiagram;
import fuego.papi.ProcessNotAvailableException;
import fuego.papi.TaskExecution;
import fuego.papi.View;
import fuego.papi.ViewType;
import fuego.papi.attachment.AttachmentStorageType;
import fuego.papi.collections.ActivityList;
import fuego.papi.collections.AttachmentList;
import fuego.papi.collections.InstanceActivityPairSet;
import fuego.papi.collections.InstanceEventList;
import fuego.papi.collections.InstanceInfoList;
import fuego.papi.collections.NoteList;
import fuego.papi.collections.ParticipantList;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.collections.ProcessList;
import fuego.papi.exception.ActivityNotFoundException;
import fuego.papi.exception.InvalidViewTypeException;
import fuego.papi.exception.ViewNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.papi.ora.DeprecatedSessionAdapter;

public abstract class BaseSessionAdapter
extends DeprecatedSessionAdapter {
    public void attachmentCheckOutToStream(String attachmentId, OutputStream stream) throws OperationException {
        this.attachmentCheckOutToStream(this.attachmentGet(attachmentId), stream);
    }

    public InstanceInfo activityCommit(String activityName, String instanceId, Arguments args) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        Process process = this.processGet(instance.getProcessId());
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(process.getId(), activityName);
        }
        return this.activityCommit(activity, instance, args);
    }

    public void activityAbort(String activityName, String instanceId) throws OperationException {
        this.activityAbort(activityName, 0, instanceId);
    }

    public void activityAbort(Activity activity, InstanceInfo instance) throws OperationException {
        this.activityAbort(activity, 0, instance);
    }

    public void activityAbort(String activityName, int taskIn, String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        Process process = this.processGet(instance.getProcessId());
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(process.getId(), activityName);
        }
        this.activityAbort(activity, taskIn, instance);
    }

    public TaskExecution activityPost(String activityName, String instanceId, Arguments args) throws OperationException {
        return this.activityPost(activityName, instanceId, 0, args);
    }

    public TaskExecution activityPost(Activity activity, InstanceInfo instance, Arguments args) throws OperationException {
        return this.activityPost(activity, instance, 0, args);
    }

    public TaskExecution activityPost(String activityName, String instanceId, int taskToExecute, Arguments args) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        Process process = this.processGet(instance.getProcessId());
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(process.getId(), activityName);
        }
        return this.activityPost(activity, instance, taskToExecute, args);
    }

    public InstanceInfoList activityGetGrabbableInstances(String activityName, String processId) throws OperationException, BatchOperationException {
        Process process = this.processGet(processId);
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(process.getId(), activityName);
        }
        return this.activityGetGrabbableInstances(activity);
    }

    public ParticipantList instanceGetParticipants(String instanceId, ParticipantFor participantFor) throws OperationException, BatchOperationException {
        return this.instanceGetParticipants(this.processGetInstance(instanceId), participantFor);
    }

    public ParticipantList instanceGetParticipants(String instanceId, String activityName, ParticipantFor participantFor) throws OperationException, BatchOperationException {
        InstanceActivityPairSet set = InstanceActivityPairSet.create().add(instanceId, activityName);
        return this.instancesGetParticipants(set, participantFor);
    }

    public ParticipantList instanceGetParticipants(String instanceId, String activityName, ParticipantFor participantFor, String filter, int max) throws OperationException, BatchOperationException {
        InstanceActivityPairSet set = InstanceActivityPairSet.create().add(instanceId, activityName);
        return this.instancesGetParticipants(set, participantFor, filter, max);
    }

    public ParticipantList instanceGetParticipants(InstanceInfo instance, ParticipantFor participantFor) throws OperationException, BatchOperationException {
        InstanceActivityPairSet set = InstanceActivityPairSet.create().add(instance);
        return this.instancesGetParticipants(set, participantFor);
    }

    public ParticipantList instancesGetParticipants(InstanceActivityPairSet instanceActivityPairSet, ParticipantFor participantFor) throws OperationException, BatchOperationException {
        return this.instancesGetParticipants(instanceActivityPairSet, participantFor, null, 500);
    }

    public void attachmentCheckIn(String attachmentId, String remarks, File file) throws OperationException {
        this.attachmentCheckIn(this.attachmentGet(attachmentId), remarks, file);
    }

    public void instanceAttach(InstanceInfo instanceInfo, String name, String description, String remarks, File file) throws OperationException, IOException {
        this.instanceAttach(instanceInfo, name, description, remarks, file, null, this.participantLocale());
    }

    public void instanceAttach(InstanceInfo instanceInfo, String name, String description, String remarks, File file, String contentType) throws OperationException, IOException {
        this.instanceAttach(instanceInfo, name, description, remarks, file, contentType, this.participantLocale());
    }

    public void instanceAttach(InstanceInfo instanceInfo, String name, String description, String remarks, File file, String contentType, Locale locale) throws OperationException, IOException {
        this.instanceAttach(instanceInfo, name, description, remarks, file, contentType, locale, AttachmentStorageType.ENGINE_DB);
    }

    public void instanceAttach(String instanceId, String name, String description, String remarks, File file, String contentType, Locale locale) throws OperationException, IOException {
        this.instanceAttach(instanceId, name, description, remarks, file, contentType, locale, AttachmentStorageType.ENGINE_DB);
    }

    public void instanceAttach(String instanceId, String name, String description, String remarks, File file, String contentType, Locale locale, AttachmentStorageType storageType) throws OperationException, IOException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        this.instanceAttach(instance, name, description, remarks, file, contentType, locale, storageType);
    }

    public void instanceLinkExternalAttachment(String instanceId, String externalId, AttachmentStorageType storageType) throws OperationException, IOException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        this.instanceLinkExternalAttachment(instance, externalId, storageType);
    }

    public ActivityList instanceGetGlobalActivities(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceGetGlobalActivities(instance);
    }

    public boolean instanceCanBeAborted(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeAborted(instance);
    }

    public boolean instanceCanBeSentBack(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeSentBack(instance);
    }

    public boolean instanceCanBeProcessed(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeProcessed(instance);
    }

    public boolean instanceCanBeReassigned(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeReassigned(instance);
    }

    public boolean instanceCanBeDelegated(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeDelegated(instance);
    }

    public boolean instanceCanBeEscalated(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeEscalated(instance);
    }

    public boolean instanceCanBeReassignedToPeer(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeReassignedToPeer(instance);
    }

    public boolean instanceCanBeResumed(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeResumed(instance);
    }

    public boolean instanceCanBeSelected(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeSelected(instance);
    }

    public boolean instanceCanBeSent(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeSent(instance);
    }

    public boolean instanceCanBeSuspended(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeSuspended(instance);
    }

    public boolean instanceCanBeUngrabbed(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeUngrabbed(instance);
    }

    public boolean instanceCanBeUnselected(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceCanBeUnselected(instance);
    }

    public void instanceReassign(String instanceId, String activityName, String participant) throws OperationException, BatchOperationException {
        InstanceActivityPairSet set = InstanceActivityPairSet.create().add(instanceId, activityName);
        this.instancesReassign(set, participant);
    }

    public void instanceReassign(InstanceInfo instance, String participant) throws OperationException, BatchOperationException {
        InstanceActivityPairSet set = InstanceActivityPairSet.create().add(instance);
        this.instancesReassign(set, participant);
    }

    public void instancesSendTo(InstanceActivityPairSet instances, String activityName) throws OperationException, BatchOperationException {
        this.instancesSendTo(instances, activityName, null);
    }

    public StringList instancesGetTargetActivities(InstanceActivityPairSet instances) throws BatchOperationException {
        StringList list = StringList.create();
        for (Activity activity : this.instancesGetTargetActivitiesList(instances)) {
            list.add((Object)activity.getName());
        }
        return list;
    }

    public void attachmentEdit(String attachmentId) throws OperationException {
        this.attachmentEdit(this.attachmentGet(attachmentId));
    }

    public Arguments activityPrepare(String activityName, String instanceId, Arguments args) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        Process process = this.processGet(instance.getProcessId());
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(process.getId(), activityName);
        }
        return this.activityPrepare(activity, instance, args);
    }

    public void attachmentRelease(String attachmentId) throws OperationException {
        this.attachmentRelease(this.attachmentGet(attachmentId));
    }

    public void attachmentRelease(Attachment attachment, File file) throws OperationException {
        this.attachmentRelease(attachment);
        try {
            file.delete();
        }
        catch (SecurityException e) {
            throw new AttachmentOperationException(attachment.getId(), (Throwable)e);
        }
    }

    public InstanceInfo activityExecute(Activity activity, InstanceInfo instance, Arguments args) throws OperationException {
        return this.activityExecute(activity, instance, 0, args);
    }

    public InstanceInfo activityExecute(String activityName, String instanceId, Arguments args) throws OperationException {
        return this.activityExecute(activityName, instanceId, 0, args);
    }

    public InstanceInfo activityExecute(String activityName, String instanceId, int taskToExecute, Arguments args) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        Process process = this.processGet(instance.getProcessId());
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(process.getId(), activityName);
        }
        return this.activityExecute(activity, instance, taskToExecute, args);
    }

    public InstanceInfo activityExecute(Activity activity, InstanceInfo instance, int taskToExecute, Arguments args) throws OperationException {
        return this.activityExecute(activity, instance, activity.getTask(taskToExecute), args);
    }

    public boolean taskCanBeProcessed(int taskNumber, String activityName, String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId, activityName);
        return this.taskCanBeProcessed(instance, taskNumber);
    }

    public boolean taskCanBeSelected(int taskNumber, String activityName, String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId, activityName);
        return this.taskCanBeSelected(instance, taskNumber);
    }

    public boolean taskCanBeUnselected(int taskNumber, String activityName, String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId, activityName);
        return this.taskCanBeUnselected(instance, taskNumber);
    }

    public void tasksSelect(int[] taskNumbers, String activityName, String instanceId) throws OperationException, BatchOperationException {
        InstanceInfo instance = this.processGetInstance(instanceId, activityName);
        this.tasksSelect(instance, taskNumbers);
    }

    public void tasksUnselect(int[] taskNumbers, String activityName, String instanceId) throws OperationException, BatchOperationException {
        InstanceInfo instance = this.processGetInstance(instanceId, activityName);
        this.tasksUnselect(instance, taskNumbers);
    }

    public String activityGetDocumentation(String activityName, String processId, Locale locale) throws OperationException {
        Process process = this.processGet(processId);
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(processId, activityName);
        }
        return this.activityGetDocumentation(activity, locale);
    }

    public ActivityList viewGetApplications(String applicationViewId) throws OperationException, BatchOperationException {
        View view = this.viewGet(applicationViewId);
        if (view == null) {
            throw new ViewNotFoundException(applicationViewId);
        }
        if (!view.getType().isType(ViewType.APPLICATIONS)) {
            throw new InvalidViewTypeException(view.getType(), ViewType.APPLICATIONS);
        }
        return this.viewGetApplications((ApplicationsView)view);
    }

    public AttachmentList instanceGetAttachments(String instanceId) throws OperationException {
        return this.instanceGetAttachments(this.processGetInstance(instanceId));
    }

    public Consult instanceGetLastConsult(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceGetLastConsult(instance);
    }

    public ActivityList processesGetGlobalActivities(ProcessIdSet processIdSet) throws BatchOperationException {
        return this.processesGetGlobalActivities(processIdSet, false);
    }

    public ActivityList instanceGrabbableFrom(String instanceId) throws OperationException {
        InstanceInfo instance = this.processGetInstance(instanceId);
        return this.instanceGrabbableFrom(instance);
    }

    public DynamicObject instanceGetData(String instanceId) throws OperationException {
        return this.instanceGetData(this.processGetInstance(instanceId));
    }

    public InstanceEventList instanceGetEvents(String instanceId) throws OperationException {
        return this.instanceGetEvents(this.processGetInstance(instanceId));
    }

    public NoteList instanceGetNotes(String instanceId) throws OperationException {
        return this.instanceGetNotes(this.processGetInstance(instanceId));
    }

    public InstanceInfoList viewGetInstances(String viewId) throws OperationException, BatchOperationException {
        View view = this.viewGet(viewId);
        if (view == null) {
            throw new ViewNotFoundException(viewId);
        }
        if (!view.getType().isType(ViewType.INSTANCES)) {
            throw new InvalidViewTypeException(view.getType(), ViewType.INSTANCES);
        }
        return this.viewGetInstances((InstancesView)view);
    }

    public View viewGetParent(String viewId) throws OperationException {
        View view = this.viewGet(viewId);
        if (view == null) {
            throw new ViewNotFoundException(viewId);
        }
        return this.viewGetParent(view);
    }

    public ProcessDiagram processGetDiagram(String processId, String mdsLabel) throws ProcessNotAvailableException {
        try {
            return this.processGetDiagram(this.processGet(processId));
        }
        catch (OperationException e) {
            throw new ProcessNotAvailableException(processId, (Throwable)e);
        }
    }

    public String instanceGetProcessId(String instanceId) {
        try {
            InstanceInfo instance = this.processGetInstance(instanceId);
            return instance.getProcessId();
        }
        catch (OperationException exception) {
            throw new OperationRuntimeException((Throwable)exception);
        }
    }

    public Object instanceGetVariable(String instanceId, String variableId) {
        try {
            return this.instanceGetVariable(this.processGetInstance(instanceId), variableId);
        }
        catch (OperationException e) {
            throw new OperationRuntimeException((Throwable)e);
        }
    }

    public StringList processesGetIds() {
        return this.processesGetIds(false);
    }

    public ProcessList processesGet(boolean force) throws BatchOperationException {
        return this.processesGet(false, force);
    }

    public InstanceInfo processCreateInstance(String targetProcessId, Arguments arguments) throws OperationException {
        return this.processCreateInstance(targetProcessId, null, arguments);
    }

    public InstanceInfo processCreateInstance(String targetProcessId, String argumentSetName, Arguments arguments, String name, String description, String remarks, File file, String contentType, Locale locale) throws OperationException, IOException {
        return this.processCreateInstance(targetProcessId, argumentSetName, arguments, name, description, remarks, file, contentType, locale, AttachmentStorageType.ENGINE_DB);
    }

    public GlobalExecution activityPostApplication(String activityName, String processId, Arguments arguments) throws OperationException {
        Process process = this.processGet(processId);
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(processId, activityName);
        }
        return this.activityPostApplication(activity, arguments);
    }

    public InstanceInfo instanceRefresh(String instanceId) throws OperationException {
        return this.instanceRefresh(this.processGetInstance(instanceId));
    }

    public void instanceStoreProperty(String instanceId, String key, String value) throws OperationException {
        this.instanceStoreProperty(this.processGetInstance(instanceId), key, value);
    }

    public String instanceRetrieveProperty(String instanceId, String key) throws OperationException {
        return this.instanceRetrieveProperty(this.processGetInstance(instanceId), key);
    }

    public InstanceInfo activityExecuteApplication(String activityName, String processId) throws OperationException {
        Process process = this.processGet(processId);
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(processId, activityName);
        }
        return this.activityExecuteApplication(activity, null);
    }

    public InstanceInfo activityExecuteApplication(Activity activity) throws OperationException {
        return this.activityExecuteApplication(activity, null);
    }

    public InstanceInfo activityExecuteApplication(String activityName, String processId, Arguments arguments) throws OperationException {
        Process process = this.processGet(processId);
        Activity activity = process.getActivity(activityName);
        if (activity == null) {
            throw new ActivityNotFoundException(processId, activityName);
        }
        return this.activityExecuteApplication(activity, arguments);
    }

    public void processSendNotification(String targetInstanceOrProcessId, String activityName, String targetArgumentsSetName, Arguments notification) throws OperationException {
        this.processSendNotification(targetInstanceOrProcessId, activityName, targetArgumentsSetName, notification, null);
    }
}

