/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora;

import fuego.papi.Attachment;
import fuego.papi.attachment.AttachmentStorageType;
import fuego.papi.exception.InvalidVariableIdException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import oracle.bpm.lang.Time;
import oracle.bpm.services.instancemanagement.model.IProcessAttachment;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;

public class AttachmentAdapter
implements Attachment {
    private Time creationTime;
    private String creator;
    private String instanceId;
    private IProcessAttachment processAttachment;
    private String processId;

    private AttachmentAdapter() {
    }

    public static AttachmentAdapter create(IProcessAttachment processAttachment, IProcessInstance processInstance, String description) {
        AttachmentAdapter attachmentAdapter = new AttachmentAdapter();
        attachmentAdapter.instanceId = processInstance.getSystemAttributes().getProcessInstanceId();
        attachmentAdapter.processId = processInstance.getProcessDN();
        processAttachment.setMimeType(description);
        attachmentAdapter.processAttachment = processAttachment;
        attachmentAdapter.creationTime = Time.valueOf((Calendar)processAttachment.getUpdatedDate());
        attachmentAdapter.creator = processAttachment.getUpdatedBy();
        return attachmentAdapter;
    }

    public IProcessAttachment getProcessAttachment() {
        return this.processAttachment;
    }

    public long getContentSize() {
        return this.processAttachment.getContent().length();
    }

    public String getContent() {
        return this.processAttachment.getContent();
    }

    public String getContentType() {
        return this.processAttachment.getMimeType();
    }

    public Time getCreationTime() {
        return this.creationTime;
    }

    public String getCreatorName() {
        return this.creator;
    }

    public String getDescription() {
        return this.processAttachment.getDescription();
    }

    public void setDescription(String description) {
        this.processAttachment.setDescription(description);
    }

    public Time getEditionTime() {
        return Time.valueOf((Calendar)this.processAttachment.getUpdatedDate());
    }

    public String getFileExtension() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public boolean isFileModified(String directory) {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getFileName() {
        return this.processAttachment.getName();
    }

    public String getId() {
        return this.getInstanceId() + "#" + this.processAttachment.getName();
    }

    public int getIn() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getInstanceIn() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getLocaleSize(Locale locale) {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public boolean isLocked() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public boolean isLockedByParticipant(String participantId) {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getLockerName() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getName() {
        return this.processAttachment.getName();
    }

    @Deprecated
    public String getOsInfo() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    @Deprecated
    public int getProcessIn() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getRemarks() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public Object getVar(String variableId) throws InvalidVariableIdException {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public int getVersion() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getExternalUrl() {
        return this.processAttachment.getURI();
    }

    public String getExternalDownloadUrl() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public String getExternalId() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public AttachmentStorageType getStorageType() {
        if (this.processAttachment.getURI() != null && !this.processAttachment.getURI().isEmpty()) {
            if (this.processAttachment.getURI().startsWith("ecm://")) {
                return AttachmentStorageType.ECM;
            }
            return AttachmentStorageType.URI;
        }
        return AttachmentStorageType.ENGINE_DB;
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public boolean existsFile(String directory) throws IOException {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public void saveAs(String attachmentsDirectory, File file) throws FileNotFoundException, SecurityException, IOException {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }
}

