/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.SVGImage;
import oracle.bpm.ui.Ui;

public class CustomImageHelper {
    private static String lastPath = "images/";
    private static String path = "bpm/designer/images";
    private static final String IMAGE_FILE_EXTENSION = ".png";
    private static final String SVG_IMAGE_FILE_EXTENSION = ".svg";

    public static Image getCustomImage(FlowElement flowElement) throws MalformedURLException {
        CustomizedImageFeature feature = (CustomizedImageFeature)flowElement.getFeature(CustomizedImageFeature.class);
        Image result = feature != null && feature.getValue() != null ? CustomImageHelper.getCustomImage(feature.getValue()) : null;
        return result;
    }

    public static Image getCustomImage(String imageId) throws MalformedURLException {
        Image result = null;
        if (Ui.supportsSVG()) {
            try {
                result = SVGImage.create((URL)CustomImageHelper.getSVGCustomImageUrl(imageId));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = Image.create((URL)CustomImageHelper.getCustomImageUrl(imageId));
        }
        return result;
    }

    public static URL getCustomImageUrl(String imageId) throws MalformedURLException {
        return CustomImageHelper.getCustomImageUrl(imageId, IMAGE_FILE_EXTENSION);
    }

    public static URL getSVGCustomImageUrl(String imageId) throws MalformedURLException {
        return CustomImageHelper.getCustomImageUrl(imageId, SVG_IMAGE_FILE_EXTENSION);
    }

    public static String[] getCustomImageList() {
        ArrayList<String> images = new ArrayList<String>();
        URL imageURL = CustomImageHelper.getImageURL();
        assert (imageURL.getProtocol().equals("jar"));
        String jarPath = imageURL.getPath().substring(5, imageURL.getPath().indexOf("!"));
        try {
            String currentExtension;
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            String string = currentExtension = Ui.supportsSVG() ? SVG_IMAGE_FILE_EXTENSION : IMAGE_FILE_EXTENSION;
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || !name.endsWith(currentExtension)) continue;
                String id = name.substring(path.length() + 1, name.lastIndexOf("."));
                images.add(id);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return images.toArray(new String[images.size()]);
    }

    private static URL getCustomImageUrl(String imageId, String extension) throws MalformedURLException {
        String imageFileName = imageId + extension;
        URL result = new URL(CustomImageHelper.getImageURL(), lastPath + imageFileName);
        if (result.toString().endsWith(lastPath + lastPath + imageFileName)) {
            result = new URL(CustomImageHelper.getImageURL(), imageFileName);
        }
        return result;
    }

    private static URL getImageURL() {
        return CustomImageHelper.class.getClassLoader().getResource(path);
    }
}

