/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.util.Collection;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ProjectKeeper;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public class SelectProjectStep
extends WizardStep {
    private SelectProjectPanel panel;
    private ProjectKeeper prjKeeper;

    public SelectProjectStep(Wizard owner, ProjectKeeper prjKeeper) {
        super(owner);
        this.prjKeeper = prjKeeper;
    }

    public boolean doProcess() {
        Project project = this.panel.getSelectedProject();
        this.prjKeeper.setProject(project);
        if (!project.isOpen()) {
            try {
                project.getLoader().getProjectRepository().open(project);
            }
            catch (ProjectException e) {
                return false;
            }
        }
        return true;
    }

    public void undoProcess() {
    }

    protected WizardStepPanel getPanelFor(UiContainer parent) {
        if (this.panel == null) {
            this.panel = new SelectProjectPanel(parent);
        }
        return this.panel;
    }

    class SelectProjectPanel
    extends WizardStepPanel {
        ComboBox<Project> comboBox;

        public SelectProjectPanel(UiContainer parent) {
            super(parent, (WizardStep)SelectProjectStep.this);
        }

        public boolean validateInput() {
            return this.comboBox.getSelectedIndex() >= 0;
        }

        public Project getSelectedProject() {
            return (Project)this.comboBox.getSelectedItem();
        }

        protected UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.PROJECT_NAME_TITLE);
            this.setPageDesc(ProjectMsg.EXPORT_PROJECT_NAME_DESCR);
            Panel centerPanel = new Panel(parent);
            StandardForm layout = FormsFactory.createStandardForm((UiContainer)centerPanel);
            Collection projects = this.getProjectRepository().getAllProjects();
            this.comboBox = UiFactory.createComboBox((UiContainer)centerPanel);
            this.comboBox.addItems((Iterable)projects);
            this.comboBox.setLabelProvider((LabelProvider)new ProjectLabelProvider());
            this.comboBox.setEnabled(!projects.isEmpty());
            layout.add(this.comboBox);
            if (!projects.isEmpty()) {
                this.comboBox.setSelectedIndex(0);
            }
            SelectProjectStep.this.getNextButton().setEnabled(!projects.isEmpty());
            return centerPanel;
        }

        private ProjectRepository getProjectRepository() {
            return RepositoryService.getInstance().getActiveRepository();
        }
    }

    static class ProjectLabelProvider
    extends LabelProvider.Default<Project> {
        ProjectLabelProvider() {
        }

        public String getText(Project project) {
            return project == null ? "" : project.getName();
        }
    }
}

