/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.util.List;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.io.fs.export.ProjectZipper;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.validators.ImportFuegoProjectValidator;
import oracle.bpm.project.ui.wizards.ImportProjectWizardUserObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public class ProjectNameStep
extends WizardStep {
    private ProjectNamePanel projectNamePanel;

    public ProjectNameStep(Wizard owner) {
        super(owner);
    }

    public WizardStepPanel getPanelFor(UiContainer parent) {
        this.projectNamePanel = new ProjectNamePanel(parent, this);
        return this.projectNamePanel;
    }

    public boolean doProcess() {
        ((ImportProjectWizardUserObject)this.getWizard().getUserObject()).getEntries().get(0).setProjectName(this.projectNamePanel.projectNameTextField.getText());
        return true;
    }

    public void undoProcess() {
    }

    private static class ProjectNamePanel
    extends WizardStepPanel {
        private TextField projectNameTextField;

        public ProjectNamePanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        public UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.PROJECT_NAME_TITLE);
            this.setPageDesc(ProjectMsg.PROJECT_NAME_DESCR);
            Panel centerPanel = new Panel(parent);
            StandardForm layout = FormsFactory.createStandardForm((UiContainer)centerPanel);
            Label projectNameLabel = Label.create((UiContainer)centerPanel, (Msg)ProjectMsg.PROJECT_NAME);
            this.projectNameTextField = new TextField((UiContainer)centerPanel);
            layout.add((UiComponent)projectNameLabel);
            layout.add((UiComponent)this.projectNameTextField);
            return centerPanel;
        }

        public void onFocus() {
            Wizard wizard = this.getWizardStep().getWizard();
            List<ProjectZipper.Entry> entries = ((ImportProjectWizardUserObject)wizard.getUserObject()).getEntries();
            if (entries.size() == 1) {
                ProjectZipper.Entry entry = entries.get(0);
                this.projectNameTextField.setText(entry.getProjectName());
            }
        }

        public boolean validateInput() {
            ImportFuegoProjectValidator validator = new ImportFuegoProjectValidator();
            try {
                validator.validate(this.projectNameTextField.getText());
            }
            catch (InputValidationException e) {
                MessageDialog.showError((Msg)e.getKey());
                return false;
            }
            return true;
        }
    }
}

