/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.project.ui.wizards.ProjectNameAndRootPanel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.util.Identifier;

public class ProjectNameAndLocationStep
extends WizardStep {
    private LocationPanel panel;

    public ProjectNameAndLocationStep(Wizard wizard) {
        super(wizard);
    }

    public WizardStepPanel getPanelFor(UiContainer parent) {
        this.panel = new LocationPanel(parent);
        return this.panel;
    }

    public boolean doProcess() {
        String rootDir = this.panel.getRootDir();
        String projectName = this.panel.getProjectName();
        ImportWizardUserObject importWizardUserObject = (ImportWizardUserObject)this.getWizard().getUserObject();
        importWizardUserObject.setProjectName(projectName);
        importWizardUserObject.setProjectRootDirectory(rootDir);
        return true;
    }

    public void undoProcess() {
    }

    class LocationPanel
    extends ProjectNameAndRootPanel {
        public LocationPanel(UiContainer parent) {
            super(parent, ProjectNameAndLocationStep.this);
        }

        public String getProjectPath() {
            return this.getRootDir() + this.getProjectName();
        }

        @Override
        public boolean validateInput() {
            boolean ok = super.validateInput();
            if (!ok) {
                return false;
            }
            String projectName = this.getProjectName();
            if (RepositoryService.getInstance().getActiveRepository().existsProject(projectName)) {
                MessageDialog.showError((Msg)ProjectMsg.PROJECT_WITH_THIS_NAME_ALREADY_EXISTS((String)projectName));
                return false;
            }
            File projectFile = new File(this.getProjectPath());
            if (projectFile.exists()) {
                MessageDialog.showError((Msg)ProjectMsg.PROJECT_DIR_ALREADY_EXISTS);
                return false;
            }
            File parentFile = projectFile.getParentFile();
            return parentFile.exists() || MessageDialog.showQuestion((Msg)ProjectMsg.CREATING_PROJECT, (Msg)ProjectMsg.PROJECT_ROOT_DIR_NOT_EXISTS, (int)6) == 2;
        }

        @Override
        protected void setPanelTitle() {
            this.setPageTitle(ProjectMsg.PROJECT_INFORMATION);
            this.setPageDesc(ProjectMsg.PROJECT_INFORMATION_HELP);
        }

        @Override
        protected String getInitialName() {
            String previousValue = this.getUserObject().getProjectName();
            if (previousValue != null) {
                return previousValue;
            }
            return this.suggestProjectName(this.getInitialRootDir());
        }

        @Override
        protected String getInitialRootDir() {
            String previousValue = this.getUserObject().getProjectRootDirectory();
            if (previousValue != null) {
                return previousValue;
            }
            return RepositoryService.getInstance().getActiveRepository().getDefaultBaseDir().getPath();
        }

        private String suggestProjectName(String rootDir) {
            String baseName;
            ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
            String projectName = baseName = Identifier.valid((String)ProjectMsg.UNNAMED.toString());
            int i = 1;
            while (repository.existsProject(projectName) || new File(rootDir, projectName).exists()) {
                projectName = baseName + i;
                ++i;
            }
            return projectName;
        }

        private ImportWizardUserObject getUserObject() {
            return (ImportWizardUserObject)this.getWizardStep().getWizard().getUserObject();
        }
    }
}

