/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import oracle.bpm.project.io.UnzipListener;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportProjectWizardUserObject;
import oracle.bpm.project.ui.wizards.ProjectImportRunnable;
import oracle.bpm.project.ui.wizards.UiUnzipListenerDecoratee;
import oracle.bpm.project.ui.wizards.UnzipProjectRunnable;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.wizards.model.DynamicExecutorStep;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.DynamicExecutorPanel;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public class ImportProjectStep
extends DynamicExecutorStep {
    public ImportProjectStep(Wizard owner) {
        super(owner);
    }

    public String getDescriptionText() {
        return ProjectMsg.CREATING_PROJECT.getString();
    }

    public WizardStepPanel getPanelFor(UiContainer parent) {
        return new ProjectUnzipPanel(parent, (WizardStep)this);
    }

    private class ProjectUnzipPanel
    extends DynamicExecutorPanel
    implements UnzipListener {
        private TextArea outputArea;

        public ProjectUnzipPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        public UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.IMPORT_PROJECT);
            Panel centerPanel = new Panel(parent);
            centerPanel.setLayout((Layout)new BorderLayout());
            this.outputArea = new TextArea((UiContainer)centerPanel, ScrollPolicy.ALWAYS, ScrollPolicy.AS_NEEDED);
            this.outputArea.setAutoscrolls(true);
            this.outputArea.setRows(10);
            this.outputArea.setColumns(30);
            this.outputArea.setEditable(false);
            this.outputArea.setWrapStyleWord(true);
            LabelMultiline area = ProjectUnzipPanel.createTextArea((UiContainer)centerPanel, (Msg)ProjectMsg.UNZIP_MESSAGES);
            centerPanel.add((UiComponent)area, (Object)"North");
            centerPanel.add((UiComponent)this.outputArea, (Object)"Center");
            return centerPanel;
        }

        public void info(String msg) {
            if (!this.outputArea.isDisposed()) {
                this.outputArea.append(msg.trim() + "\n");
            }
        }

        public void onFocus() {
            Wizard wizard = this.getWizardStep().getWizard();
            this.getWizardStep().getNextButton().setEnabled(false);
            Button backButton = this.getWizardStep().getBackButton();
            if (backButton != null) {
                backButton.setEnabled(false);
            }
            this.getWizardStep().getCancelButton().setEnabled(false);
            UiUnzipListenerDecoratee listener = UiUnzipListenerDecoratee.decorate(this);
            WizardStep step = this.getWizardStep();
            ImportProjectWizardUserObject userObject = (ImportProjectWizardUserObject)wizard.getUserObject();
            ProjectImportRunnable importRunnable = new ProjectImportRunnable(step, userObject, listener);
            UnzipProjectRunnable unzipRunnable = new UnzipProjectRunnable(step, userObject, listener, importRunnable);
            Thread unzipThread = new Thread(unzipRunnable);
            unzipThread.setName(UnzipProjectRunnable.class.getSimpleName());
            unzipThread.start();
        }
    }
}

