/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import java.io.IOException;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.io.UnzipListener;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.io.fs.export.ProjectZipper;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.project.ui.wizards.ProjectKeeper;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.SwingWorker;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.monitor.ProgressMonitorGUI;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.wizards.model.DynamicExecutorStep;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardExecutorStep;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.model.WizardSwingWorker;
import oracle.bpm.ui.wizards.model.WizardSwingWorkerActionAdaptor;
import oracle.bpm.ui.wizards.model.WizardSwingWorkerExecutorAdaptor;
import oracle.bpm.ui.wizards.ui.DynamicExecutorPanel;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public class ExportProjectExecutorStep
extends DynamicExecutorStep {
    private ProjectKeeper prjKeeper;

    public ExportProjectExecutorStep(Wizard owner, ProjectKeeper prjKeeper) {
        super(owner);
        this.prjKeeper = prjKeeper;
    }

    public String getDescriptionText() {
        return ProjectMsg.CREATING_PROJECT.getString();
    }

    public WizardStepPanel getPanelFor(UiContainer parent) {
        return new ProjectZipPanel(parent, (WizardStep)this, this.prjKeeper.getProject());
    }

    protected void startProcessing() {
    }

    protected void stopProcessing() {
    }

    private static class ProjectZipPanel
    extends DynamicExecutorPanel {
        private ProgressMonitorGUI monitor = null;
        private TextArea outputArea;
        private FileProjectWriter projectWriter;

        public ProjectZipPanel(UiContainer parent, WizardStep wizardStep, Project project) {
            super(parent, wizardStep);
            this.projectWriter = (FileProjectWriter)project.getWriter();
        }

        public void onFocus() {
            this.export();
        }

        public void close(ActionEvent e) {
            WizardSwingWorker worker = new WizardSwingWorker((WizardSwingWorkerActionAdaptor)new WizardSwingWorkerExecutorAdaptor((WizardExecutorStep)this.getWizardStep()){

                protected void finishActionIn(WizardSwingWorker worker) {
                    super.finishActionIn(worker);
                    ProjectZipPanel.super.close();
                }
            });
            worker.start();
        }

        public UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.EXPORT_PROJECT);
            Panel centerPanel = new Panel(parent);
            centerPanel.setLayout((Layout)new BorderLayout());
            this.outputArea = new TextArea((UiContainer)centerPanel, ScrollPolicy.ALWAYS, ScrollPolicy.AS_NEEDED);
            this.outputArea.setRows(10);
            this.outputArea.setColumns(30);
            this.outputArea.setEditable(false);
            this.outputArea.setWrapStyleWord(true);
            LabelMultiline area = ProjectZipPanel.createTextArea((UiContainer)centerPanel, (Msg)ProjectMsg.ZIP_MESSAGE);
            centerPanel.add((UiComponent)area, (Object)"North");
            centerPanel.add((UiComponent)this.outputArea, (Object)"Center");
            this.getWizardStep().getNextButton().setEnabled(false);
            Button backButton = this.getWizardStep().getBackButton();
            if (backButton != null) {
                backButton.setEnabled(false);
            }
            return centerPanel;
        }

        private void export() {
            final ImportWizardUserObject wizardUserObject = (ImportWizardUserObject)this.getWizardStep().getWizard().getUserObject();
            final String projectFile = wizardUserObject.getProjectFileLocation();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (ProjectZipPanel.this.monitor != null) {
                        ProjectZipPanel.this.monitor.phase(ProjectMsg.ADDING_FILES_TO_ZIP);
                    }
                    ProjectZipPanel.this.outputArea.append(ProjectIoMsg.EXPORTING_PROJECT.toString() + "\n");
                    File file = new File(projectFile);
                    final int filesQty = ProjectZipPanel.this.getFilesQty(null);
                    try {
                        ProjectZipper.create().zipProject(ProjectZipPanel.this.projectWriter.getProject(), file, wizardUserObject.isIncludeDependencies(), new UnzipListener(){
                            int progressCount = 0;

                            public void info(final String msg) {
                                if (!UiUtilities.isEventDispatchThread()) {
                                    UiUtilities.invokeLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!ProjectZipPanel.this.outputArea.isDisposed()) {
                                                ProjectZipPanel.this.outputArea.append(msg.trim() + "\n");
                                                ProjectZipPanel.this.outputArea.setCaretPosition(ProjectZipPanel.this.outputArea.getTextLength());
                                            }
                                        }
                                    });
                                }
                                ++this.progressCount;
                                if (ProjectZipPanel.this.monitor != null) {
                                    ProjectZipPanel.this.monitor.progress(100 * this.progressCount / filesQty);
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }

                public void finished() {
                    Button back = ProjectZipPanel.this.getWizardStep().getBackButton();
                    Button cancelButton = ProjectZipPanel.this.getWizardStep().getCancelButton();
                    if (this.get().equals(Boolean.TRUE)) {
                        Button nextButton;
                        if (ProjectZipPanel.this.monitor != null) {
                            ProjectZipPanel.this.monitor.progress(100);
                        }
                        if ((nextButton = ProjectZipPanel.this.getWizardStep().getNextButton()) != null) {
                            nextButton.setEnabled(true);
                        }
                        if (back != null) {
                            back.setEnabled(false);
                        }
                        if (cancelButton != null) {
                            cancelButton.setEnabled(false);
                        }
                    } else {
                        Button backButton = back;
                        if (backButton != null) {
                            backButton.setEnabled(true);
                        }
                        cancelButton.setEnabled(true);
                    }
                }
            };
            this.getWizardStep().getNextButton().setEnabled(false);
            Button backButton = this.getWizardStep().getBackButton();
            if (backButton != null) {
                backButton.setEnabled(false);
            }
            this.getWizardStep().getCancelButton().setEnabled(false);
            worker.start();
        }

        private int getFilesQty(VFileFilter filter) {
            int totalFiles = 0;
            VFile vFile = this.projectWriter.getProjectFileSystem().getDataFileSystem().getRoot();
            try {
                totalFiles = VFileUtils.getFilesRecursively((VFile)vFile, (VFileFilter)filter).size();
            }
            catch (IOException e) {
                throw ProgramException.wrap((String)("Exception while calculating amount of files in root: " + vFile.getName()), (Throwable)e);
            }
            return totalFiles;
        }
    }
}

