/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.ui.wizards.ExportProjectExecutorStep;
import oracle.bpm.project.ui.wizards.ExportProjectSummaryStep;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.project.ui.wizards.ProjectExportFileLocationStep;
import oracle.bpm.project.ui.wizards.ProjectKeeper;
import oracle.bpm.project.ui.wizards.SelectProjectStep;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.model.WizardTask;

public class ExportFuegoProjectWizard
extends Wizard {
    public ExportFuegoProjectWizard(Project project, boolean isDeveloper, Msg title) {
        this.setMsg(title);
        this.setUserObject(new ImportWizardUserObject());
        LinkedList steps = this.getSteps();
        ProjectKeeper projectKeeper = new ProjectKeeper(project);
        if (project == null) {
            steps.add(new SelectProjectStep(this, projectKeeper));
        }
        steps.add(new ProjectExportFileLocationStep(this, projectKeeper));
        steps.add(new ExportProjectExecutorStep(this, projectKeeper));
        this.build();
    }

    public File getProjectFile() {
        return ((ImportWizardUserObject)this.getUserObject()).getProjectFile();
    }

    public String getProjectFileLocationName() {
        return ((ImportWizardUserObject)this.getUserObject()).getProjectFileLocation();
    }

    public Dimension getProperSize() {
        return Dimension.valueOf((int)550, (int)450);
    }

    public List<WizardTask> processingTasks() {
        return new ArrayList<WizardTask>();
    }

    protected WizardStep getInitialStep() {
        return null;
    }

    protected WizardStep getSummaryStep() {
        return new ExportProjectSummaryStep(this);
    }
}

