/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.validators;

import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.io.validator.ProjectNameExistenceValidator;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.text.TextFilter;
import oracle.bpm.ui.text.filter.ValidFileFilter;
import oracle.bpm.ui.validators.NotEmptyValidator;
import oracle.bpm.ui.validators.NotNullValidator;

public class ProjectNameInputValidator
implements InputValidator {
    private TextFilter validFileFilter = new ValidFileFilter(128);

    public void validate(String newProjectName) throws InputValidationException {
        newProjectName = newProjectName.trim();
        new NotNullValidator(ProjectMsg.PROJECT_NAME_NULL).validate(newProjectName);
        new NotEmptyValidator(ProjectMsg.PROJECT_NAME_NULL).validate(newProjectName.trim());
        InputValidationException.assertTrue((boolean)this.validFileFilter.accepts(newProjectName, 0), (Msg)ProjectMsg.INVALID_PROJECT_NAME);
        new ProjectNameExistenceValidator().validate(newProjectName);
    }
}

