/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui;

import java.util.TimeZone;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.TableCell;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.TimeField;

public class TimeCell
implements TableCell {
    private TableCellEditor editor;
    private TimeField.Format format;
    private LabelProvider renderer;
    private TimeField.Style style;
    private Class valueType;
    private static final String TIME_MASK = "h:mm:ss a";

    public TimeCell(TimeField.Style style, TimeField.Format format, Class valueType) {
        assert (valueType.equals(Time.class) || valueType.equals(Interval.class));
        this.valueType = valueType;
        this.style = style;
        this.format = format;
    }

    public Dimension getMinimumSize() {
        return Dimension.valueOf((int)90, (int)10);
    }

    public TableCellEditor editor() {
        if (this.editor == null) {
            this.editor = new Editor();
        }
        return this.editor;
    }

    public LabelProvider renderer() {
        if (this.renderer == null) {
            this.renderer = new LabelProvider.Default(){

                public String getText(Object value) {
                    String formattedTime = "";
                    if (value != null) {
                        if (value instanceof Interval) {
                            value = Time.valueOf((Interval)((Interval)value));
                        }
                        if (value instanceof Time) {
                            Time time = (Time)value;
                            formattedTime = time.format(TimeCell.TIME_MASK, TimeZone.getTimeZone("GMT"));
                        }
                    }
                    return formattedTime;
                }
            };
        }
        return this.renderer;
    }

    private class Editor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TimeField field;

        private Editor() {
        }

        public Object getCellEditorValue() {
            Time value = this.field.getTime();
            return TimeCell.this.valueType.equals(Interval.class) ? Interval.valueOf((Time)value) : value;
        }

        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)parent, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.field = new TimeField(parent, TimeCell.this.style, TimeCell.this.format);
            this.field.setPattern(TimeCell.TIME_MASK);
            this.field.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.field.setBorder(null);
            this.setValue(value);
            return this.field;
        }

        private void setValue(Object value) {
            if (value instanceof Time) {
                this.field.setTime((Time)value);
            } else if (value instanceof Interval) {
                this.field.setTime(Time.valueOf((Interval)((Interval)value)));
            }
        }
    }
}

