/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.TableCell;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;

public class ComboBoxCell
implements TableCell {
    private Object defaultValue;
    private TableCellEditor editor;
    private LabelProvider renderer;
    private List<Object> values;

    public ComboBoxCell(List<Object> values) {
        this(values, null);
    }

    public ComboBoxCell(Object[] values) {
        this(values, null);
    }

    public ComboBoxCell(List<Object> values, Object defaultValue) {
        this.values = values;
        this.defaultValue = defaultValue;
    }

    public ComboBoxCell(Object[] values, Object defaultValue) {
        this(Arrays.asList(values), defaultValue);
    }

    public TableCellEditor editor() {
        if (this.editor == null) {
            this.editor = this.createEditor();
        }
        return this.editor;
    }

    public Dimension getMinimumSize() {
        return Dimension.valueOf((int)90, (int)10);
    }

    public LabelProvider renderer() {
        if (this.renderer == null) {
            this.renderer = this.createRendered();
        }
        return this.renderer;
    }

    protected TableCellEditor createEditor() {
        return new Editor();
    }

    protected LabelProvider createRendered() {
        return new LabelProvider.Default(){

            public String getText(Object value) {
                String result = value instanceof I18nProvider ? ((I18nProvider)value).getString() : (value != null ? value.toString() : String.valueOf(ComboBoxCell.this.defaultValue));
                return result;
            }
        };
    }

    protected class Editor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected ComboBox comboBox;

        protected Editor() {
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.initComboBox(parent);
            this.comboBox.setSelectedItem(value);
            return this.comboBox;
        }

        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        public UiComponent getTableCellEditor(Table table, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)table, value);
        }

        private void initComboBox(UiContainer parent) {
            this.comboBox = UiFactory.createComboBox((UiContainer)parent, (Object)ComboBoxCell.this.defaultValue, (List)ComboBoxCell.this.values);
            this.comboBox.setBorder(null);
        }
    }
}

