/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.bpm.bpmobject.importexport.ImportExportException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Str;
import oracle.bpm.type.ComponentCatalog;
import org.jetbrains.annotations.NotNull;

public class BusinessObjectImporter {
    private static final String zipEntrySeparator = "/";

    public static Boolean hasConflicts(@NotNull File zipFile, @NotNull VFileSystem vFileSystem) throws ImportExportException {
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.hasConflicts must not be null");
        }
        if (vFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.hasConflicts must not be null");
        }
        return BusinessObjectImporter.getConflicts(zipFile, vFileSystem).size() != 0;
    }

    public static Set<String> getConflicts(@NotNull File zipFile, @NotNull VFileSystem vFileSystem) throws ImportExportException {
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.getConflicts must not be null");
        }
        if (vFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.getConflicts must not be null");
        }
        HashSet<String> result = new HashSet<String>();
        Set<String> zipFiles = BusinessObjectImporter.listEntries(zipFile.getAbsolutePath());
        VFile root = vFileSystem.getRoot();
        Set<String> vFiles = BusinessObjectImporter.getVFiles(root, new HashSet<String>());
        for (String file : zipFiles) {
            if (!vFiles.contains(File.separator + file)) continue;
            result.add(file);
        }
        return result;
    }

    public static void merge(@NotNull File zipFile, @NotNull VFileSystem vFileSystem, ComponentCatalog catalog) throws ImportExportException {
        ZipFile zip;
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.merge must not be null");
        }
        if (vFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.merge must not be null");
        }
        assert (!BusinessObjectImporter.hasConflicts(zipFile, vFileSystem).booleanValue());
        try {
            zip = new ZipFile(zipFile);
        }
        catch (IOException e) {
            throw new ImportExportException(e);
        }
        ArrayList<ZipEntry> xsds = new ArrayList<ZipEntry>();
        ArrayList<ZipEntry> wsdls = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (entry.isDirectory()) {
                BusinessObjectImporter.writeEntry(vFileSystem, zip, entry);
                continue;
            }
            if (name.endsWith(".xsd")) {
                xsds.add(entry);
                continue;
            }
            if (!name.endsWith(".wsdl")) continue;
            wsdls.add(entry);
        }
        for (ZipEntry entry : xsds) {
            BusinessObjectImporter.writeEntry(vFileSystem, zip, entry);
        }
        for (ZipEntry entry : wsdls) {
            BusinessObjectImporter.writeEntry(vFileSystem, zip, entry);
        }
        catalog.sync();
    }

    private static void writeEntry(VFileSystem vFileSystem, ZipFile zip, ZipEntry entry) throws ImportExportException {
        InputStream inputStream = null;
        OutputStream vFileoutputStream = null;
        try {
            inputStream = zip.getInputStream(entry);
            BusinessObjectImporter.createDirectories(entry, vFileSystem);
            if (!entry.isDirectory()) {
                VFile vfile = vFileSystem.createFile(entry.getName());
                vFileoutputStream = vfile.openOuputStream();
                StreamUtils.copy(inputStream, vFileoutputStream);
            }
        }
        catch (IOException e) {
            throw new ImportExportException(e);
        }
        finally {
            try {
                if (vFileoutputStream != null) {
                    vFileoutputStream.flush();
                    vFileoutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new ImportExportException(e);
            }
        }
    }

    private static void createDirectories(ZipEntry entry, VFileSystem vFileSystem) {
        String[] split = entry.getName().split(zipEntrySeparator);
        VFile parent = vFileSystem.createFile("businessCatalog");
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (Str.isEmpty(s) || s.equals("businessCatalog") || i == split.length - 1 && !entry.isDirectory()) continue;
            VFile vDirectory = vFileSystem.createFile(parent, s);
            vDirectory.mkdirs();
            parent = vDirectory;
        }
    }

    private static Set<String> getVFiles(@NotNull VFile vFile, @NotNull Set<String> result) {
        VFile[] files;
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.getVFiles must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.getVFiles must not be null");
        }
        for (VFile vFileEntry : files = vFile.listFiles(null)) {
            if (vFileEntry.isFile()) {
                result.add(vFileEntry.getCanonicalPath());
                continue;
            }
            BusinessObjectImporter.getVFiles(vFileEntry, result);
        }
        return result;
    }

    private static Set<String> listEntries(@NotNull String zipFilePath) throws ImportExportException {
        ZipFile zip;
        if (zipFilePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectImporter.listEntries must not be null");
        }
        File zipfile = new File(zipFilePath);
        try {
            zip = new ZipFile(zipfile);
        }
        catch (IOException e) {
            throw new ImportExportException(e);
        }
        HashSet<String> setResult = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            String filePath = ((Object)entries.nextElement()).toString();
            setResult.add(filePath);
        }
        return setResult;
    }
}

