/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.List;
import java.util.TreeMap;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.xml.msg.XmlMsg;
import oracle.bpm.xmlschema.AttrGroupTypeDescription;
import oracle.bpm.xmlschema.Particle;
import oracle.bpm.xmlschema.TypeException;

class Sequence
extends Particle {
    Sequence() {
    }

    @Override
    protected AttrGroupTypeDescription buildAttributes(TypeDescription current, boolean mergeGroups) throws TypeException {
        if (this.getMaxOccurs() != 1) {
            return new AttrGroupTypeDescription();
        }
        AttrGroupTypeDescription group = super.buildAttributes(current, mergeGroups);
        AttributeTypeDescription[] attributes = group.getAttributes();
        group = new AttrGroupTypeDescription();
        if (attributes != null) {
            int length = attributes.length;
            List<MethodTypeDescription> list = ((ObjectTypeDescription)current).getAttributes();
            int position = list != null ? list.size() : 0;
            for (int i = 0; i < length; ++i) {
                int nextIndex;
                int nextIndex2;
                AttributeTypeDescription attr = attributes[i].clone();
                TreeMap<String, String> properties = new TreeMap<String, String>(attr.getProperties());
                attr.setProperties(properties);
                String writeSignature = attr.getWriteSignature();
                if (writeSignature.charAt(0) == '@' && (nextIndex2 = writeSignature.indexOf(";")) != -1) {
                    writeSignature = writeSignature.substring(nextIndex2 + 1);
                }
                writeSignature = String.valueOf('@') + position + ";" + writeSignature;
                attr.setWriteSignature(writeSignature);
                String readSignature = attr.getReadSignature();
                if (readSignature.charAt(0) == '@' && (nextIndex = readSignature.indexOf(";")) != -1) {
                    readSignature = readSignature.substring(nextIndex + 1);
                }
                readSignature = String.valueOf('@') + position + ";" + readSignature;
                attr.setReadSignature(readSignature);
                attr.setProperty("elementPosition", Integer.toString(position));
                ++position;
                group.addAttribute(attr);
            }
        }
        return group;
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        boolean hasMinOccurrs;
        boolean hasMaxOccurrs = this.getAttribute("maxOccurs") != null;
        boolean bl = hasMinOccurrs = this.getAttribute("minOccurs") != null;
        if (hasMaxOccurrs || hasMinOccurrs) {
            this.reportWarning(XmlMsg.SEQUENCE_WITH_RESTRICTION_NOT_SUPPORTED.getString());
        }
        return this.buildAttributes(current, true);
    }
}

