/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.HashMap;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.xmlschema.Attribute;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.SchemaElement;

public class SOAPNamespace
extends ExtendedNamespace {
    private static HashMap<String, SOAPNamespace> instances = new HashMap();
    static final long serialVersionUID = -2186638981905566589L;
    static final long serialCheck = 1045482725475285156L;

    private SOAPNamespace(String uri) {
        super(uri);
        this.addType("Array", TypeFactory.getArray(TypeFactory.getAny()), null);
        AttributeTypeDescription attrType = new AttributeTypeDescription("arrayType", TypeFactory.getString());
        this.attributes.put("arrayType", new Attribute(attrType));
        this.addType("string", TypeFactory.getString(), null);
        this.addType("double", TypeFactory.getReal(), "double");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPNamespace get(String uri) {
        HashMap<String, SOAPNamespace> hashMap = instances;
        synchronized (hashMap) {
            SOAPNamespace result = instances.get(uri);
            if (result == null) {
                result = new SOAPNamespace(uri);
                instances.put(uri, result);
            }
            return result;
        }
    }

    static boolean isSOAPSchema(String uri) {
        return "http://schemas.xmlsoap.org/soap/encoding/".equals(uri);
    }

    @Override
    void setTarget(boolean target) {
        throw new UnsupportedOperationException("Attempt to set '" + this.getUri() + "' as target namespace");
    }

    @Override
    void declareAnonymous(TypeDescription type) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareAttribute(String name, SchemaElement element) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    void declareAttribute(String name, AttributeTypeDescription attr) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareAttributeGroup(String name, SchemaElement element) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareElement(String name, SchemaElement element) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    void declareElement(String name, AttributeTypeDescription attr) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareGroup(String name, SchemaElement element) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    void declareGroup(String name, TypeDescription group) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareType(String name, SchemaElement element) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    private void addType(String name, TypeDescription type, String javaType) {
        SchemaElement typeHolder = new SchemaElement();
        typeHolder.setTypeDescription(type);
        typeHolder.setJavaType(javaType);
        typeHolder.setNamespace(this.getUri());
        typeHolder.setAttribute("name", name);
        this.types.put(name, typeHolder);
    }
}

