/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.ValidationException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.xml.msg.XmlMsg;
import oracle.bpm.xmlschema.AttrGroupTypeDescription;
import oracle.bpm.xmlschema.Attribute;
import oracle.bpm.xmlschema.ComponentDef;
import oracle.bpm.xmlschema.Enumeration;
import oracle.bpm.xmlschema.FractionDigits;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.SimpleType;
import oracle.bpm.xmlschema.TotalDigits;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.XMLIntrospector;

public class Restriction
extends ComponentDef {
    private static final String SOAPENC_ARRAY = "soapenc:Array";
    private static final String NATIVE_NAME = "nativeName";
    private static final String NAMESPACE = "namespace";
    static final String SOAP_ARRAY = "soapArray";

    public String getBase() {
        return super.getAttribute("base");
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        SchemaElement first;
        String base = this.getBase();
        TypeDescription baseType = XMLIntrospector.XMLOBJECT;
        if (base != null) {
            baseType = this.findType(base, XMLIntrospector.XMLOBJECT);
        }
        if ((first = this.getFirst()) instanceof SimpleType) {
            baseType = first.buildType(current);
            first = first.getNext();
        } else if (this.isEnumeration() && baseType.isString()) {
            baseType = JavaEnumTypeDescription.createObject();
        } else if (baseType.isArray()) {
            TypeDescription atype;
            String arrayType;
            if (base != null && base.startsWith(SOAPENC_ARRAY)) {
                ObjectTypeDescription objTypeDesc = (ObjectTypeDescription)current;
                this.reportWarning(XmlMsg.SOAP_ENCODING_ARRAY_WARNING(objTypeDesc.getProperty(NATIVE_NAME), objTypeDesc.getProperty(NAMESPACE)).toString());
            }
            if ((arrayType = this.findArrayType()) != null && (atype = this.buildArrayType(arrayType)) != null && atype.isArray()) {
                ArrayTypeDescription objectType = (ArrayTypeDescription)atype;
                objectType.setProperty(SOAP_ARRAY, Boolean.TRUE.toString());
                return objectType;
            }
        } else if (baseType.isNumber()) {
            int totalDigits = this.findTotalDigits();
            int fractionDigits = this.findFractionDigits();
            if (totalDigits != 0) {
                baseType = baseType.setLength(totalDigits);
            }
            if (fractionDigits != 0) {
                baseType = baseType.setScale(fractionDigits);
            }
        }
        AttrGroupTypeDescription group = this.buildAttributes(first, baseType, true);
        if (baseType.isAny()) {
            ObjectTypeDescription subclass = super.buildType(current).asObject();
            try {
                group.addTo(subclass);
            }
            catch (ValidationException e) {
                this.reportError("Internal error: " + e.getMessage());
            }
            baseType = subclass;
        }
        return baseType;
    }

    private int findTotalDigits() {
        String totalDigit = null;
        TotalDigits totalDigits = this.findChildByClass(TotalDigits.class);
        if (totalDigits != null) {
            totalDigit = totalDigits.getValue();
        }
        return totalDigit == null ? 0 : Integer.valueOf(totalDigit);
    }

    private int findFractionDigits() {
        String fracDigit = null;
        FractionDigits fractionDigits = this.findChildByClass(FractionDigits.class);
        if (fractionDigits != null) {
            fracDigit = fractionDigits.getValue();
        }
        return fracDigit == null ? 0 : Integer.valueOf(fracDigit);
    }

    private boolean isEnumeration() {
        SchemaElement element = this.getFirst();
        if (element instanceof SimpleType) {
            element = element.getNext();
        }
        boolean isEnum = element instanceof Enumeration;
        while (element != null) {
            isEnum = isEnum && element instanceof Enumeration;
            element = element.getNext();
        }
        return isEnum;
    }

    private TypeDescription buildArrayType(String arrayTypeText) {
        TypeDescription result;
        int index = arrayTypeText.lastIndexOf(91);
        if (index != -1) {
            arrayTypeText = arrayTypeText.substring(0, index);
            ArrayTypeDescription arrayType = TypeFactory.createArray(this.buildArrayType(arrayTypeText));
            result = arrayType;
        } else {
            TypeDescription elementType = this.findType(arrayTypeText, TypeFactory.getAny());
            assert (elementType != null) : "null element type";
            result = elementType;
        }
        return result;
    }

    private String findArrayType() {
        Attribute attr;
        String arrayType = null;
        for (SchemaElement element = this.getFirst(); !(element == null || element instanceof Attribute && (arrayType = (attr = (Attribute)element).getArrayType()) != null); element = element.getNext()) {
        }
        return arrayType;
    }
}

