/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.util.Identifier;
import oracle.bpm.xmlschema.SchemaElement;

class Enumeration
extends SchemaElement {
    private static final String UNSUPPORTED_PREFIX = "X_";

    Enumeration() {
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) {
        if (current != null && current.isEnum()) {
            EnumTypeDescription enumType = (EnumTypeDescription)current;
            String value = this.getValue();
            int memberCount = enumType.getMemberCount();
            String label = value;
            if (!(Identifier.isValid(label) || (label = Identifier.constant(label)) != null && label.length() != 0)) {
                label = UNSUPPORTED_PREFIX + memberCount;
            }
            enumType.addItem(label, memberCount, value);
        }
        return null;
    }

    String getValue() {
        return this.getAttribute("value");
    }
}

