/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.Identifier;
import oracle.bpm.xmlparser.Namespace;
import oracle.bpm.xmlschema.AttributeDef;
import oracle.bpm.xmlschema.ElementNotFoundException;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.Particle;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.XMLIntrospector;

public class ElementDef
extends AttributeDef {
    private static final String REF_ATTRIBUTE = "ref";
    private static final String QUALIFIED = "qualified";

    public ElementDef() {
    }

    public ElementDef(SchemaElement context, String name) {
        super(context);
        this.setTagName("element");
        this.setAttribute("name", name);
    }

    public static void setSignature(AttributeTypeDescription attr, String elementName, int maxOccurs, Namespace namespace, String elementNamespace, boolean elementIsQualified) {
        ElementDef.setSignature(attr, elementName, maxOccurs, namespace, elementNamespace, elementIsQualified, false);
    }

    public static void setSignature(AttributeTypeDescription attr, String elementName, int maxOccurs, Namespace namespace, String elementNamespace, boolean elementIsQualified, boolean isPartElement) {
        int signatureType;
        attr.setProperty("nativeName", elementName);
        if (attr.getReadSignature() == null || attr.getWriteSignature() == null) {
            attr.setReadSignature('A' + elementName);
            attr.setWriteSignature('A' + elementName);
        }
        if (attr.getType().isAny()) {
            attr.setType(XMLIntrospector.XMLOBJECT);
        }
        if (maxOccurs > 1) {
            signatureType = 78;
            attr.setType(TypeFactory.createArray(attr.getTypeRef()));
        } else {
            signatureType = isPartElement ? 90 : (attr.getType().isObject() || attr.getType().isAny() ? 69 : 86);
        }
        String signature = (char)signatureType + attr.getWriteSignature().substring(1);
        int index = signature.indexOf(59);
        if (index != -1) {
            signature = signature.substring(0, index);
        }
        signature = signature + ";" + ElementDef.buildSignature(attr.getType());
        signature = signature + ";";
        if (namespace != null && namespace.getUri() != null) {
            signature = signature + namespace.getUri().trim();
        }
        signature = signature + ";";
        if (elementNamespace != null) {
            signature = signature + elementNamespace;
        }
        signature = signature + ";" + (elementIsQualified ? "elementQualified" : "N");
        attr.setReadSignature(signature);
        attr.setWriteSignature(signature);
    }

    public void setMaxOccurs(String occurs) {
        this.setAttribute("maxOccurs", occurs);
    }

    public void setRef(String ref) {
        this.setAttribute(REF_ATTRIBUTE, ref);
    }

    public void setMinOccurs(String occurs) {
        this.setAttribute("minOccurs", occurs);
    }

    public String getFixed() {
        return this.getAttribute("fixed");
    }

    public String getDefaultValue() {
        return this.getAttribute("default");
    }

    @Override
    public TypeDescription buildType(TypeDescription current) throws TypeException {
        String defaultValue;
        String form;
        ExtendedNamespace target;
        boolean isRef;
        ExtendedNamespace targetNamespace;
        if (this.type != null) {
            return this.type;
        }
        String name = this.getName();
        ExtendedNamespace namespace = targetNamespace = this.getContext().getTarget();
        SchemaElement element = this.lookupElement();
        boolean isQualified = false;
        boolean bl = isRef = this.getRef() != null;
        if (element != null && (target = this.resolveNamespaceFromReferedElement()) != null && target.getUri() != null && !"".equals(target.getUri().trim())) {
            namespace = target;
            boolean isSubstitution = this.getSubstitutionGroup() != null;
            isQualified = isRef;
            if (isRef || isSubstitution) {
                targetNamespace = namespace;
            }
        }
        if ((form = this.getForm()) != null) {
            isQualified = QUALIFIED.equalsIgnoreCase(form);
        } else if (!isQualified && this.getSchema() != null && this.getSchema().isElementQualified()) {
            isQualified = true;
        }
        ExtendedNamespace currectNamespace = this.getContext().getTarget();
        this.getContext().setTarget(namespace);
        AttributeTypeDescription attr = this.buildAttribute(current, element);
        this.getContext().setTarget(currectNamespace);
        name = this.setNameAttribute(element, name, attr);
        String fixed = this.getFixed();
        if (fixed != null) {
            attr.setProperty("fixedValue", fixed);
        }
        if ((defaultValue = this.getDefaultValue()) != null) {
            attr.setProperty("defaultValue", defaultValue);
        }
        attr.setProperty("nativeNamespace", namespace.getUri());
        attr.setProperty("elementType", "elementType");
        attr.setProperty("isNilable", this.isNilable().toString());
        attr.setProperty("schemaLocationKey", this.getSchema().getSchemaLocationKey());
        String elementNamespace = targetNamespace.getUri();
        if (!isQualified && !isRef) {
            elementNamespace = "";
        }
        attr.setProperty("elementNamespace", elementNamespace);
        attr.setProperty("xmlObjectVersion", "2.0");
        this.type = attr;
        int maxOccurs = this.getMaxOccurs();
        ElementDef.setSignature(attr, name, maxOccurs, namespace, elementNamespace, isQualified);
        return attr;
    }

    public TypeDescription getContentType() throws TypeException {
        TypeDescription contentType;
        String xsdType = this.getType();
        if (xsdType != null) {
            ExtendedNamespace extendedNamespace;
            String elementName;
            int pos = xsdType.lastIndexOf(":");
            if (pos > -1) {
                elementName = xsdType.substring(pos + 1);
                String prefix = xsdType.substring(0, pos);
                extendedNamespace = (ExtendedNamespace)this.getContext().findNamespace(prefix);
            } else {
                elementName = xsdType;
                extendedNamespace = this.getTarget();
            }
            if (extendedNamespace != null && extendedNamespace.hasType(elementName)) {
                contentType = this.lookupType(elementName, extendedNamespace);
            } else {
                ExtendedNamespace ns = (ExtendedNamespace)this.getNSContext().findNamespaceByUri(this.getNamespace());
                contentType = this.lookupType(elementName, ns);
            }
        } else {
            contentType = this.getContext().getTarget().getAnonymousElementByParentName(Identifier.classname(Identifier.attribute(this.getName())));
        }
        return contentType;
    }

    public Boolean isNilable() {
        String nillableAttribute = this.getAttribute("nillable");
        return nillableAttribute != null && Boolean.valueOf(nillableAttribute) != false;
    }

    @Override
    protected void declare() throws TypeException {
        String name = this.getName();
        if (name != null) {
            this.getTarget().declareElement(name, this);
        }
    }

    int getMaxOccurs() {
        return Particle.getMaxOccurs(this);
    }

    int getMinOccurs() {
        return Particle.getMinOccurs(this);
    }

    private ExtendedNamespace resolveNamespaceFromReferedElement() {
        String elementName = this.resolveElementTypeName();
        ExtendedNamespace namespace = this.getContext().getTarget();
        if (elementName != null) {
            namespace = this.getContext().lookupNamespace(elementName);
        }
        return namespace;
    }

    private AttributeTypeDescription buildAttribute(TypeDescription current, SchemaElement element) throws TypeException {
        boolean isRef = this.getRef() != null;
        boolean isSubstitution = this.getSubstitutionGroup() != null && this.getType() == null;
        AttributeTypeDescription attr = isRef || isSubstitution ? (AttributeTypeDescription)element.buildType(null).clone() : super.buildType(current).asAttribute();
        return attr;
    }

    private String setNameAttribute(SchemaElement element, String name, AttributeTypeDescription attr) {
        boolean isSubstitution;
        boolean isRef = this.getRef() != null;
        boolean bl = isSubstitution = this.getSubstitutionGroup() != null;
        if (isRef) {
            ElementDef elementDef = (ElementDef)element;
            name = elementDef.getName();
        } else if (isSubstitution) {
            attr.setName(name);
        }
        return name;
    }

    private SchemaElement lookupElement() throws TypeException {
        SchemaElement result = null;
        String name = this.resolveElementTypeName();
        if (name != null) {
            boolean hasType = this.getType() != null;
            result = hasType ? this.getContext().lookupType(name) : this.getContext().lookupElement(name);
        }
        return result;
    }

    private String resolveElementTypeName() {
        String name = this.getRef();
        if (name == null) {
            name = this.getType();
        }
        if (name == null) {
            name = this.getSubstitutionGroup();
        }
        return name;
    }

    private TypeDescription lookupType(String elementName, ExtendedNamespace ns) throws TypeException {
        SchemaElement schemaElement = ns.lookupType(elementName);
        if (schemaElement == null) {
            throw new ElementNotFoundException(elementName, ns);
        }
        TypeDescription contentType = schemaElement.getTypeDescription();
        return contentType;
    }
}

