/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.Map;
import java.util.Set;
import oracle.bpm.type.utils.XmlUtils;
import oracle.bpm.xmlparser.Namespace;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlschema.Attribute;
import oracle.bpm.xmlschema.AttributeGroup;
import oracle.bpm.xmlschema.ElementDef;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.Group;
import oracle.bpm.xmlschema.NamespaceNotDeclaredException;
import oracle.bpm.xmlschema.SFSNamespace;
import oracle.bpm.xmlschema.SOAPNamespace;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;

public class Context
extends NamespaceContext {
    private Set<String> knownSchemas;
    private ExtendedNamespace target;
    static final long serialVersionUID = 9006533596340729406L;
    static final long serialCheck = -3552654455036422276L;

    public Context(NamespaceContext parent) {
        super(parent);
    }

    public void setTarget(String uri) {
        this.target = (ExtendedNamespace)this.findNamespaceByUri(uri);
        if (this.target == null) {
            this.target = new ExtendedNamespace(uri);
            ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace("");
            if (ns != null) {
                this.target.setDefault(ns);
            } else {
                this.addNamespace("", this.target);
            }
        }
        if (this.target != null) {
            this.target.setTarget(true);
        }
    }

    public void setTarget(ExtendedNamespace target) {
        this.target = target;
    }

    public ExtendedNamespace getTarget() {
        Context parent;
        if (this.target == null && (parent = (Context)this.getParent()) != null) {
            this.target = parent.getTarget();
        }
        assert (this.target == null || this.target.isTarget()) : String.valueOf(this.target);
        return this.target;
    }

    @Override
    public void addNamespace(String prefix, String uri) {
        Namespace ns;
        ExtendedNamespace target = this.getTarget();
        if (target != null && uri.equals(target.getUri())) {
            ns = target;
        } else if (XmlUtils.isSFS(uri)) {
            ns = SFSNamespace.get(uri);
        } else if (SOAPNamespace.isSOAPSchema(uri)) {
            ns = SOAPNamespace.get(uri);
        } else {
            ns = this.findNamespaceByUri(uri);
            if (ns == null) {
                ns = new ExtendedNamespace(uri);
            }
        }
        this.addNamespace(prefix, ns);
    }

    public Attribute lookupAttribute(String qname) throws TypeException {
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        return ns.lookupAttribute(name);
    }

    public AttributeGroup lookupAttributeGroup(String qname) throws TypeException {
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        return ns.lookupAttributeGroup(name);
    }

    public ExtendedNamespace lookupNamespace(String qname) {
        String prefix = Context.prefix(qname);
        return (ExtendedNamespace)this.findNamespace(prefix);
    }

    public ElementDef lookupElement(String qname) throws TypeException {
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        return ns.lookupElement(name);
    }

    public Group lookupGroup(String qname) throws TypeException {
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        return ns.lookupGroup(name);
    }

    public SchemaElement lookupType(String qname) throws TypeException {
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        return ns.lookupType(name);
    }

    public boolean isSFSElement(String qname) {
        String prefix = Context.prefix(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        return ns != null && XmlUtils.isSFS(ns.getUri());
    }

    public void setKnownSchemas(Set<String> knownSchemas) {
        this.knownSchemas = knownSchemas;
    }

    public boolean isKnownSchema(String namespace) {
        boolean ret = false;
        if (this.knownSchemas != null) {
            ret = this.knownSchemas.contains(namespace);
        } else {
            boolean knownSchemasFound = false;
            Context contxParent = (Context)this.getParent();
            while (contxParent != null && !knownSchemasFound) {
                if (contxParent.knownSchemas != null) {
                    ret = contxParent.knownSchemas.contains(namespace);
                    knownSchemasFound = true;
                }
                if (contxParent.getParent() != null) {
                    contxParent = (Context)contxParent.getParent();
                    continue;
                }
                contxParent = null;
            }
        }
        return ret;
    }

    void updateNamespace(ExtendedNamespace ns) {
        ExtendedNamespace currentNS = (ExtendedNamespace)this.findNamespaceByUri(ns.getUri());
        currentNS.updateFrom(ns);
    }

    void setNamespace(ExtendedNamespace ns) {
        Map<String, Namespace> byURI = this.getDeclaredNamespaces();
        byURI.put(ns.getUri(), ns);
    }

    private static String localname(String qname) {
        int index = qname.indexOf(58);
        if (index != -1) {
            qname = qname.substring(index + 1);
        }
        return qname;
    }

    private static String prefix(String qname) {
        int index = qname.indexOf(58);
        String prefix = "";
        if (index != -1) {
            prefix = qname.substring(0, index);
        }
        return prefix;
    }
}

