/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.Identifier;
import oracle.bpm.xmlschema.InvalidAttrNameException;
import oracle.bpm.xmlschema.MissingNameOrReferenceException;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;

public abstract class AttributeDef
extends SchemaElement {
    private static final String QUALIFIED = "qualified";

    protected AttributeDef() {
    }

    protected AttributeDef(SchemaElement element) {
        super(element);
    }

    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        assert (this.getRef() == null) : "Reference must be processed in subclass";
        String type = this.getType();
        String name = this.getName();
        if (name == null) {
            throw new MissingNameOrReferenceException(this);
        }
        AttributeTypeDescription attr = new AttributeTypeDescription(Identifier.attribute(name), TypeFactory.getAny());
        if (!this.isValidId(attr.getName())) {
            throw new InvalidAttrNameException((SchemaElement)this, name);
        }
        attr.setReadSignature('A' + name);
        attr.setWriteSignature('A' + name);
        if (type != null) {
            SchemaElement schemaElement = this.getContext().lookupType(type);
            attr.setProperty("xsdType", schemaElement.getNamespace() + ":" + schemaElement.getAttribute("name"));
            attr.setType(this.findType(type, TypeFactory.getAny()));
        }
        this.type = attr;
        TypeDescription redefType = this.buildSubElements(attr);
        if (redefType != null && !redefType.isAttribute()) {
            name = redefType.getName();
            if ((redefType.isObject() || redefType.isEnum()) && (name == null || name.equals(""))) {
                name = Identifier.classname(attr.getName());
                redefType.asObject().setName(name);
                this.getTarget().declareAnonymous(redefType);
            }
            attr.setType(redefType);
        }
        this.addAnnotations(attr);
        return attr;
    }

    String getRef() {
        return this.getAttribute("ref");
    }

    String getSubstitutionGroup() {
        return this.getAttribute("substitutionGroup");
    }

    String getType() {
        return this.getAttribute("type");
    }

    String getForm() {
        return this.getAttribute("form");
    }

    private boolean isValidId(String name) {
        return true;
    }
}

