/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.xmlparser.Namespace;
import oracle.bpm.xmlruntime.XMLSignatureParser;
import oracle.bpm.xmlschema.AttributeDef;
import oracle.bpm.xmlschema.AttributeUse;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.TypeException;

public class Attribute
extends AttributeDef {
    public Attribute() {
    }

    public Attribute(AttributeTypeDescription type) {
        this.type = type;
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        AttributeTypeDescription attr;
        if (this.type != null) {
            return this.type;
        }
        String ref = this.getRef();
        Boolean isQualified = this.getSchema().isAttributeQualified();
        ExtendedNamespace currentNamespace = this.getContext().getTarget();
        String elementNamespace = currentNamespace.getUri();
        if (ref != null) {
            Attribute attributeElement = this.getContext().lookupAttribute(ref);
            attr = (AttributeTypeDescription)attributeElement.buildType(null);
            elementNamespace = attributeElement.getTarget().getUri();
            isQualified = true;
        } else {
            String defaultValue;
            attr = super.buildType(current).asAttribute();
            if (attr.getType().isAny()) {
                attr.setType(TypeFactory.getString());
            }
            String typeSig = Attribute.buildSignature(attr.getType());
            attr.setReadSignature(attr.getReadSignature() + ";" + typeSig);
            attr.setWriteSignature(attr.getWriteSignature() + ";" + typeSig);
            String fixed = this.getFixed();
            if (fixed != null) {
                attr.setProperty("fixedValue", fixed);
            }
            if ((defaultValue = this.getDefault()) != null) {
                attr.setProperty("defaultValue", defaultValue);
            }
            attr.setProperty("isXsdAttribute", Boolean.TRUE.toString());
            attr.setProperty("nativeName", this.getName());
            this.type = attr;
            String form = this.getForm();
            if (form != null) {
                isQualified = "qualified".equals(form);
                attr.setProperty("isFormQualified", isQualified.toString());
            }
        }
        if (attr != null) {
            if (!isQualified.booleanValue()) {
                elementNamespace = "";
            }
            attr.setProperty("elementNamespace", elementNamespace);
            attr.setProperty("qualified", isQualified.toString());
            attr.setProperty("xmlObjectVersion", "2.0");
            String signature = attr.getReadSignature();
            signature = XMLSignatureParser.replaceAttributeElementNamespace(signature, elementNamespace);
            attr.setReadSignature(signature);
            attr.setWriteSignature(signature);
        }
        return attr;
    }

    @Override
    protected void declare() throws TypeException {
        String name = this.getName();
        if (name != null) {
            this.getTarget().declareAttribute(name, this);
        }
    }

    String getArrayType() {
        String nspace = "http://schemas.xmlsoap.org/wsdl/";
        String attrName = "arrayType";
        QName qname = new QName(nspace, attrName);
        String value = this.getAttribute(qname);
        if (value == null) {
            Map<QName, String> attributes = this.getAttributes();
            Set<Map.Entry<QName, String>> entries = attributes.entrySet();
            for (Map.Entry<QName, String> pair : entries) {
                Namespace ns;
                String name = pair.getKey().getLocalPart();
                if (!name.endsWith(":" + attrName) && !name.equals(attrName)) continue;
                int index = name.lastIndexOf(":");
                String prefix = "";
                if (index != -1) {
                    prefix = name.substring(0, index);
                }
                if ((ns = this.getContext().findNamespace(prefix)) == null || !ns.getUri().equals(nspace)) continue;
                value = pair.getValue();
                break;
            }
        }
        return value;
    }

    String getFixed() {
        return this.getAttribute("fixed");
    }

    String getDefault() {
        return this.getAttribute("default");
    }

    boolean isFormQualified() {
        String form = this.getForm();
        boolean qualified = form != null ? "qualified".equals(form) : this.getSchema().isAttributeQualified();
        return qualified;
    }

    int getUse() {
        return AttributeUse.valueOf(this.getAttribute("use"));
    }
}

