/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.xmlruntime.XMLObject;

public class XmlAttribute {
    private QName name;
    private XMLObject parent;
    private String value;

    public XmlAttribute(Map.Entry<QName, String> entry, XMLObject parent) {
        this(entry.getKey(), entry.getValue(), parent);
    }

    public XmlAttribute(QName name, String value, XMLObject parent) {
        this.name = name;
        this.value = value;
        this.parent = parent;
    }

    public QName getName() {
        return this.name;
    }

    public void setParent(XMLObject parent) {
        this.parent = parent;
    }

    public XMLObject getParent() {
        return this.parent;
    }

    public void setValue(String value) {
        XMLObject parent = this.getParent();
        if (parent != null) {
            parent.getAttributes().put(this.getName(), value);
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    static class AttributeIterator
    implements Iterator {
        private Iterator<Map.Entry<QName, String>> it;
        private XMLObject parent;

        public AttributeIterator(Map<QName, String> attributes, XMLObject parent) {
            this.parent = parent;
            this.it = attributes.entrySet().iterator();
        }

        public XMLObject getParent() {
            return this.parent;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            Map.Entry<QName, String> entry = this.it.next();
            return entry != null ? new XmlAttribute(entry, this.parent) : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

