/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.Map;
import java.util.Set;
import oracle.bpm.xmlparser.Element;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmlruntime.XMLText;
import oracle.bpm.xmlruntime.XmlAttribute;
import oracle.bpm.xmlruntime.XmlObjectWithNamespacesJaxenNavigator;
import oracle.bpm.xmlschema.Context;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.SimpleNamespaceContext;

public class XPathUtils {
    private static final String DECLARE_NAMESPACE = "declare namespace";
    private static final int DECLARE_NAMESPACE_LENGTH = "declare namespace".length();

    public static String buildDeclarationsPrefix(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> declarations = context.getAllPrefixToUriMap();
        Set<Map.Entry<String, String>> entries = declarations.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String namespace = entry.getValue();
            String prefix = entry.getKey();
            stringBuilder.append(DECLARE_NAMESPACE);
            stringBuilder.append(' ');
            stringBuilder.append(prefix);
            stringBuilder.append('=');
            stringBuilder.append('\"');
            stringBuilder.append(namespace);
            stringBuilder.append('\"');
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public static BaseXPath createXPath(String xpath, Navigator navigator) throws JaxenException {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        xpath = XPathUtils.buildNamespaceContext(xpath, simpleNamespaceContext);
        BaseXPath baseXPath = new BaseXPath(xpath, navigator);
        baseXPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        return baseXPath;
    }

    public static BaseXPath createXPath(String xpath) throws JaxenException {
        return XPathUtils.createXPath(xpath, (Navigator)XmlObjectWithNamespacesJaxenNavigator.getInstance());
    }

    public static String getTextValue(Object fromObject) {
        String value = null;
        if (fromObject instanceof XMLText) {
            XMLText xmlText = (XMLText)fromObject;
            value = xmlText.getText();
        } else if (fromObject instanceof XMLObject) {
            XMLObject xmlObject = (XMLObject)fromObject;
            Element xmlObjectLastChild = xmlObject.getLastChild();
            if (xmlObjectLastChild instanceof XMLText) {
                XMLText xmlText = (XMLText)xmlObjectLastChild;
                value = xmlText.getText();
            }
        } else if (fromObject instanceof XmlAttribute) {
            value = ((XmlAttribute)fromObject).getValue();
        } else if (fromObject instanceof String) {
            value = (String)fromObject;
        }
        return value;
    }

    private static String buildNamespaceContext(String xpath, SimpleNamespaceContext simpleNamespaceContext) {
        while (xpath.startsWith(DECLARE_NAMESPACE)) {
            int offset = xpath.indexOf(";");
            String declaration = xpath.substring(DECLARE_NAMESPACE_LENGTH, offset);
            xpath = xpath.substring(offset + 1);
            XPathUtils.buildDeclaration(declaration, simpleNamespaceContext);
        }
        return xpath;
    }

    private static void buildDeclaration(String declaration, SimpleNamespaceContext simpleNamespaceContext) {
        int offset = declaration.indexOf("=");
        String prefix = declaration.substring(0, offset);
        prefix = prefix.trim();
        String uri = declaration.substring(offset + 1);
        uri = uri.trim();
        uri = XPathUtils.unquote(uri);
        if (prefix.length() > 0) {
            simpleNamespaceContext.addNamespace(prefix, uri);
        }
    }

    private static String unquote(String text) {
        String result = text.trim();
        char firstChar = result.charAt(0);
        char lastChar = result.charAt(result.length() - 1);
        if (firstChar == '\"' && lastChar == '\"' || firstChar == '\'' && lastChar == '\'') {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }
}

