/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.xmlruntime.SerializationContext;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmlruntime.XMLObjectBaseSerializer;

public class XMLObjectV2Serializer
extends XMLObjectBaseSerializer {
    private static XMLObjectV2Serializer instance = new XMLObjectV2Serializer();

    private XMLObjectV2Serializer() {
    }

    public static XMLObjectBaseSerializer getInstance() {
        return instance;
    }

    @Override
    public void serialize(ObjectTypeDescription typeDescription, XMLObject xmlObject, boolean isRoot, SerializationContext context) {
        boolean elementIsQualified;
        String currentNamespace = xmlObject.getElementNamespace() == null ? xmlObject.getNamespace() : xmlObject.getElementNamespace();
        boolean hasNamespace = currentNamespace != null && !"".equals(currentNamespace.trim());
        boolean bl = elementIsQualified = (isRoot || xmlObject.hasElementNamespace()) && hasNamespace;
        if (elementIsQualified) {
            IndentedPrintWriter output = context.getOutput();
            String prefix = this.findOrCreatePrefix(context, currentNamespace, xmlObject);
            output.print(prefix);
            output.print(':');
        }
        this.serialize(context, typeDescription, xmlObject, currentNamespace, elementIsQualified, isRoot);
    }
}

