/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.component.Instantiator;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.xmlparser.Parser;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlruntime.SoapFaultException;
import oracle.bpm.xmlruntime.XMLElementFactory;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmlruntime.XMLObjectTypeUpdater;
import oracle.bpm.xmlruntime.XMLSignatureParser;
import oracle.bpm.xmlruntime.XMLText;

public class XMLInstantiator
extends Instantiator {
    public static XMLObject createTree(String xml) throws ComponentExecutionException {
        XMLObject root;
        Parser xmlParser = new Parser();
        xmlParser.setElementFactory(new XMLElementFactory());
        try {
            URL url = XMLInstantiator.checkFile(xml);
            if (url == null) {
                url = XMLInstantiator.checkUrl(xml);
            }
            root = url == null ? (XMLObject)xmlParser.parse(null, xml) : (XMLObject)xmlParser.parse(url);
        }
        catch (ParserException e) {
            throw new ComponentExecutionException(e);
        }
        boolean disableNamesSpaces = Boolean.getBoolean("oracle.bpm.xml.disableNamespacesForLoad");
        if (!disableNamesSpaces) {
            XMLInstantiator.setObjectNamespaces(root);
        }
        return root;
    }

    @Override
    public Invokeable instantiate(String qualifiedName, String classname) throws ClassNotFoundException, ComponentExecutionException {
        return new XMLObject(classname, new HashMap<QName, String>(), null, false);
    }

    @Override
    public Invokeable instantiate(String qualifiedName, String classname, String constructor, Object[] inputArgs) throws ClassNotFoundException, ComponentExecutionException {
        XMLObject object;
        String[] parts = XMLSignatureParser.getConstructorParts(constructor);
        String namespace = null;
        boolean elementsAreQualified = false;
        if (parts.length > 1) {
            namespace = parts[1];
        }
        if (parts.length > 2) {
            elementsAreQualified = parts[2].equals("elementsQualified");
        }
        Object[] args = XMLInstantiator.processInputArguments(inputArgs);
        switch (constructor.charAt(0)) {
            case 'D': {
                String name = parts[0].substring(1);
                object = new XMLObject(name, namespace, elementsAreQualified);
                break;
            }
            case 'F': {
                object = new XMLObject((String)args[0], (Map)args[1], namespace, elementsAreQualified);
                break;
            }
            case 'X': {
                object = XMLInstantiator.createTree((String)args[0]);
                break;
            }
            case 'L': {
                String name = parts[0].substring(1);
                this.createSoapFaultException(inputArgs, namespace, elementsAreQualified, name);
                object = new SoapFaultException(name);
                object.setNamespace(namespace);
                object.setElementFormDefaultIsQualified(elementsAreQualified);
                break;
            }
            case 'T': {
                String name = parts[0].substring(1);
                SoapFaultException soapFaultException = this.createSoapFaultException(inputArgs, namespace, elementsAreQualified, name);
                soapFaultException.addChild(new XMLText((String)inputArgs[5]));
                object = soapFaultException;
                break;
            }
            case 'O': {
                String name = parts[0].substring(1);
                SoapFaultException soapFaultException = this.createSoapFaultException(inputArgs, namespace, elementsAreQualified, name);
                soapFaultException.addChild((XMLObject)inputArgs[5]);
                object = soapFaultException;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid constructor signature: " + constructor);
            }
        }
        object.setFuegoName(qualifiedName);
        object.setElementIsQualified(elementsAreQualified);
        XMLInstantiator.processInputAttributes(object, inputArgs);
        XMLObjectTypeUpdater.updateTypeDescription(object);
        return object;
    }

    private static URL checkUrl(String xml) {
        URL url = null;
        try {
            url = xml.startsWith("file://") ? new File(xml.substring(7)).toURL() : new URL(xml);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    private static URL checkFile(String xml) {
        URL url = null;
        try {
            File f = new File(xml).getCanonicalFile();
            if (f.exists() && f.isFile()) {
                url = f.toURL();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return url;
    }

    private static void setObjectNamespaces(XMLObject root) {
        if (root.getNamespace() != null && !"".equals(root.getNamespace())) {
            root.setElementIsQualified(true);
        }
        if (root.getChildren() != null) {
            Iterator i$ = root.getChildren().iterator();
            while (i$.hasNext()) {
                XMLObject child;
                XMLObject tempObject = child = (XMLObject)i$.next();
                XMLInstantiator.setObjectNamespaces(tempObject);
            }
        }
    }

    private SoapFaultException createSoapFaultException(Object[] inputArgs, String namespace, boolean elementsAreQualified, String name) {
        SoapFaultException object = new SoapFaultException(name);
        object.setNamespace(namespace);
        if (inputArgs != null) {
            object.setFaultCode((String)inputArgs[1]);
            object.setFaultString((String)inputArgs[3]);
        }
        object.setElementFormDefaultIsQualified(elementsAreQualified);
        return object;
    }
}

